/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.interval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.FilterExprAnalyzerDTIntervalAffector;
import com.espertech.esper.epl.datetime.interval.ExprEvaluatorStreamDTProp;
import com.espertech.esper.epl.datetime.interval.ExprEvaluatorStreamDTPropFragment;
import com.espertech.esper.epl.datetime.interval.IntervalComputerEval;
import com.espertech.esper.epl.datetime.interval.IntervalComputerForge;
import com.espertech.esper.epl.datetime.interval.IntervalComputerForgeFactory;
import com.espertech.esper.epl.datetime.interval.IntervalForge;
import com.espertech.esper.epl.datetime.interval.IntervalForgeOp;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class IntervalForgeImpl
implements IntervalForge {
    private ExprForge forgeTimestamp;
    private Integer parameterStreamNum;
    private String parameterPropertyStart;
    private String parameterPropertyEnd;
    private final IntervalOpForge intervalOpForge;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IntervalForgeImpl(DatetimeMethodEnum method, String methodNameUse, StreamTypeService streamTypeService, List<ExprNode> expressions, TimeZone timeZone, TimeAbacus timeAbacus) throws ExprValidationException {
        void var7_12;
        Class timestampType;
        Object var7_7 = null;
        if (expressions.get(0) instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)expressions.get(0);
            this.parameterStreamNum = und.getStreamId();
            EventType type = streamTypeService.getEventTypes()[this.parameterStreamNum];
            this.parameterPropertyStart = type.getStartTimestampPropertyName();
            if (this.parameterPropertyStart == null) {
                throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter is event type '" + type.getName() + "', however no timestamp property has been defined for this event type");
            }
            timestampType = type.getPropertyType(this.parameterPropertyStart);
            EventPropertyGetterSPI getter = ((EventTypeSPI)type).getGetterSPI(this.parameterPropertyStart);
            Class getterReturnTypeBoxed = JavaClassHelper.getBoxedType(type.getPropertyType(this.parameterPropertyStart));
            this.forgeTimestamp = new ExprEvaluatorStreamDTProp(this.parameterStreamNum, getter, getterReturnTypeBoxed);
            if (type.getEndTimestampPropertyName() != null) {
                this.parameterPropertyEnd = type.getEndTimestampPropertyName();
                EventPropertyGetterSPI getterEndTimestamp = ((EventTypeSPI)type).getGetterSPI(type.getEndTimestampPropertyName());
                ExprEvaluatorStreamDTProp exprEvaluatorStreamDTProp = new ExprEvaluatorStreamDTProp(this.parameterStreamNum, getterEndTimestamp, getterReturnTypeBoxed);
            } else {
                this.parameterPropertyEnd = this.parameterPropertyStart;
            }
        } else {
            this.forgeTimestamp = expressions.get(0).getForge();
            timestampType = this.forgeTimestamp.getEvaluationType();
            String unresolvedPropertyName = null;
            if (expressions.get(0) instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)expressions.get(0);
                this.parameterStreamNum = identNode.getStreamId();
                this.parameterPropertyEnd = this.parameterPropertyStart = identNode.getResolvedPropertyName();
                unresolvedPropertyName = identNode.getUnresolvedPropertyName();
            }
            if (!JavaClassHelper.isDatetimeClass(this.forgeTimestamp.getEvaluationType())) {
                if (unresolvedPropertyName == null) throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter expression returns '" + this.forgeTimestamp.getEvaluationType() + "', however requires a Date, Calendar, Long-type return value or event (with timestamp)");
                Pair<PropertyResolutionDescriptor, String> propertyDesc = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, unresolvedPropertyName, false, true);
                if (propertyDesc.getFirst().getFragmentEventType() != null) {
                    EventType type = propertyDesc.getFirst().getFragmentEventType().getFragmentType();
                    this.parameterPropertyStart = type.getStartTimestampPropertyName();
                    if (this.parameterPropertyStart == null) {
                        throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter is event type '" + type.getName() + "', however no timestamp property has been defined for this event type");
                    }
                    timestampType = type.getPropertyType(this.parameterPropertyStart);
                    EventPropertyGetterSPI getterFragment = ((EventTypeSPI)streamTypeService.getEventTypes()[this.parameterStreamNum]).getGetterSPI(unresolvedPropertyName);
                    EventPropertyGetterSPI getterStartTimestamp = ((EventTypeSPI)type).getGetterSPI(this.parameterPropertyStart);
                    this.forgeTimestamp = new ExprEvaluatorStreamDTPropFragment(this.parameterStreamNum, getterFragment, getterStartTimestamp);
                    if (type.getEndTimestampPropertyName() != null) {
                        this.parameterPropertyEnd = type.getEndTimestampPropertyName();
                        EventPropertyGetterSPI getterEndTimestamp = ((EventTypeSPI)type).getGetterSPI(type.getEndTimestampPropertyName());
                        ExprEvaluatorStreamDTPropFragment exprEvaluatorStreamDTPropFragment = new ExprEvaluatorStreamDTPropFragment(this.parameterStreamNum, getterFragment, getterEndTimestamp);
                    } else {
                        this.parameterPropertyEnd = this.parameterPropertyStart;
                    }
                }
            }
        }
        IntervalComputerForge intervalComputerForge = IntervalComputerForgeFactory.make(method, expressions, timeAbacus);
        if (var7_12 == null) {
            if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Calendar.class)) {
                this.intervalOpForge = new IntervalOpCalForge(intervalComputerForge);
                return;
            } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Date.class)) {
                this.intervalOpForge = new IntervalOpDateForge(intervalComputerForge);
                return;
            } else if (JavaClassHelper.getBoxedType(timestampType) == Long.class) {
                this.intervalOpForge = new IntervalOpForgeLong(intervalComputerForge);
                return;
            } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, LocalDateTime.class)) {
                this.intervalOpForge = new IntervalOpLocalDateTimeForge(intervalComputerForge, timeZone);
                return;
            } else {
                if (!JavaClassHelper.isSubclassOrImplementsInterface(timestampType, ZonedDateTime.class)) throw new IllegalArgumentException("Invalid interval first parameter type '" + timestampType + "'");
                this.intervalOpForge = new IntervalOpZonedDateTimeForge(intervalComputerForge);
            }
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Calendar.class)) {
            this.intervalOpForge = new IntervalOpCalWithEndForge(intervalComputerForge, (ExprForge)var7_12);
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Date.class)) {
            this.intervalOpForge = new IntervalOpDateWithEndForge(intervalComputerForge, (ExprForge)var7_12);
            return;
        } else if (JavaClassHelper.getBoxedType(timestampType) == Long.class) {
            this.intervalOpForge = new IntervalOpLongWithEndForge(intervalComputerForge, (ExprForge)var7_12);
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, LocalDateTime.class)) {
            this.intervalOpForge = new IntervalOpLocalDateTimeWithEndForge(intervalComputerForge, (ExprForge)var7_12, timeZone);
            return;
        } else {
            if (!JavaClassHelper.isSubclassOrImplementsInterface(timestampType, ZonedDateTime.class)) throw new IllegalArgumentException("Invalid interval first parameter type '" + timestampType + "'");
            this.intervalOpForge = new IntervalOpZonedDateTimeWithEndForge(intervalComputerForge, (ExprForge)var7_12);
        }
    }

    @Override
    public IntervalOp getOp() {
        return new IntervalForgeOp(this.forgeTimestamp.getExprEvaluator(), this.intervalOpForge.makeEval());
    }

    @Override
    public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return IntervalForgeOp.codegen(this, start, end, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public ExprForge getForgeTimestamp() {
        return this.forgeTimestamp;
    }

    public IntervalOpForge getIntervalOpForge() {
        return this.intervalOpForge;
    }

    @Override
    public FilterExprAnalyzerDTIntervalAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        String targetPropertyEnd;
        String targetPropertyStart;
        int targetStreamNum;
        if (currentParameters.size() > 1) {
            return null;
        }
        if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputStream) {
            ExprDotNodeFilterAnalyzerInputStream targetStream = (ExprDotNodeFilterAnalyzerInputStream)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            EventType targetType = typesPerStream[targetStreamNum];
            targetPropertyStart = targetType.getStartTimestampPropertyName();
            targetPropertyEnd = targetType.getEndTimestampPropertyName() != null ? targetType.getEndTimestampPropertyName() : targetPropertyStart;
        } else if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputProp) {
            ExprDotNodeFilterAnalyzerInputProp targetStream = (ExprDotNodeFilterAnalyzerInputProp)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            targetPropertyStart = targetStream.getPropertyName();
            targetPropertyEnd = targetStream.getPropertyName();
        } else {
            return null;
        }
        if (this.parameterPropertyStart == null) {
            return null;
        }
        return new FilterExprAnalyzerDTIntervalAffector(currentMethod, typesPerStream, targetStreamNum, targetPropertyStart, targetPropertyEnd, this.parameterStreamNum, this.parameterPropertyStart, this.parameterPropertyEnd);
    }

    public static class IntervalOpZonedDateTimeWithEndEval
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpZonedDateTimeWithEndEval(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, DatetimeLongCoercerZonedDateTime.coerceZDTToMillis((ZonedDateTime)parameterStartTs), DatetimeLongCoercerZonedDateTime.coerceZDTToMillis((ZonedDateTime)parameterEndTs), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpZonedDateTimeWithEndForge
    extends IntervalOpForgeDateWithEndBase {
        public IntervalOpZonedDateTimeWithEndForge(IntervalComputerForge intervalComputer, ExprForge evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpZonedDateTimeWithEndEval(this.intervalComputer.makeComputerEval(), this.forgeEndTimestamp.getExprEvaluator());
        }

        @Override
        protected CodegenExpression codegenEvaluate(CodegenExpressionRef startTs, CodegenExpressionRef endTs, CodegenExpressionRef paramStartTs, CodegenExpressionRef paramEndTs, CodegenMethodNode parentNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.intervalComputer.codegen(startTs, endTs, CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", paramStartTs), CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", paramEndTs), parentNode, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpLocalDateTimeWithEndEval
    extends IntervalOpEvalDateWithEndBase {
        private final TimeZone timeZone;

        public IntervalOpLocalDateTimeWithEndEval(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp, TimeZone timeZone) {
            super(intervalComputer, evaluatorEndTimestamp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone((LocalDateTime)parameterStartTs, this.timeZone), DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone((LocalDateTime)parameterEndTs, this.timeZone), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpLocalDateTimeWithEndForge
    extends IntervalOpForgeDateWithEndBase {
        private final TimeZone timeZone;

        public IntervalOpLocalDateTimeWithEndForge(IntervalComputerForge intervalComputer, ExprForge evaluatorEndTimestamp, TimeZone timeZone) {
            super(intervalComputer, evaluatorEndTimestamp);
            this.timeZone = timeZone;
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpLocalDateTimeWithEndEval(this.intervalComputer.makeComputerEval(), this.forgeEndTimestamp.getExprEvaluator(), this.timeZone);
        }

        @Override
        protected CodegenExpression codegenEvaluate(CodegenExpressionRef startTs, CodegenExpressionRef endTs, CodegenExpressionRef paramStartTs, CodegenExpressionRef paramEndTs, CodegenMethodNode parentNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
            return this.intervalComputer.codegen(startTs, endTs, CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", paramStartTs, CodegenExpressionBuilder.member(tz.getMemberId())), CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", paramEndTs, CodegenExpressionBuilder.member(tz.getMemberId())), parentNode, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpCalWithEndEval
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpCalWithEndEval(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, ((Calendar)parameterStartTs).getTimeInMillis(), ((Calendar)parameterEndTs).getTimeInMillis(), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpCalWithEndForge
    extends IntervalOpForgeDateWithEndBase {
        public IntervalOpCalWithEndForge(IntervalComputerForge intervalComputer, ExprForge forgeEndTimestamp) {
            super(intervalComputer, forgeEndTimestamp);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpCalWithEndEval(this.intervalComputer.makeComputerEval(), this.forgeEndTimestamp.getExprEvaluator());
        }

        @Override
        protected CodegenExpression codegenEvaluate(CodegenExpressionRef startTs, CodegenExpressionRef endTs, CodegenExpressionRef paramStartTs, CodegenExpressionRef paramEndTs, CodegenMethodNode parentNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.intervalComputer.codegen(startTs, endTs, CodegenExpressionBuilder.exprDotMethod(paramStartTs, "getTimeInMillis", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(paramEndTs, "getTimeInMillis", new CodegenExpression[0]), parentNode, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpLongWithEndEval
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpLongWithEndEval(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, (Long)parameterStartTs, (Long)parameterEndTs, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpLongWithEndForge
    extends IntervalOpForgeDateWithEndBase {
        public IntervalOpLongWithEndForge(IntervalComputerForge intervalComputer, ExprForge evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpLongWithEndEval(this.intervalComputer.makeComputerEval(), this.forgeEndTimestamp.getExprEvaluator());
        }

        @Override
        protected CodegenExpression codegenEvaluate(CodegenExpressionRef startTs, CodegenExpressionRef endTs, CodegenExpressionRef paramStartTs, CodegenExpressionRef paramEndTs, CodegenMethodNode parentNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.intervalComputer.codegen(startTs, endTs, paramStartTs, paramEndTs, parentNode, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpDateWithEndEval
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpDateWithEndEval(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, ((Date)parameterStartTs).getTime(), ((Date)parameterEndTs).getTime(), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpDateWithEndForge
    extends IntervalOpForgeDateWithEndBase {
        public IntervalOpDateWithEndForge(IntervalComputerForge intervalComputer, ExprForge evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpDateWithEndEval(this.intervalComputer.makeComputerEval(), this.forgeEndTimestamp.getExprEvaluator());
        }

        @Override
        protected CodegenExpression codegenEvaluate(CodegenExpressionRef startTs, CodegenExpressionRef endTs, CodegenExpressionRef paramStartTs, CodegenExpressionRef paramEndTs, CodegenMethodNode parentNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.intervalComputer.codegen(startTs, endTs, CodegenExpressionBuilder.exprDotMethod(paramStartTs, "getTime", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(paramEndTs, "getTime", new CodegenExpression[0]), parentNode, exprSymbol, codegenClassScope);
        }
    }

    public static abstract class IntervalOpEvalDateWithEndBase
    implements IntervalOpEval {
        protected final IntervalComputerEval intervalComputer;
        private final ExprEvaluator evaluatorEndTimestamp;

        protected IntervalOpEvalDateWithEndBase(IntervalComputerEval intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            this.intervalComputer = intervalComputer;
            this.evaluatorEndTimestamp = evaluatorEndTimestamp;
        }

        public abstract Object evaluate(long var1, long var3, Object var5, Object var6, EventBean[] var7, boolean var8, ExprEvaluatorContext var9);

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object paramEndTs = this.evaluatorEndTimestamp.evaluate(eventsPerStream, isNewData, context);
            if (paramEndTs == null) {
                return null;
            }
            return this.evaluate(startTs, endTs, parameterStartTs, paramEndTs, eventsPerStream, isNewData, context);
        }
    }

    public static abstract class IntervalOpForgeDateWithEndBase
    implements IntervalOpForge {
        protected final IntervalComputerForge intervalComputer;
        protected final ExprForge forgeEndTimestamp;

        public IntervalOpForgeDateWithEndBase(IntervalComputerForge intervalComputer, ExprForge forgeEndTimestamp) {
            this.intervalComputer = intervalComputer;
            this.forgeEndTimestamp = forgeEndTimestamp;
        }

        protected abstract CodegenExpression codegenEvaluate(CodegenExpressionRef var1, CodegenExpressionRef var2, CodegenExpressionRef var3, CodegenExpressionRef var4, CodegenMethodNode var5, ExprForgeCodegenSymbol var6, CodegenClassScope var7);

        @Override
        public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalOpForgeDateWithEndBase.class, codegenClassScope).addParam(Long.TYPE, "startTs").addParam(Long.TYPE, "endTs").addParam(parameterType, "paramStartTs");
            Class evaluationType = this.forgeEndTimestamp.getEvaluationType();
            methodNode.getBlock().declareVar(evaluationType, "paramEndTs", this.forgeEndTimestamp.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope));
            if (!evaluationType.isPrimitive()) {
                methodNode.getBlock().ifRefNullReturnNull("paramEndTs");
            }
            CodegenExpression expression = this.codegenEvaluate(CodegenExpressionBuilder.ref("startTs"), CodegenExpressionBuilder.ref("endTs"), CodegenExpressionBuilder.ref("paramStartTs"), CodegenExpressionBuilder.ref("paramEndTs"), methodNode, exprSymbol, codegenClassScope);
            methodNode.getBlock().methodReturn(expression);
            return CodegenExpressionBuilder.localMethod(methodNode, start, end, parameter);
        }
    }

    public static class IntervalOpZonedDateTimeEval
    extends IntervalOpEvalBase {
        public IntervalOpZonedDateTimeEval(IntervalComputerEval intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = DatetimeLongCoercerZonedDateTime.coerceZDTToMillis((ZonedDateTime)parameter);
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }

        public static CodegenExpression codegen(IntervalOpZonedDateTimeForge forge, CodegenExpression start, CodegenExpression end, CodegenExpression parameter, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalOpZonedDateTimeEval.class, codegenClassScope).addParam(Long.TYPE, "startTs").addParam(Long.TYPE, "endTs").addParam(ZonedDateTime.class, "parameter");
            methodNode.getBlock().declareVar(Long.TYPE, "time", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("parameter"))).methodReturn(forge.intervalComputer.codegen(CodegenExpressionBuilder.ref("startTs"), CodegenExpressionBuilder.ref("endTs"), CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
            return CodegenExpressionBuilder.localMethod(methodNode, start, end, parameter);
        }
    }

    public static class IntervalOpZonedDateTimeForge
    extends IntervalOpForgeBase {
        public IntervalOpZonedDateTimeForge(IntervalComputerForge intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpZonedDateTimeEval(this.intervalComputer.makeComputerEval());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalOpZonedDateTimeEval.codegen(this, start, end, parameter, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpLocalDateTimeEval
    extends IntervalOpEvalBase {
        private final TimeZone timeZone;

        public IntervalOpLocalDateTimeEval(IntervalComputerEval intervalComputer, TimeZone timeZone) {
            super(intervalComputer);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone((LocalDateTime)parameter, this.timeZone);
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }

        public static CodegenExpression codegen(IntervalOpLocalDateTimeForge forge, CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalOpLocalDateTimeEval.class, codegenClassScope).addParam(Long.TYPE, "startTs").addParam(Long.TYPE, "endTs").addParam(LocalDateTime.class, "parameter");
            methodNode.getBlock().declareVar(Long.TYPE, "time", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("parameter"), CodegenExpressionBuilder.member(tz.getMemberId()))).methodReturn(forge.intervalComputer.codegen(CodegenExpressionBuilder.ref("startTs"), CodegenExpressionBuilder.ref("endTs"), CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
            return CodegenExpressionBuilder.localMethod(methodNode, start, end, parameter);
        }
    }

    public static class IntervalOpLocalDateTimeForge
    extends IntervalOpForgeBase {
        private final TimeZone timeZone;

        public IntervalOpLocalDateTimeForge(IntervalComputerForge intervalComputer, TimeZone timeZone) {
            super(intervalComputer);
            this.timeZone = timeZone;
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpLocalDateTimeEval(this.intervalComputer.makeComputerEval(), this.timeZone);
        }

        @Override
        public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalOpLocalDateTimeEval.codegen(this, start, end, parameter, parameterType, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpCalEval
    extends IntervalOpEvalBase {
        public IntervalOpCalEval(IntervalComputerEval intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = ((Calendar)parameter).getTimeInMillis();
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }

        public static CodegenExpression codegen(IntervalOpCalForge forge, CodegenExpression start, CodegenExpression end, CodegenExpression parameter, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalOpDateEval.class, codegenClassScope).addParam(Long.TYPE, "startTs").addParam(Long.TYPE, "endTs").addParam(Calendar.class, "parameter");
            methodNode.getBlock().declareVar(Long.TYPE, "time", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("parameter"), "getTimeInMillis", new CodegenExpression[0])).methodReturn(forge.intervalComputer.codegen(CodegenExpressionBuilder.ref("startTs"), CodegenExpressionBuilder.ref("endTs"), CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
            return CodegenExpressionBuilder.localMethod(methodNode, start, end, parameter);
        }
    }

    public static class IntervalOpCalForge
    extends IntervalOpForgeBase {
        public IntervalOpCalForge(IntervalComputerForge intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpCalEval(this.intervalComputer.makeComputerEval());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalOpCalEval.codegen(this, start, end, parameter, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpEvalLong
    extends IntervalOpEvalBase {
        public IntervalOpEvalLong(IntervalComputerEval intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = (Long)parameter;
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }

        public static CodegenExpression codegen(IntervalComputerForge intervalComputer, CodegenExpression startTs, CodegenExpression endTs, CodegenExpression parameter, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return intervalComputer.codegen(startTs, endTs, parameter, parameter, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpForgeLong
    extends IntervalOpForgeBase {
        public IntervalOpForgeLong(IntervalComputerForge intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpEvalLong(this.intervalComputer.makeComputerEval());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression startTs, CodegenExpression endTs, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalOpEvalLong.codegen(this.intervalComputer, startTs, endTs, parameter, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalOpDateEval
    extends IntervalOpEvalBase {
        public IntervalOpDateEval(IntervalComputerEval intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = ((Date)parameter).getTime();
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }

        public static CodegenExpression codegen(IntervalOpDateForge forge, CodegenExpression start, CodegenExpression end, CodegenExpression parameter, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalOpDateEval.class, codegenClassScope).addParam(Long.TYPE, "startTs").addParam(Long.TYPE, "endTs").addParam(Date.class, "parameter");
            methodNode.getBlock().declareVar(Long.TYPE, "time", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("parameter"), "getTime", new CodegenExpression[0])).methodReturn(forge.intervalComputer.codegen(CodegenExpressionBuilder.ref("startTs"), CodegenExpressionBuilder.ref("endTs"), CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
            return CodegenExpressionBuilder.localMethod(methodNode, start, end, parameter);
        }
    }

    public static class IntervalOpDateForge
    extends IntervalOpForgeBase {
        public IntervalOpDateForge(IntervalComputerForge intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public IntervalOpEval makeEval() {
            return new IntervalOpDateEval(this.intervalComputer.makeComputerEval());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression start, CodegenExpression end, CodegenExpression parameter, Class parameterType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalOpDateEval.codegen(this, start, end, parameter, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static abstract class IntervalOpEvalBase
    implements IntervalOpEval {
        protected final IntervalComputerEval intervalComputer;

        public IntervalOpEvalBase(IntervalComputerEval intervalComputer) {
            this.intervalComputer = intervalComputer;
        }
    }

    public static abstract class IntervalOpForgeBase
    implements IntervalOpForge {
        protected final IntervalComputerForge intervalComputer;

        public IntervalOpForgeBase(IntervalComputerForge intervalComputer) {
            this.intervalComputer = intervalComputer;
        }
    }

    public static interface IntervalOpEval {
        public Object evaluate(long var1, long var3, Object var5, EventBean[] var6, boolean var7, ExprEvaluatorContext var8);
    }

    public static interface IntervalOpForge {
        public IntervalOpEval makeEval();

        public CodegenExpression codegen(CodegenExpression var1, CodegenExpression var2, CodegenExpression var3, Class var4, CodegenMethodScope var5, ExprForgeCodegenSymbol var6, CodegenClassScope var7);
    }
}

