/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.datetime.calop.CalendarForge;
import com.espertech.esper.epl.datetime.calop.CalendarForgeFactory;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.ExprDotDTForge;
import com.espertech.esper.epl.datetime.eval.ExprDotDTMethodDesc;
import com.espertech.esper.epl.datetime.eval.ForgeFactory;
import com.espertech.esper.epl.datetime.interval.IntervalForge;
import com.espertech.esper.epl.datetime.interval.IntervalForgeFactory;
import com.espertech.esper.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.epl.datetime.reformatop.ReformatForgeFactory;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import com.espertech.esper.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.epl.methodbase.DotMethodInputTypeMatcher;
import com.espertech.esper.epl.methodbase.DotMethodTypeEnum;
import com.espertech.esper.epl.methodbase.DotMethodUtil;
import com.espertech.esper.epl.rettype.ClassEPType;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.rettype.EventEPType;
import com.espertech.esper.epl.rettype.NullEPType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.TimeZone;

public class ExprDotDTFactory {
    public static ExprDotDTMethodDesc validateMake(StreamTypeService streamTypeService, Deque<ExprChainedSpec> chainSpecStack, DatetimeMethodEnum dtMethod, String dtMethodName, EPType inputType, List<ExprNode> parameters, ExprDotNodeFilterAnalyzerInput inputDesc, TimeZone timeZone, TimeAbacus timeAbacus, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        FilterExprAnalyzerAffector filterAnalyzerDesc;
        IntervalForge intervalForge;
        ReformatForge reformatForge;
        ArrayList<CalendarForge> calendarForges;
        block12: {
            ExprChainedSpec next;
            String message = "Date-time enumeration method '" + dtMethodName + "' requires either a Calendar, Date, long, LocalDateTime or ZonedDateTime value as input or events of an event type that declares a timestamp property";
            if (inputType instanceof EventEPType) {
                if (((EventEPType)inputType).getType().getStartTimestampPropertyName() == null) {
                    throw new ExprValidationException(message);
                }
            } else {
                ClassEPType classEPType;
                if (!(inputType instanceof ClassEPType) && !(inputType instanceof NullEPType)) {
                    throw new ExprValidationException(message + " but received " + EPTypeHelper.toTypeDescriptive(inputType));
                }
                if (inputType instanceof ClassEPType && !JavaClassHelper.isDatetimeClass((classEPType = (ClassEPType)inputType).getType())) {
                    throw new ExprValidationException(message + " but received " + JavaClassHelper.getClassNameFullyQualPretty(classEPType.getType()));
                }
            }
            calendarForges = new ArrayList<CalendarForge>();
            reformatForge = null;
            intervalForge = null;
            DatetimeMethodEnum currentMethod = dtMethod;
            List<ExprNode> currentParameters = parameters;
            String currentMethodName = dtMethodName;
            filterAnalyzerDesc = null;
            do {
                ExprForge[] forges = ExprDotDTFactory.getForges(currentParameters);
                ForgeFactory opFactory = currentMethod.getForgeFactory();
                DotMethodFPProvided footprintProvided = DotMethodUtil.getProvidedFootprint(currentParameters);
                DotMethodUtil.validateParametersDetermineFootprint(currentMethod.getFootprints(), DotMethodTypeEnum.DATETIME, currentMethodName, footprintProvided, DotMethodInputTypeMatcher.DEFAULT_ALL);
                if (opFactory instanceof CalendarForgeFactory) {
                    CalendarForge calendarForge = ((CalendarForgeFactory)currentMethod.getForgeFactory()).getOp(currentMethod, currentMethodName, currentParameters, forges);
                    calendarForges.add(calendarForge);
                } else if (opFactory instanceof ReformatForgeFactory) {
                    reformatForge = ((ReformatForgeFactory)opFactory).getForge(inputType, timeZone, timeAbacus, currentMethod, currentMethodName, currentParameters, exprEvaluatorContext);
                    filterAnalyzerDesc = calendarForges.isEmpty() ? reformatForge.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else if (opFactory instanceof IntervalForgeFactory) {
                    intervalForge = ((IntervalForgeFactory)opFactory).getForge(streamTypeService, currentMethod, currentMethodName, currentParameters, timeZone, timeAbacus);
                    filterAnalyzerDesc = calendarForges.isEmpty() ? intervalForge.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else {
                    throw new IllegalStateException("Invalid op factory class " + opFactory);
                }
                if (chainSpecStack.isEmpty() || !DatetimeMethodEnum.isDateTimeMethod(chainSpecStack.getFirst().getName())) break block12;
                next = chainSpecStack.removeFirst();
                currentMethod = DatetimeMethodEnum.fromName(next.getName());
                currentParameters = next.getParameters();
                currentMethodName = next.getName();
            } while (reformatForge == null && intervalForge == null);
            throw new ExprValidationException("Invalid input for date-time method '" + next.getName() + "'");
        }
        ExprDotDTForge dotForge = new ExprDotDTForge(calendarForges, timeZone, timeAbacus, reformatForge, intervalForge, EPTypeHelper.getClassSingleValued(inputType), EPTypeHelper.getEventTypeSingleValued(inputType));
        EPType returnType = dotForge.getTypeInfo();
        return new ExprDotDTMethodDesc(dotForge, returnType, filterAnalyzerDesc);
    }

    private static ExprForge[] getForges(List<ExprNode> parameters) {
        ExprForge[] inputExpr = new ExprForge[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            ExprNode innerExpr = parameters.get(i);
            ExprForge inner = innerExpr.getForge();
            if (innerExpr instanceof ExprTimePeriod) {
                final ExprTimePeriod timePeriod = (ExprTimePeriod)innerExpr;
                inputExpr[i] = new ExprForge(){

                    @Override
                    public ExprEvaluator getExprEvaluator() {
                        return new ExprEvaluator(){

                            @Override
                            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                                return timePeriod.evaluateGetTimePeriod(eventsPerStream, isNewData, context);
                            }
                        };
                    }

                    @Override
                    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
                        return timePeriod.evaluateGetTimePeriodCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
                    }

                    @Override
                    public ExprForgeComplexityEnum getComplexity() {
                        return timePeriod.isConstantResult() ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
                    }

                    @Override
                    public Class getEvaluationType() {
                        return TimePeriod.class;
                    }

                    @Override
                    public ExprNode getForgeRenderable() {
                        return timePeriod;
                    }
                };
                continue;
            }
            inputExpr[i] = inner;
        }
        return inputExpr;
    }
}

