/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.dtlocal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.datetime.calop.CalendarForge;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DTLocalUtil {
    public static List<CalendarOp> getCalendarOps(List<CalendarForge> forges) {
        ArrayList<CalendarOp> ops = new ArrayList<CalendarOp>(forges.size());
        for (CalendarForge forge : forges) {
            ops.add(forge.getEvalOp());
        }
        return ops;
    }

    protected static void evaluateCalOpsCalendar(List<CalendarOp> calendarOps, Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            calendarOp.evaluate(cal, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    protected static void evaluateCalOpsCalendarCodegen(CodegenBlock block, List<CalendarForge> calendarForges, CodegenExpressionRef cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        for (CalendarForge calendarForge : calendarForges) {
            block.expression(calendarForge.codegenCalendar(cal, codegenMethodScope, exprSymbol, codegenClassScope));
        }
    }

    protected static LocalDateTime evaluateCalOpsLDT(List<CalendarOp> calendarOps, LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            ldt = calendarOp.evaluate(ldt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return ldt;
    }

    protected static void evaluateCalOpsLDTCodegen(CodegenBlock block, String resultVariable, List<CalendarForge> calendarForges, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        for (CalendarForge calendarForge : calendarForges) {
            block.assignRef(resultVariable, calendarForge.codegenLDT(CodegenExpressionBuilder.ref(resultVariable), codegenMethodScope, exprSymbol, codegenClassScope));
        }
    }

    protected static ZonedDateTime evaluateCalOpsZDT(List<CalendarOp> calendarOps, ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            zdt = calendarOp.evaluate(zdt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return zdt;
    }

    protected static void evaluateCalOpsZDTCodegen(CodegenBlock block, String resultVariable, List<CalendarForge> calendarForges, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        for (CalendarForge calendarForge : calendarForges) {
            block.assignRef(resultVariable, calendarForge.codegenZDT(CodegenExpressionBuilder.ref(resultVariable), codegenMethodScope, exprSymbol, codegenClassScope));
        }
    }
}

