/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.calop.CalendarOpUtil;
import com.espertech.esper.epl.datetime.calop.CalendarSetForge;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;

public class CalendarSetForgeOp
implements CalendarOp {
    private final CalendarFieldEnum fieldName;
    private final ExprEvaluator valueExpr;

    public CalendarSetForgeOp(CalendarFieldEnum fieldName, ExprEvaluator valueExpr) {
        this.fieldName = fieldName;
        this.valueExpr = valueExpr;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer value = CalendarOpUtil.getInt(this.valueExpr, eventsPerStream, isNewData, context);
        if (value == null) {
            return;
        }
        cal.set(this.fieldName.getCalendarField(), value);
    }

    public static CodegenExpression codegenCalendar(CalendarSetForge forge, CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression calField = CodegenExpressionBuilder.constant(forge.fieldName.getCalendarField());
        Class evaluationType = forge.valueExpr.getEvaluationType();
        if (evaluationType.isPrimitive()) {
            CodegenExpression valueExpr = forge.valueExpr.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope);
            return CodegenExpressionBuilder.exprDotMethod(cal, "set", calField, valueExpr);
        }
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Void.TYPE, CalendarSetForgeOp.class, codegenClassScope).addParam(Calendar.class, "cal");
        CodegenExpression valueExpr = forge.valueExpr.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope);
        methodNode.getBlock().declareVar(Integer.class, "value", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(valueExpr, forge.valueExpr.getEvaluationType(), methodNode, codegenClassScope)).ifRefNullReturnNull("value").expression(CodegenExpressionBuilder.exprDotMethod(cal, "set", calField, CodegenExpressionBuilder.ref("value"))).methodEnd();
        return CodegenExpressionBuilder.localMethod(methodNode, cal);
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer value = CalendarOpUtil.getInt(this.valueExpr, eventsPerStream, isNewData, context);
        if (value == null) {
            return ldt;
        }
        return ldt.with(this.fieldName.getChronoField(), value.intValue());
    }

    public static CodegenExpression codegenLDT(CalendarSetForge forge, CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ChronoField chronoField = forge.fieldName.getChronoField();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(LocalDateTime.class, CalendarSetForgeOp.class, codegenClassScope).addParam(LocalDateTime.class, "ldt");
        Class evaluationType = forge.valueExpr.getEvaluationType();
        methodNode.getBlock().declareVar(Integer.class, "value", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.valueExpr.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope), evaluationType, methodNode, codegenClassScope)).ifRefNull("value").blockReturn(CodegenExpressionBuilder.ref("ldt")).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("ldt"), "with", CodegenExpressionBuilder.enumValue(ChronoField.class, chronoField.name()), CodegenExpressionBuilder.ref("value")));
        return CodegenExpressionBuilder.localMethod(methodNode, ldt);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer value = CalendarOpUtil.getInt(this.valueExpr, eventsPerStream, isNewData, context);
        if (value == null) {
            return zdt;
        }
        return zdt.with(this.fieldName.getChronoField(), value.intValue());
    }

    public static CodegenExpression codegenZDT(CalendarSetForge forge, CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ChronoField chronoField = forge.fieldName.getChronoField();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(ZonedDateTime.class, CalendarSetForgeOp.class, codegenClassScope).addParam(ZonedDateTime.class, "zdt");
        Class evaluationType = forge.valueExpr.getEvaluationType();
        methodNode.getBlock().declareVar(Integer.class, "value", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.valueExpr.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope), evaluationType, methodNode, codegenClassScope)).ifRefNull("value").blockReturn(CodegenExpressionBuilder.ref("zdt")).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("zdt"), "with", CodegenExpressionBuilder.enumValue(ChronoField.class, chronoField.name()), CodegenExpressionBuilder.ref("value")));
        return CodegenExpressionBuilder.localMethod(methodNode, zdt);
    }
}

