/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.rowpergrouprollup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.core.orderby.OrderByProcessor;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.core.resultset.grouped.ResultSetProcessorGroupedOutputFirstHelper;
import com.espertech.esper.epl.core.resultset.rowpergrouprollup.EventArrayAndSortKeyArray;
import com.espertech.esper.epl.core.resultset.rowpergrouprollup.EventsAndSortKeysPair;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResultSetProcessorRowPerGroupRollupUtil {
    static final String METHOD_MAKEGROUPREPSPERLEVELBUF = "makeGroupRepsPerLevelBuf";
    static final String METHOD_MAKERSTREAMSORTEDARRAYBUF = "makeRStreamSortedArrayBuf";
    static final String METHOD_GETOLDEVENTSSORTKEYS = "getOldEventsSortKeys";

    public static EventsAndSortKeysPair getOldEventsSortKeys(int oldEventCount, EventArrayAndSortKeyArray rstreamEventSortArrayBuf, OrderByProcessor orderByProcessor, AggregationGroupByRollupDesc rollupDesc) {
        EventBean[] oldEventsArr = new EventBean[oldEventCount];
        Object[] oldEventsSortKeys = null;
        if (orderByProcessor != null) {
            oldEventsSortKeys = new Object[oldEventCount];
        }
        int countEvents = 0;
        int countSortKeys = 0;
        for (AggregationGroupByRollupLevel level : rollupDesc.getLevels()) {
            List<EventBean> events = rstreamEventSortArrayBuf.getEventsPerLevel()[level.getLevelNumber()];
            for (EventBean event : events) {
                oldEventsArr[countEvents++] = event;
            }
            if (orderByProcessor == null) continue;
            List<Object> sortKeys = rstreamEventSortArrayBuf.getSortKeyPerLevel()[level.getLevelNumber()];
            for (Object sortKey : sortKeys) {
                oldEventsSortKeys[countSortKeys++] = sortKey;
            }
        }
        return new EventsAndSortKeysPair(oldEventsArr, oldEventsSortKeys);
    }

    public static EventArrayAndSortKeyArray makeRStreamSortedArrayBuf(int length, boolean isSorting) {
        List[] eventsPerLevel = new List[length];
        List[] sortKeyPerLevel = null;
        if (isSorting) {
            sortKeyPerLevel = new List[length];
        }
        for (int i = 0; i < length; ++i) {
            eventsPerLevel[i] = new ArrayList();
            if (!isSorting) continue;
            sortKeyPerLevel[i] = new ArrayList();
        }
        return new EventArrayAndSortKeyArray(eventsPerLevel, sortKeyPerLevel);
    }

    public static Map<Object, EventBean[]>[] makeGroupRepsPerLevelBuf(int levelCount) {
        LinkedHashMap[] groupRepsPerLevelBuf = new LinkedHashMap[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            groupRepsPerLevelBuf[i] = new LinkedHashMap();
        }
        return groupRepsPerLevelBuf;
    }

    public static ResultSetProcessorGroupedOutputFirstHelper[] initializeOutputFirstHelpers(ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, AgentInstanceContext agentInstanceContext, Class[] groupKeyTypes, AggregationGroupByRollupDesc groupByRollupDesc, OutputConditionPolledFactory outputConditionPolledFactory) {
        ResultSetProcessorGroupedOutputFirstHelper[] outputFirstHelpers = new ResultSetProcessorGroupedOutputFirstHelper[groupByRollupDesc.getLevels().length];
        for (int i = 0; i < groupByRollupDesc.getLevels().length; ++i) {
            outputFirstHelpers[i] = resultSetProcessorHelperFactory.makeRSGroupedOutputFirst(agentInstanceContext, groupKeyTypes, outputConditionPolledFactory, groupByRollupDesc, i);
        }
        return outputFirstHelpers;
    }
}

