/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.rowforall;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.resultset.rowforall.ResultSetProcessorRowForAll;
import com.espertech.esper.epl.core.resultset.rowforall.ResultSetProcessorRowForAllOutputAllHelper;
import com.espertech.esper.event.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ResultSetProcessorRowForAllOutputAllHelperImpl
implements ResultSetProcessorRowForAllOutputAllHelper {
    private final ResultSetProcessorRowForAll processor;
    private final Deque<EventBean> eventsOld = new ArrayDeque<EventBean>(2);
    private final Deque<EventBean> eventsNew = new ArrayDeque<EventBean>(2);

    public ResultSetProcessorRowForAllOutputAllHelperImpl(ResultSetProcessorRowForAll processor) {
        this.processor = processor;
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        if (this.processor.isSelectRStream()) {
            EventBean[] events = this.processor.getSelectListEventsAsArray(false, isGenerateSynthetic, false);
            EventBeanUtility.addToCollection(events, this.eventsOld);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.processor.getAggregationService(), this.processor.getExprEvaluatorContext(), newData, oldData, eventsPerStream);
        EventBean[] events = this.processor.getSelectListEventsAsArray(true, isGenerateSynthetic, false);
        EventBeanUtility.addToCollection(events, this.eventsNew);
    }

    @Override
    public void processJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        EventBean[] events;
        if (this.processor.isSelectRStream()) {
            events = this.processor.getSelectListEventsAsArray(false, isGenerateSynthetic, true);
            EventBeanUtility.addToCollection(events, this.eventsOld);
        }
        ResultSetProcessorUtil.applyAggJoinResult(this.processor.getAggregationService(), this.processor.getExprEvaluatorContext(), newEvents, oldEvents);
        events = this.processor.getSelectListEventsAsArray(true, isGenerateSynthetic, true);
        EventBeanUtility.addToCollection(events, this.eventsNew);
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isGenerateSynthetic) {
        return this.output(isGenerateSynthetic, false);
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isGenerateSynthetic) {
        return this.output(isGenerateSynthetic, true);
    }

    @Override
    public void destroy() {
    }

    private UniformPair<EventBean[]> output(boolean isGenerateSynthetic, boolean isJoin) {
        EventBean[] oldEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsOld);
        EventBean[] newEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsNew);
        if (newEvents == null) {
            newEvents = this.processor.getSelectListEventsAsArray(true, isGenerateSynthetic, isJoin);
        }
        if (oldEvents == null && this.processor.isSelectRStream()) {
            oldEvents = this.processor.getSelectListEventsAsArray(false, isGenerateSynthetic, isJoin);
        }
        UniformPair<EventBean[]> result = null;
        if (oldEvents != null || newEvents != null) {
            result = new UniformPair<EventBean[]>(newEvents, oldEvents);
        }
        this.eventsOld.clear();
        this.eventsNew.clear();
        return result;
    }
}

