/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.poll;

import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.engineimport.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyEnum;
import com.espertech.esper.epl.core.poll.MethodPollingViewable;
import com.espertech.esper.epl.core.poll.MethodPollingViewableMeta;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheFactory;
import com.espertech.esper.epl.declexpr.ExprDeclaredHelper;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.script.ExprNodeScript;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MethodPollingViewableFactory {
    public static HistoricalEventViewable createPollMethodView(int streamNumber, MethodStreamSpec methodStreamSpec, EventAdapterService eventAdapterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, EngineImportService engineImportService, SchedulingService schedulingService, ScheduleBucket scheduleBucket, ExprEvaluatorContext exprEvaluatorContext, VariableService variableService, String contextName, DataCacheFactory dataCacheFactory, StatementContext statementContext) throws ExprValidationException {
        String configName;
        ConfigurationMethodRef configCache;
        EventType eventType;
        MethodPollingExecStrategyEnum strategy;
        ExprNodeScript scriptExpression;
        String eventTypeNameProvidedUDFOrScript;
        Object invocationTarget;
        Method methodReflection;
        String variableName;
        VariableReader variableReader;
        VariableMetaData variableMetaData;
        block27: {
            List<ExpressionScriptProvided> scriptsByName;
            variableMetaData = variableService.getVariableMetaData(methodStreamSpec.getClassName());
            variableReader = null;
            variableName = null;
            methodReflection = null;
            invocationTarget = null;
            eventTypeNameProvidedUDFOrScript = null;
            scriptExpression = null;
            if (methodStreamSpec.getClassName() == null && methodStreamSpec.getMethodName() != null && (scriptsByName = statementContext.getExprDeclaredService().getScriptsByName(methodStreamSpec.getMethodName())) != null) {
                scriptExpression = ExprDeclaredHelper.getExistsScript(statementContext.getConfigSnapshot().getEngineDefaults().getScripts().getDefaultDialect(), methodStreamSpec.getMethodName(), methodStreamSpec.getExpressions(), scriptsByName, statementContext.getExprDeclaredService());
            }
            try {
                if (scriptExpression != null) {
                    eventTypeNameProvidedUDFOrScript = scriptExpression.getEventTypeNameAnnotation();
                    strategy = MethodPollingExecStrategyEnum.TARGET_SCRIPT;
                    EPLValidationUtil.validateSimpleGetSubtree(ExprNodeOrigin.METHODINVJOIN, scriptExpression, statementContext, null, false);
                    break block27;
                }
                if (variableMetaData != null) {
                    variableName = variableMetaData.getVariableName();
                    if (variableMetaData.getContextPartitionName() != null) {
                        if (contextName == null || !contextName.equals(variableMetaData.getContextPartitionName())) {
                            throw new ExprValidationException("Variable by name '" + variableMetaData.getVariableName() + "' has been declared for context '" + variableMetaData.getContextPartitionName() + "' and can only be used within the same context");
                        }
                        strategy = MethodPollingExecStrategyEnum.TARGET_VAR_CONTEXT;
                        variableReader = null;
                        invocationTarget = null;
                    } else {
                        variableReader = variableService.getReader(methodStreamSpec.getClassName(), -1);
                        if (variableMetaData.isConstant()) {
                            invocationTarget = variableReader.getValue();
                            if (invocationTarget instanceof EventBean) {
                                invocationTarget = ((EventBean)invocationTarget).getUnderlying();
                            }
                            strategy = MethodPollingExecStrategyEnum.TARGET_CONST;
                        } else {
                            invocationTarget = null;
                            strategy = MethodPollingExecStrategyEnum.TARGET_VAR;
                        }
                    }
                    methodReflection = engineImportService.resolveNonStaticMethodOverloadChecked(variableMetaData.getType(), methodStreamSpec.getMethodName());
                    break block27;
                }
                if (methodStreamSpec.getClassName() == null) {
                    Pair<Class, EngineImportSingleRowDesc> udf = null;
                    try {
                        udf = engineImportService.resolveSingleRow(methodStreamSpec.getMethodName());
                    }
                    catch (EngineImportException ex) {
                        throw new ExprValidationException("Failed to find user-defined function '" + methodStreamSpec.getMethodName() + "': " + ex.getMessage(), ex);
                    }
                    methodReflection = engineImportService.resolveMethodOverloadChecked(udf.getFirst(), methodStreamSpec.getMethodName());
                    invocationTarget = null;
                    variableReader = null;
                    variableName = null;
                    strategy = MethodPollingExecStrategyEnum.TARGET_CONST;
                    eventTypeNameProvidedUDFOrScript = udf.getSecond().getOptionalEventTypeName();
                    break block27;
                }
                methodReflection = engineImportService.resolveMethodOverloadChecked(methodStreamSpec.getClassName(), methodStreamSpec.getMethodName());
                invocationTarget = null;
                variableReader = null;
                variableName = null;
                strategy = MethodPollingExecStrategyEnum.TARGET_CONST;
            }
            catch (ExprValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExprValidationException(e.getMessage(), e);
            }
        }
        Class<?> methodProviderClass = null;
        LinkedHashMap oaType = null;
        Map mapType = null;
        boolean isCollection = false;
        boolean isIterator = false;
        EventType eventTypeWhenMethodReturnsEventBeans = null;
        boolean isStaticMethod = false;
        if (methodReflection != null) {
            methodProviderClass = methodReflection.getDeclaringClass();
            isStaticMethod = variableMetaData == null;
            Class beanClass = methodReflection.getReturnType();
            if (beanClass == Void.TYPE || beanClass == Void.class || JavaClassHelper.isJavaBuiltinDataType(beanClass)) {
                throw new ExprValidationException("Invalid return type for static method '" + methodReflection.getName() + "' of class '" + methodStreamSpec.getClassName() + "', expecting a Java class");
            }
            if (methodReflection.getReturnType().isArray() && methodReflection.getReturnType().getComponentType() != EventBean.class) {
                beanClass = methodReflection.getReturnType().getComponentType();
            }
            isCollection = JavaClassHelper.isImplementsInterface(beanClass, Collection.class);
            Class collectionClass = null;
            if (isCollection) {
                beanClass = collectionClass = JavaClassHelper.getGenericReturnType(methodReflection, true);
            }
            isIterator = JavaClassHelper.isImplementsInterface(beanClass, Iterator.class);
            Class iteratorClass = null;
            if (isIterator) {
                beanClass = iteratorClass = JavaClassHelper.getGenericReturnType(methodReflection, true);
            }
            String mapTypeName = null;
            if (JavaClassHelper.isImplementsInterface(methodReflection.getReturnType(), Map.class) || methodReflection.getReturnType().isArray() && JavaClassHelper.isImplementsInterface(methodReflection.getReturnType().getComponentType(), Map.class) || isCollection && JavaClassHelper.isImplementsInterface(collectionClass, Map.class) || isIterator && JavaClassHelper.isImplementsInterface(iteratorClass, Map.class)) {
                MethodMetadataDesc metadata = variableMetaData != null ? MethodPollingViewableFactory.getCheckMetadataVariable(methodStreamSpec.getMethodName(), variableMetaData, variableReader, engineImportService, Map.class) : MethodPollingViewableFactory.getCheckMetadataNonVariable(methodStreamSpec.getMethodName(), methodStreamSpec.getClassName(), engineImportService, Map.class);
                mapTypeName = metadata.getTypeName();
                mapType = (Map)metadata.getTypeMetadata();
            }
            String oaTypeName = null;
            if (methodReflection.getReturnType() == Object[].class || methodReflection.getReturnType() == Object[][].class || isCollection && collectionClass == Object[].class || isIterator && iteratorClass == Object[].class) {
                MethodMetadataDesc metadata = variableMetaData != null ? MethodPollingViewableFactory.getCheckMetadataVariable(methodStreamSpec.getMethodName(), variableMetaData, variableReader, engineImportService, LinkedHashMap.class) : MethodPollingViewableFactory.getCheckMetadataNonVariable(methodStreamSpec.getMethodName(), methodStreamSpec.getClassName(), engineImportService, LinkedHashMap.class);
                oaTypeName = metadata.getTypeName();
                oaType = (LinkedHashMap)metadata.getTypeMetadata();
            }
            if (methodReflection.getReturnType().isArray() && methodReflection.getReturnType().getComponentType() == EventBean.class || isCollection && collectionClass == EventBean.class || isIterator && iteratorClass == EventBean.class) {
                String typeName = methodStreamSpec.getEventTypeName() == null ? eventTypeNameProvidedUDFOrScript : methodStreamSpec.getEventTypeName();
                eventTypeWhenMethodReturnsEventBeans = eventType = EventTypeUtility.requireEventType("Method", methodReflection.getName(), eventAdapterService, typeName);
            } else {
                eventType = mapType != null ? eventAdapterService.addNestableMapType(mapTypeName, mapType, null, false, true, true, false, false) : (oaType != null ? eventAdapterService.addNestableObjectArrayType(oaTypeName, oaType, null, false, true, true, false, false, false, null) : eventAdapterService.addBeanType(beanClass.getName(), beanClass, false, true, true));
            }
            if (methodStreamSpec.getEventTypeName() != null && eventTypeWhenMethodReturnsEventBeans == null) {
                throw new ExprValidationException(EventTypeUtility.disallowedAtTypeMessage());
            }
        } else {
            String eventTypeName = methodStreamSpec.getEventTypeName() == null ? scriptExpression.getEventTypeNameAnnotation() : methodStreamSpec.getEventTypeName();
            eventType = EventTypeUtility.requireEventType("Script", scriptExpression.getScript().getName(), eventAdapterService, eventTypeName);
        }
        if ((configCache = engineImportService.getConfigurationMethodRef(configName = methodProviderClass != null ? methodProviderClass.getName() : methodStreamSpec.getMethodName())) == null) {
            configCache = engineImportService.getConfigurationMethodRef(configName);
        }
        ConfigurationDataCache dataCacheDesc = configCache != null ? configCache.getDataCacheDesc() : null;
        DataCache dataCache = dataCacheFactory.getDataCache(dataCacheDesc, statementContext, epStatementAgentInstanceHandle, schedulingService, scheduleBucket, streamNumber);
        MethodPollingViewableMeta meta = new MethodPollingViewableMeta(methodProviderClass, isStaticMethod, mapType, oaType, invocationTarget, strategy, isCollection, isIterator, variableReader, variableName, eventTypeWhenMethodReturnsEventBeans, scriptExpression);
        return new MethodPollingViewable(methodStreamSpec, dataCache, eventType, exprEvaluatorContext, meta);
    }

    private static MethodMetadataDesc getCheckMetadataVariable(String methodName, VariableMetaData variableMetaData, VariableReader variableReader, EngineImportService engineImportService, Class metadataClass) throws ExprValidationException {
        Method typeGetterMethod = MethodPollingViewableFactory.getRequiredTypeGetterMethodCanNonStatic(methodName, null, variableMetaData.getType(), engineImportService, metadataClass);
        if (Modifier.isStatic(typeGetterMethod.getModifiers())) {
            return MethodPollingViewableFactory.invokeMetadataMethod(null, variableMetaData.getClass().getSimpleName(), typeGetterMethod);
        }
        String messagePrefix = "Failed to access variable method invocation metadata: ";
        if (variableReader == null) {
            throw new ExprValidationException(messagePrefix + "The metadata method is an instance method however the variable is contextual, please declare the metadata method as static or remove the context declaration for the variable");
        }
        Object value = variableReader.getValue();
        if (value == null) {
            throw new ExprValidationException(messagePrefix + "The variable value is null and the metadata method is an instance method");
        }
        if (value instanceof EventBean) {
            value = ((EventBean)value).getUnderlying();
        }
        return MethodPollingViewableFactory.invokeMetadataMethod(value, variableMetaData.getClass().getSimpleName(), typeGetterMethod);
    }

    private static MethodMetadataDesc getCheckMetadataNonVariable(String methodName, String className, EngineImportService engineImportService, Class metadataClass) throws ExprValidationException {
        Method typeGetterMethod = MethodPollingViewableFactory.getRequiredTypeGetterMethodCanNonStatic(methodName, className, null, engineImportService, metadataClass);
        return MethodPollingViewableFactory.invokeMetadataMethod(null, className, typeGetterMethod);
    }

    private static Method getRequiredTypeGetterMethodCanNonStatic(String methodName, String classNameWhenNoClass, Class clazzWhenAvailable, EngineImportService engineImportService, Class metadataClass) throws ExprValidationException {
        boolean fail;
        Method typeGetterMethod;
        String getterMethodName = methodName + "Metadata";
        try {
            typeGetterMethod = clazzWhenAvailable != null ? engineImportService.resolveMethod(clazzWhenAvailable, getterMethodName, new Class[0], new boolean[0], new boolean[0]) : engineImportService.resolveMethodOverloadChecked(classNameWhenNoClass, getterMethodName, new Class[0], new boolean[0], new boolean[0]);
        }
        catch (Exception e) {
            throw new ExprValidationException("Could not find getter method for method invocation, expected a method by name '" + getterMethodName + "' accepting no parameters");
        }
        if (metadataClass.isInterface()) {
            fail = !JavaClassHelper.isImplementsInterface(typeGetterMethod.getReturnType(), metadataClass);
        } else {
            boolean bl = fail = typeGetterMethod.getReturnType() != metadataClass;
        }
        if (fail) {
            throw new ExprValidationException("Getter method '" + typeGetterMethod.getName() + "' does not return " + JavaClassHelper.getClassNameFullyQualPretty(metadataClass));
        }
        return typeGetterMethod;
    }

    private static MethodMetadataDesc invokeMetadataMethod(Object target, String className, Method typeGetterMethod) throws ExprValidationException {
        Object resultType;
        try {
            resultType = typeGetterMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new ExprValidationException("Error invoking metadata getter method for method invocation, for method by name '" + typeGetterMethod.getName() + "' accepting no parameters: " + e.getMessage(), e);
        }
        if (resultType == null) {
            throw new ExprValidationException("Error invoking metadata getter method for method invocation, method returned a null value");
        }
        return new MethodMetadataDesc(className + "." + typeGetterMethod.getName(), resultType);
    }

    public static class MethodMetadataDesc {
        private final String typeName;
        private final Object typeMetadata;

        public MethodMetadataDesc(String typeName, Object typeMetadata) {
            this.typeName = typeName;
            this.typeMetadata = typeMetadata;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Object getTypeMetadata() {
            return this.typeMetadata;
        }
    }
}

