/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.orderby;

import com.espertech.esper.epl.core.orderby.OrderByElementForge;
import com.espertech.esper.epl.core.orderby.OrderByProcessorFactoryForge;
import com.espertech.esper.epl.core.orderby.OrderByProcessorForgeImpl;
import com.espertech.esper.epl.core.orderby.OrderByProcessorOrderedLimitForge;
import com.espertech.esper.epl.core.orderby.OrderByProcessorRowLimitOnlyForge;
import com.espertech.esper.epl.core.orderby.RowLimitProcessorFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.variable.VariableService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByProcessorFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(OrderByProcessorFactoryFactory.class);

    public static OrderByProcessorFactoryForge getProcessor(List<SelectClauseExprCompiledSpec> selectionList, List<OrderByItem> orderByList, RowLimitSpec rowLimitSpec, VariableService variableService, boolean isSortUsingCollator, String optionalContextName, OrderByElementForge[][] orderByRollup) throws ExprValidationException {
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem orderByItem : orderByList) {
            orderByNodes.add(orderByItem.getExprNode());
        }
        if (orderByList.isEmpty()) {
            log.debug(".getProcessor Using no OrderByProcessor");
            if (rowLimitSpec != null) {
                RowLimitProcessorFactory rowLimitProcessorFactory = new RowLimitProcessorFactory(rowLimitSpec, variableService, optionalContextName);
                return new OrderByProcessorRowLimitOnlyForge(rowLimitProcessorFactory);
            }
            return null;
        }
        LinkedList<ExprAggregateNode> selectAggNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : selectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(selectClauseExprCompiledSpec.getSelectExpression(), selectAggNodes);
        }
        LinkedList<ExprAggregateNode> linkedList = new LinkedList<ExprAggregateNode>();
        for (ExprNode orderByNode : orderByNodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, linkedList);
        }
        OrderByProcessorFactoryFactory.validateOrderByAggregates(selectAggNodes, linkedList);
        boolean bl = !selectionList.isEmpty() && !linkedList.isEmpty();
        log.debug(".getProcessor Using OrderByProcessorImpl");
        OrderByElementForge[] elements = OrderByProcessorFactoryFactory.toElementArray(orderByList);
        Comparator<Object> comparator = OrderByProcessorFactoryFactory.getComparator(elements, isSortUsingCollator);
        OrderByProcessorForgeImpl orderByProcessorForge = new OrderByProcessorForgeImpl(elements, bl, comparator, orderByRollup);
        if (rowLimitSpec == null) {
            return orderByProcessorForge;
        }
        RowLimitProcessorFactory rowLimitProcessorFactory = new RowLimitProcessorFactory(rowLimitSpec, variableService, optionalContextName);
        return new OrderByProcessorOrderedLimitForge(orderByProcessorForge, rowLimitProcessorFactory);
    }

    private static void validateOrderByAggregates(List<ExprAggregateNode> selectAggNodes, List<ExprAggregateNode> orderAggNodes) throws ExprValidationException {
        for (ExprAggregateNode orderAgg : orderAggNodes) {
            boolean inSelect = false;
            for (ExprAggregateNode selectAgg : selectAggNodes) {
                if (!ExprNodeUtilityCore.deepEquals(selectAgg, orderAgg, false)) continue;
                inSelect = true;
                break;
            }
            if (inSelect) continue;
            throw new ExprValidationException("Aggregate functions in the order-by clause must also occur in the select expression");
        }
    }

    private static Comparator<Object> getComparator(OrderByElementForge[] orderBy, boolean isSortUsingCollator) throws ExprValidationException {
        ExprNode[] nodes = new ExprNode[orderBy.length];
        boolean[] descending = new boolean[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            nodes[i] = orderBy[i].getExprNode();
            descending[i] = orderBy[i].isDescending();
        }
        return ExprNodeUtilityCore.getComparatorHashableMultiKeys(nodes, isSortUsingCollator, descending);
    }

    private static OrderByElementForge[] toElementArray(List<OrderByItem> orderByList) {
        OrderByElementForge[] elements = new OrderByElementForge[orderByList.size()];
        int count = 0;
        for (OrderByItem item : orderByList) {
            elements[count++] = new OrderByElementForge(item.getExprNode(), item.isDescending());
        }
        return elements;
    }
}

