/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.groupby;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenNamedMethods;
import com.espertech.esper.codegen.core.CodegenTypedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.codegen.AggregationCodegenRowLevelDesc;
import com.espertech.esper.epl.agg.codegen.AggregationServiceCodegenNames;
import com.espertech.esper.epl.agg.service.common.AggregationRowStateEvalDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceCodegenUtil;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactory;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryForge;
import com.espertech.esper.epl.agg.service.groupby.AggGroupByDesc;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByNoReclaimFactory;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedFactory;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedImpl;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByRefcountedFactory;
import com.espertech.esper.epl.core.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByForge
implements AggregationServiceFactoryForge {
    private static final CodegenExpressionRef REF_CURRENTROW = new CodegenExpressionRef("currentRow");
    private static final CodegenExpressionRef REF_CURRENTGROUPKEY = new CodegenExpressionRef("currentGroupKey");
    static final CodegenExpressionRef REF_AGGREGATORSPERGROUP = CodegenExpressionBuilder.ref("aggregatorsPerGroup");
    private static final CodegenExpressionRef REF_REMOVEDKEYS = CodegenExpressionBuilder.ref("removedKeys");
    protected final AggGroupByDesc aggGroupByDesc;
    protected final TimeAbacus timeAbacus;

    public AggSvcGroupByForge(AggGroupByDesc aggGroupByDesc, TimeAbacus timeAbacus) {
        this.aggGroupByDesc = aggGroupByDesc;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public AggregationServiceFactory getAggregationServiceFactory(StatementContext stmtContext, boolean isFireAndForget) {
        AggregationRowStateEvalDesc rowStateEvalDesc = this.aggGroupByDesc.getRowStateForgeDescs().toEval(stmtContext, isFireAndForget);
        if (this.aggGroupByDesc.isRefcounted()) {
            return new AggSvcGroupByRefcountedFactory(rowStateEvalDesc, this.aggGroupByDesc.isJoin());
        }
        if (!this.aggGroupByDesc.isReclaimAged()) {
            return new AggSvcGroupByNoReclaimFactory(rowStateEvalDesc, this.aggGroupByDesc.isJoin());
        }
        return new AggSvcGroupByReclaimAgedFactory(rowStateEvalDesc, this.aggGroupByDesc.isJoin(), this.aggGroupByDesc.getReclaimEvaluationFunctionMaxAge(), this.aggGroupByDesc.getReclaimEvaluationFunctionFrequency());
    }

    @Override
    public void rowCtorCodegen(CodegenClassScope classScope, CodegenCtor rowCtor, List<CodegenTypedParam> rowMembers, CodegenNamedMethods namedMethods) {
        AggregationServiceCodegenUtil.generateRefCount(this.hasRefCounting(), namedMethods, rowCtor, rowMembers, classScope);
        if (this.aggGroupByDesc.isReclaimAged()) {
            AggSvcGroupByReclaimAgedImpl.rowCtorCodegen(namedMethods, classScope, rowMembers);
        }
    }

    @Override
    public void makeServiceCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstanceInnerClass("AggSvc", CodegenExpressionBuilder.ref("o"), ResultSetProcessorCodegenNames.REF_AGENTINSTANCECONTEXT));
    }

    @Override
    public void ctorCodegen(CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassScope classScope) {
        ctor.getCtorParams().add(new CodegenTypedParam(AgentInstanceContext.class, "agentInstanceContext"));
        explicitMembers.add(new CodegenTypedParam(Map.class, REF_AGGREGATORSPERGROUP.getRef()));
        explicitMembers.add(new CodegenTypedParam(Object.class, REF_CURRENTGROUPKEY.getRef()));
        explicitMembers.add(new CodegenTypedParam("AggRowTop", REF_CURRENTROW.getRef()));
        ctor.getBlock().assignRef(REF_AGGREGATORSPERGROUP, CodegenExpressionBuilder.newInstance(HashMap.class, new CodegenExpression[0]));
        if (this.aggGroupByDesc.isReclaimAged()) {
            AggSvcGroupByReclaimAgedImpl.ctorCodegenReclaim(ctor, explicitMembers, classScope, this.aggGroupByDesc.getReclaimEvaluationFunctionMaxAge(), this.aggGroupByDesc.getReclaimEvaluationFunctionFrequency());
        }
        if (this.hasRefCounting()) {
            explicitMembers.add(new CodegenTypedParam(List.class, REF_REMOVEDKEYS.getRef()));
            ctor.getBlock().assignRef(REF_REMOVEDKEYS, CodegenExpressionBuilder.newInstance(ArrayList.class, CodegenExpressionBuilder.constant(4)));
        }
    }

    @Override
    public void getValueCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, "getValue", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getEventBeanCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, "getEventBean", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getCollectionScalarCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, "getCollectionScalar", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void getCollectionOfEventsCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, "getCollectionOfEvents", AggregationServiceCodegenNames.REF_COLUMN, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public void applyEnterCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        if (this.aggGroupByDesc.isReclaimAged()) {
            AggSvcGroupByReclaimAgedImpl.applyEnterCodegenSweep(method, classScope, this.timeAbacus);
        }
        if (this.hasRefCounting()) {
            method.getBlock().localMethod(this.handleRemovedKeysCodegen(method, classScope), new CodegenExpression[0]);
        }
        CodegenBlock block = method.getBlock().assignRef(REF_CURRENTROW, CodegenExpressionBuilder.cast("AggRowTop", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY)));
        CodegenBlock ifNoRow = block.ifCondition(CodegenExpressionBuilder.equalsNull(REF_CURRENTROW)).assignRef(REF_CURRENTROW, CodegenExpressionBuilder.newInstanceInnerClass("AggRowTop", CodegenExpressionBuilder.ref("o"))).exprDotMethod(REF_AGGREGATORSPERGROUP, "put", AggregationServiceCodegenNames.REF_GROUPKEY, REF_CURRENTROW);
        if (this.hasRefCounting()) {
            ifNoRow.ifElse().exprDotMethod(REF_CURRENTROW, "increaseRefcount", new CodegenExpression[0]).blockEnd();
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            block.exprDotMethod(REF_CURRENTROW, "setLastUpdateTime", CodegenExpressionBuilder.ref("currentTime"));
        }
        block.exprDotMethod(REF_CURRENTROW, "applyEnter", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
    }

    @Override
    public void applyLeaveCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenBlock block = method.getBlock().assignRef(REF_CURRENTROW, CodegenExpressionBuilder.cast("AggRowTop", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY)));
        block.ifCondition(CodegenExpressionBuilder.equalsNull(REF_CURRENTROW)).assignRef(REF_CURRENTROW, CodegenExpressionBuilder.newInstanceInnerClass("AggRowTop", CodegenExpressionBuilder.ref("o"))).exprDotMethod(REF_AGGREGATORSPERGROUP, "put", AggregationServiceCodegenNames.REF_GROUPKEY, REF_CURRENTROW);
        if (this.hasRefCounting()) {
            block.exprDotMethod(REF_CURRENTROW, "decreaseRefcount", new CodegenExpression[0]);
        }
        if (this.aggGroupByDesc.isReclaimAged()) {
            block.exprDotMethod(REF_CURRENTROW, "setLastUpdateTime", CodegenExpressionBuilder.exprDotMethodChain(ExprForgeCodegenNames.REF_EXPREVALCONTEXT).add("getTimeProvider", new CodegenExpression[0]).add("getTime", new CodegenExpression[0]));
        }
        block.exprDotMethod(REF_CURRENTROW, "applyLeave", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
        if (this.hasRefCounting()) {
            block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, "getRefcount", new CodegenExpression[0]), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0))).exprDotMethod(REF_REMOVEDKEYS, "add", AggregationServiceCodegenNames.REF_GROUPKEY);
        }
    }

    @Override
    public void stopMethodCodegen(AggregationServiceFactoryForge forge, CodegenMethodNode method) {
    }

    @Override
    public void setRemovedCallbackCodegen(CodegenMethodNode method) {
        if (this.aggGroupByDesc.isReclaimAged()) {
            method.getBlock().assignRef("removedCallback", (CodegenExpression)AggregationServiceCodegenNames.REF_CALLBACK);
        }
    }

    @Override
    public void setCurrentAccessCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().assignRef(REF_CURRENTGROUPKEY, (CodegenExpression)AggregationServiceCodegenNames.REF_GROUPKEY).assignRef(REF_CURRENTROW, CodegenExpressionBuilder.cast("AggRowTop", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "get", AggregationServiceCodegenNames.REF_GROUPKEY))).ifCondition(CodegenExpressionBuilder.equalsNull(REF_CURRENTROW)).assignRef(REF_CURRENTROW, CodegenExpressionBuilder.newInstanceInnerClass("AggRowTop", CodegenExpressionBuilder.ref("o")));
    }

    @Override
    public void clearResultsCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(REF_AGGREGATORSPERGROUP, "clear", new CodegenExpression[0]);
    }

    @Override
    public AggregationCodegenRowLevelDesc getRowLevelDesc() {
        return AggregationCodegenRowLevelDesc.fromTopOnly(this.aggGroupByDesc.getRowStateForgeDescs());
    }

    @Override
    public void acceptCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitAggregations", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "size", new CodegenExpression[0]), REF_AGGREGATORSPERGROUP);
    }

    @Override
    public void getGroupKeysCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.aggGroupByDesc.isRefcounted()) {
            method.getBlock().localMethod(this.handleRemovedKeysCodegen(method, classScope), new CodegenExpression[0]);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "keySet", new CodegenExpression[0]));
    }

    @Override
    public void getGroupKeyCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(REF_CURRENTGROUPKEY);
    }

    @Override
    public void acceptGroupDetailCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGrouped", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "size", new CodegenExpression[0])).forEach(Map.Entry.class, "entry", CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSPERGROUP, "entrySet", new CodegenExpression[0])).exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGroup", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getKey", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getValue", new CodegenExpression[0]));
    }

    @Override
    public void isGroupedCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
    }

    private boolean hasRefCounting() {
        return this.aggGroupByDesc.isRefcounted() || this.aggGroupByDesc.isReclaimAged();
    }

    private CodegenMethodNode handleRemovedKeysCodegen(CodegenMethodNode scope, CodegenClassScope classScope) {
        CodegenMethodNode method = scope.makeChild(Void.TYPE, AggSvcGroupByForge.class, classScope);
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(REF_REMOVEDKEYS, "isEmpty", new CodegenExpression[0]))).forEach(Object.class, "removedKey", REF_REMOVEDKEYS).exprDotMethod(REF_AGGREGATORSPERGROUP, "remove", CodegenExpressionBuilder.ref("removedKey")).blockEnd().exprDotMethod(REF_REMOVEDKEYS, "clear", new CodegenExpression[0]);
        return method;
    }
}

