/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.codegen.model.expression.CodegenExpressionTypePair;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.function.Consumer;

public class AggregatorStddev
implements AggregationMethod {
    protected double mean;
    protected double qn;
    protected long cnt;

    public static void rowMemberCodegen(boolean distinct, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, Double.TYPE, "mean");
        membersColumnized.addMember(column, Double.TYPE, "qn");
        membersColumnized.addMember(column, Long.TYPE, "cnt");
        if (distinct) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double p = ((Number)object).doubleValue();
        if (this.cnt == 0L) {
            this.mean = p;
            this.qn = 0.0;
            this.cnt = 1L;
        } else {
            ++this.cnt;
            double oldmean = this.mean;
            this.mean += (p - this.mean) / (double)this.cnt;
            this.qn += (p - oldmean) * (p - this.mean);
        }
    }

    public static void applyEnterCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(true, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol mean = CodegenExpressionBuilder.refCol("mean", column);
        CodegenExpressionRefWCol qn = CodegenExpressionBuilder.refCol("qn", column);
        CodegenExpressionRefWCol cnt = CodegenExpressionBuilder.refCol("cnt", column);
        method.getBlock().declareVar(Double.TYPE, "p", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value.getExpression(), value.getType())).ifCondition(CodegenExpressionBuilder.equalsIdentity(cnt, CodegenExpressionBuilder.constant(0))).assignRef(mean, (CodegenExpression)CodegenExpressionBuilder.ref("p")).assignRef(qn, CodegenExpressionBuilder.constant(0)).assignRef(cnt, CodegenExpressionBuilder.constant(1)).ifElse().increment(cnt).declareVar(Double.TYPE, "oldmean", (CodegenExpression)mean).assignCompound(mean, "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", mean), "/", cnt)).assignCompound(qn, "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", CodegenExpressionBuilder.ref("oldmean")), "*", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", mean)));
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double p = ((Number)object).doubleValue();
        if (this.cnt <= 1L) {
            this.clear();
        } else {
            --this.cnt;
            double oldmean = this.mean;
            this.mean -= (p - this.mean) / (double)this.cnt;
            this.qn -= (p - oldmean) * (p - this.mean);
        }
    }

    public static void applyLeaveCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(false, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol mean = CodegenExpressionBuilder.refCol("mean", column);
        CodegenExpressionRefWCol qn = CodegenExpressionBuilder.refCol("qn", column);
        CodegenExpressionRefWCol cnt = CodegenExpressionBuilder.refCol("cnt", column);
        Consumer<CodegenBlock> clear = block -> block.assignRef(mean, CodegenExpressionBuilder.constant(0)).assignRef(qn, CodegenExpressionBuilder.constant(0)).assignRef(cnt, CodegenExpressionBuilder.constant(0));
        method.getBlock().declareVar(Double.TYPE, "p", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value.getExpression(), value.getType())).ifCondition(CodegenExpressionBuilder.relational(cnt, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(clear).ifElse().decrement(cnt).declareVar(Double.TYPE, "oldmean", (CodegenExpression)mean).assignCompound(mean, "-", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", mean), "/", cnt)).assignCompound(qn, "-", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", CodegenExpressionBuilder.ref("oldmean")), "*", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("p"), "-", mean)));
    }

    @Override
    public void clear() {
        this.mean = 0.0;
        this.cnt = 0L;
        this.qn = 0.0;
    }

    public static void clearCodegen(boolean distinct, int column, CodegenMethodNode method) {
        method.getBlock().assignRef(CodegenExpressionBuilder.refCol("mean", column), CodegenExpressionBuilder.constant(0)).assignRef(CodegenExpressionBuilder.refCol("qn", column), CodegenExpressionBuilder.constant(0)).assignRef(CodegenExpressionBuilder.refCol("cnt", column), CodegenExpressionBuilder.constant(0));
        if (distinct) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]);
        }
    }

    @Override
    public Object getValue() {
        if (this.cnt < 2L) {
            return null;
        }
        return Math.sqrt(this.qn / (double)(this.cnt - 1L));
    }

    public static void getValueCodegen(int column, CodegenMethodNode method) {
        CodegenExpressionRefWCol qn = CodegenExpressionBuilder.refCol("qn", column);
        CodegenExpressionRefWCol cnt = CodegenExpressionBuilder.refCol("cnt", column);
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(cnt, CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(2))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.staticMethod(Math.class, "sqrt", CodegenExpressionBuilder.op(qn, "/", CodegenExpressionBuilder.op(cnt, "-", CodegenExpressionBuilder.constant(1)))));
    }
}

