/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.codegen.model.expression.CodegenExpressionTypePair;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.util.function.Consumer;

public class AggregatorCodegenUtil {
    public static CodegenExpressionRef sumRefCol(int column) {
        return CodegenExpressionBuilder.refCol("sum", column);
    }

    public static CodegenExpressionRef cntRefCol(int column) {
        return CodegenExpressionBuilder.refCol("cnt", column);
    }

    public static void rowMemberSumAndCnt(boolean distinct, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized, Class sumType) {
        membersColumnized.addMember(column, sumType, "sum");
        membersColumnized.addMember(column, Long.TYPE, "cnt");
        if (distinct) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    public static CodegenExpressionTypePair prefixWithFilterNullDistinctChecks(boolean enter, boolean distinct, boolean hasFilter, ExprForge[] forges, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        if (hasFilter) {
            AggregatorCodegenUtil.prefixWithFilterCheck(forges[forges.length - 1], method, symbols, classScope);
        }
        Class type = forges[0].getEvaluationType();
        CodegenExpression expr = forges[0].evaluateCodegen(Long.TYPE, method, symbols, classScope);
        method.getBlock().declareVar(type, "value", expr);
        if (!type.isPrimitive()) {
            method.getBlock().ifRefNull("value").blockReturnNoValue();
        }
        if (distinct) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), enter ? "add" : "remove", CodegenExpressionBuilder.ref("value")))).blockReturnNoValue();
        }
        return new CodegenExpressionTypePair(type, CodegenExpressionBuilder.ref("value"));
    }

    public static void prefixWithFilterCheck(ExprForge filterForge, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        Class filterType = filterForge.getEvaluationType();
        method.getBlock().declareVar(filterType, "pass", filterForge.evaluateCodegen(filterType, method, symbols, classScope));
        if (!filterType.isPrimitive()) {
            method.getBlock().ifRefNull("pass").blockReturnNoValue();
        }
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref("pass"))).blockReturnNoValue();
    }

    public static void sumAndCountApplyEnterCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope, SimpleNumberCoercer coercer) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(true, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRef sumRef = AggregatorCodegenUtil.sumRefCol(column);
        CodegenExpressionRef cntRef = AggregatorCodegenUtil.cntRefCol(column);
        method.getBlock().increment(cntRef).assignRef(sumRef, CodegenExpressionBuilder.op(sumRef, "+", coercer.coerceCodegen(value.getExpression(), value.getType())));
    }

    public static void sumAndCountApplyLeaveCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope, SimpleNumberCoercer coercer) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(false, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRef sumRef = AggregatorCodegenUtil.sumRefCol(column);
        CodegenExpressionRef cntRef = AggregatorCodegenUtil.cntRefCol(column);
        Consumer<CodegenBlock> clearCode = block -> block.assignRef(sumRef, CodegenExpressionBuilder.constant(0)).assignRef(cntRef, CodegenExpressionBuilder.constant(0));
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(cntRef, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(clearCode).ifElse().decrement(cntRef).assignRef(AggregatorCodegenUtil.sumRefCol(column), CodegenExpressionBuilder.op(AggregatorCodegenUtil.sumRefCol(column), "-", coercer.coerceCodegen(value.getExpression(), value.getType())));
    }

    public static void sumAndCountClearCodegen(boolean distinct, int column, CodegenMethodNode method) {
        method.getBlock().assignRef(AggregatorCodegenUtil.sumRefCol(column), CodegenExpressionBuilder.constant(0)).assignRef(AggregatorCodegenUtil.cntRefCol(column), CodegenExpressionBuilder.constant(0));
        if (distinct) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]);
        }
    }

    public static void getValueSum(int column, CodegenMethodNode method) {
        method.getBlock().ifCondition(CodegenExpressionBuilder.equalsIdentity(AggregatorCodegenUtil.cntRefCol(column), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(AggregatorCodegenUtil.sumRefCol(column));
    }

    protected static void sumAndCountBigApplyEnterCodegen(Class target, boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(true, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol sum = CodegenExpressionBuilder.refCol("sum", column);
        method.getBlock().increment(CodegenExpressionBuilder.refCol("cnt", column)).assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "add", value.getType() == target ? value.getExpression() : CodegenExpressionBuilder.cast(target, value.getExpression())));
    }

    protected static void sumAndCountBigApplyLeaveCodegen(Consumer<CodegenBlock> clear, Class target, boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(false, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol sum = CodegenExpressionBuilder.refCol("sum", column);
        CodegenExpressionRefWCol cnt = CodegenExpressionBuilder.refCol("cnt", column);
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(cnt, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(clear).ifElse().decrement(CodegenExpressionBuilder.refCol("cnt", column)).assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "subtract", value.getType() == target ? value.getExpression() : CodegenExpressionBuilder.cast(target, value.getExpression())));
    }
}

