/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.core;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.client.dataflow.EPDataFlowExceptionHandler;
import com.espertech.esper.client.dataflow.EPDataFlowInstantiationOptions;
import com.espertech.esper.client.dataflow.EPDataFlowSignal;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.dataflow.annotations.DataFlowContext;
import com.espertech.esper.dataflow.core.DataflowStartDesc;
import com.espertech.esper.dataflow.core.EPDataFlowEmitter1Stream1TargetPassAlong;
import com.espertech.esper.dataflow.core.EPDataFlowEmitter1Stream1TargetPassAlongWStream;
import com.espertech.esper.dataflow.core.EPDataFlowEmitter1Stream1TargetUnwind;
import com.espertech.esper.dataflow.core.EPDataFlowEmitter1StreamNTarget;
import com.espertech.esper.dataflow.core.EPDataFlowEmitterExceptionHandler;
import com.espertech.esper.dataflow.core.EPDataFlowEmitterNStreamNTarget;
import com.espertech.esper.dataflow.core.EPDataFlowEmitterNoTarget;
import com.espertech.esper.dataflow.core.EPDataFlowEmitterWrapperWStatistics;
import com.espertech.esper.dataflow.core.ObjectBindingPair;
import com.espertech.esper.dataflow.core.OperatorStatisticsProvider;
import com.espertech.esper.dataflow.core.SignalHandler;
import com.espertech.esper.dataflow.core.SignalHandlerDefault;
import com.espertech.esper.dataflow.core.SignalHandlerDefaultWInvoke;
import com.espertech.esper.dataflow.core.SignalHandlerDefaultWInvokeStream;
import com.espertech.esper.dataflow.core.SubmitHandler;
import com.espertech.esper.dataflow.interfaces.EPDataFlowEmitter;
import com.espertech.esper.dataflow.util.DataFlowSignalListener;
import com.espertech.esper.dataflow.util.DataFlowSignalManager;
import com.espertech.esper.dataflow.util.LogicalChannelBinding;
import com.espertech.esper.dataflow.util.LogicalChannelBindingMethodDesc;
import com.espertech.esper.dataflow.util.LogicalChannelBindingType;
import com.espertech.esper.dataflow.util.LogicalChannelBindingTypePassAlong;
import com.espertech.esper.dataflow.util.LogicalChannelBindingTypePassAlongWStream;
import com.espertech.esper.dataflow.util.LogicalChannelBindingTypeUnwind;
import com.espertech.esper.dataflow.util.LogicalChannelUtil;
import com.espertech.esper.dataflow.util.OperatorMetadataDescriptor;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationFactoryInterface {
    private static final Logger log = LoggerFactory.getLogger(RealizationFactoryInterface.class);

    public static DataflowStartDesc realize(String dataFlowName, Map<Integer, Object> operators, Map<Integer, OperatorMetadataDescriptor> operatorMetadata, Set<Integer> operatorBuildOrder, List<LogicalChannelBinding> bindings, DataFlowSignalManager dataFlowSignalManager, EPDataFlowInstantiationOptions options, EPServicesContext services, StatementContext statementContext) {
        String operatorPrettyPrint;
        HashMap<Integer, EPDataFlowEmitter> runtimeContexts = new HashMap<Integer, EPDataFlowEmitter>();
        OperatorStatisticsProvider statisticsProvider = null;
        if (options.isOperatorStatistics()) {
            statisticsProvider = new OperatorStatisticsProvider(operatorMetadata);
        }
        boolean audit = AuditEnum.DATAFLOW_OP.getAudit(statementContext.getAnnotations()) != null;
        for (int producerOpNum : operatorBuildOrder) {
            operatorPrettyPrint = operatorMetadata.get(producerOpNum).getOperatorPrettyPrint();
            if (log.isDebugEnabled()) {
                log.debug("Generating runtime context for " + operatorPrettyPrint);
            }
            Object producingOp = operators.get(producerOpNum);
            int numOutputStreams = operatorMetadata.get(producerOpNum).getOperatorSpec().getOutput().getItems().size();
            List<ObjectBindingPair>[] targets = RealizationFactoryInterface.getOperatorConsumersPerStream(numOutputStreams, producerOpNum, operators, operatorMetadata, bindings);
            EPDataFlowEmitter runtimeContext = RealizationFactoryInterface.generateRuntimeContext(statementContext.getEngineURI(), statementContext.getStatementName(), audit, dataFlowName, producerOpNum, operatorPrettyPrint, dataFlowSignalManager, targets, options, statementContext.getEngineImportService());
            if (options.isOperatorStatistics()) {
                runtimeContext = new EPDataFlowEmitterWrapperWStatistics(runtimeContext, producerOpNum, statisticsProvider, options.isCpuStatistics());
            }
            JavaClassHelper.setFieldForAnnotation(producingOp, DataFlowContext.class, runtimeContext);
            runtimeContexts.put(producerOpNum, runtimeContext);
        }
        for (int producerOpNum : operatorBuildOrder) {
            operatorPrettyPrint = operatorMetadata.get(producerOpNum).getOperatorPrettyPrint();
            if (log.isDebugEnabled()) {
                log.debug("Handling signals for " + operatorPrettyPrint);
            }
            HashSet<Integer> consumingOperatorsWithPunctuation = new HashSet<Integer>();
            for (LogicalChannelBinding binding : bindings) {
                if (!binding.getLogicalChannel().getOutputPort().isHasPunctuation() || binding.getLogicalChannel().getOutputPort().getProducingOpNum() != producerOpNum) continue;
                consumingOperatorsWithPunctuation.add(binding.getLogicalChannel().getConsumingOpNum());
            }
            Iterator<LogicalChannelBinding> iterator = consumingOperatorsWithPunctuation.iterator();
            while (iterator.hasNext()) {
                int consumerPunc = (Integer)((Object)iterator.next());
                final EPDataFlowEmitter context = (EPDataFlowEmitter)runtimeContexts.get(consumerPunc);
                if (context == null) continue;
                dataFlowSignalManager.addSignalListener(producerOpNum, new DataFlowSignalListener(){

                    @Override
                    public void processSignal(EPDataFlowSignal signal) {
                        context.submitSignal(signal);
                    }
                });
            }
        }
        return new DataflowStartDesc(statisticsProvider);
    }

    private static List<ObjectBindingPair>[] getOperatorConsumersPerStream(int numOutputStreams, int producingOperator, Map<Integer, Object> operators, Map<Integer, OperatorMetadataDescriptor> operatorMetadata, List<LogicalChannelBinding> bindings) {
        List<LogicalChannelBinding> channelsForProducer = LogicalChannelUtil.getBindingsConsuming(producingOperator, bindings);
        if (channelsForProducer.isEmpty()) {
            return null;
        }
        List[] submitTargets = new List[numOutputStreams];
        for (int i = 0; i < numOutputStreams; ++i) {
            submitTargets[i] = new ArrayList();
        }
        for (LogicalChannelBinding binding : channelsForProducer) {
            int consumingOp = binding.getLogicalChannel().getConsumingOpNum();
            Object operator = operators.get(consumingOp);
            int producingStreamNum = binding.getLogicalChannel().getOutputPort().getStreamNumber();
            List pairs = submitTargets[producingStreamNum];
            OperatorMetadataDescriptor metadata = operatorMetadata.get(consumingOp);
            pairs.add(new ObjectBindingPair(operator, metadata.getOperatorPrettyPrint(), binding));
        }
        return submitTargets;
    }

    private static SignalHandler getSignalHandler(int producerNum, Object target, LogicalChannelBindingMethodDesc consumingSignalBindingDesc, EngineImportService engineImportService) {
        if (consumingSignalBindingDesc == null) {
            return SignalHandlerDefault.INSTANCE;
        }
        if (consumingSignalBindingDesc.getBindingType() instanceof LogicalChannelBindingTypePassAlong) {
            return new SignalHandlerDefaultWInvoke(target, consumingSignalBindingDesc.getMethod(), engineImportService);
        }
        if (consumingSignalBindingDesc.getBindingType() instanceof LogicalChannelBindingTypePassAlongWStream) {
            LogicalChannelBindingTypePassAlongWStream streamInfo = (LogicalChannelBindingTypePassAlongWStream)consumingSignalBindingDesc.getBindingType();
            return new SignalHandlerDefaultWInvokeStream(target, consumingSignalBindingDesc.getMethod(), engineImportService, streamInfo.getStreamNum());
        }
        throw new IllegalStateException("Unrecognized signal binding: " + consumingSignalBindingDesc.getBindingType());
    }

    private static SubmitHandler getSubmitHandler(String engineURI, String statementName, boolean audit, String dataflowName, int producerOpNum, String operatorPrettyPrint, DataFlowSignalManager dataFlowSignalManager, ObjectBindingPair target, EPDataFlowExceptionHandler optionalExceptionHandler, EngineImportService engineImportService) {
        SignalHandler signalHandler = RealizationFactoryInterface.getSignalHandler(producerOpNum, target.getTarget(), target.getBinding().getConsumingSignalBindingDesc(), engineImportService);
        int receivingOpNum = target.getBinding().getLogicalChannel().getConsumingOpNum();
        String receivingOpPretty = target.getBinding().getLogicalChannel().getConsumingOpPrettyPrint();
        String receivingOpName = target.getBinding().getLogicalChannel().getConsumingOpName();
        EPDataFlowEmitterExceptionHandler exceptionHandler = new EPDataFlowEmitterExceptionHandler(engineURI, statementName, audit, dataflowName, receivingOpName, receivingOpNum, receivingOpPretty, optionalExceptionHandler);
        LogicalChannelBindingType bindingType = target.getBinding().getConsumingBindingDesc().getBindingType();
        if (bindingType instanceof LogicalChannelBindingTypePassAlong) {
            return new EPDataFlowEmitter1Stream1TargetPassAlong(producerOpNum, dataFlowSignalManager, signalHandler, exceptionHandler, target, engineImportService);
        }
        if (bindingType instanceof LogicalChannelBindingTypePassAlongWStream) {
            LogicalChannelBindingTypePassAlongWStream type = (LogicalChannelBindingTypePassAlongWStream)bindingType;
            return new EPDataFlowEmitter1Stream1TargetPassAlongWStream(producerOpNum, dataFlowSignalManager, signalHandler, exceptionHandler, target, type.getStreamNum(), engineImportService);
        }
        if (bindingType instanceof LogicalChannelBindingTypeUnwind) {
            return new EPDataFlowEmitter1Stream1TargetUnwind(producerOpNum, dataFlowSignalManager, signalHandler, exceptionHandler, target, engineImportService);
        }
        throw new UnsupportedOperationException("Unsupported binding type '" + bindingType + "'");
    }

    private static EPDataFlowEmitter generateRuntimeContext(String engineURI, String statementName, boolean audit, String dataflowName, int producerOpNum, String operatorPrettyPrint, DataFlowSignalManager dataFlowSignalManager, List<ObjectBindingPair>[] targetsPerStream, EPDataFlowInstantiationOptions options, EngineImportService engineImportService) {
        if (targetsPerStream == null) {
            return new EPDataFlowEmitterNoTarget(producerOpNum, dataFlowSignalManager);
        }
        if (targetsPerStream.length == 1) {
            List<ObjectBindingPair> targets = targetsPerStream[0];
            if (targets.size() == 1) {
                ObjectBindingPair target = targets.get(0);
                return RealizationFactoryInterface.getSubmitHandler(engineURI, statementName, audit, dataflowName, producerOpNum, operatorPrettyPrint, dataFlowSignalManager, target, options.getExceptionHandler(), engineImportService);
            }
            SubmitHandler[] handlers = new SubmitHandler[targets.size()];
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i] = RealizationFactoryInterface.getSubmitHandler(engineURI, statementName, audit, dataflowName, producerOpNum, operatorPrettyPrint, dataFlowSignalManager, targets.get(i), options.getExceptionHandler(), engineImportService);
            }
            return new EPDataFlowEmitter1StreamNTarget(producerOpNum, dataFlowSignalManager, handlers);
        }
        SubmitHandler[][] handlersPerStream = new SubmitHandler[targetsPerStream.length][];
        for (int streamNum = 0; streamNum < targetsPerStream.length; ++streamNum) {
            SubmitHandler[] handlers = new SubmitHandler[targetsPerStream[streamNum].size()];
            handlersPerStream[streamNum] = handlers;
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i] = RealizationFactoryInterface.getSubmitHandler(engineURI, statementName, audit, dataflowName, producerOpNum, operatorPrettyPrint, dataFlowSignalManager, targetsPerStream[streamNum].get(i), options.getExceptionHandler(), engineImportService);
            }
        }
        return new EPDataFlowEmitterNStreamNTarget(producerOpNum, dataFlowSignalManager, handlersPerStream);
    }
}

