/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.core.start.EPStatementStartMethod;
import com.espertech.esper.core.start.EPStatementStartMethodCreateContext;
import com.espertech.esper.core.start.EPStatementStartMethodCreateExpression;
import com.espertech.esper.core.start.EPStatementStartMethodCreateGraph;
import com.espertech.esper.core.start.EPStatementStartMethodCreateIndex;
import com.espertech.esper.core.start.EPStatementStartMethodCreateSchema;
import com.espertech.esper.core.start.EPStatementStartMethodCreateTable;
import com.espertech.esper.core.start.EPStatementStartMethodCreateVariable;
import com.espertech.esper.core.start.EPStatementStartMethodCreateWindow;
import com.espertech.esper.core.start.EPStatementStartMethodOnTrigger;
import com.espertech.esper.core.start.EPStatementStartMethodSelect;
import com.espertech.esper.core.start.EPStatementStartMethodUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPStatementStartMethodFactory {
    private static final Logger log = LoggerFactory.getLogger(EPStatementStartMethodFactory.class);

    public static EPStatementStartMethod makeStartMethod(StatementSpecCompiled statementSpec) {
        if (statementSpec.getUpdateSpec() != null) {
            return new EPStatementStartMethodUpdate(statementSpec);
        }
        if (statementSpec.getOnTriggerDesc() != null) {
            return new EPStatementStartMethodOnTrigger(statementSpec);
        }
        if (statementSpec.getCreateWindowDesc() != null) {
            return new EPStatementStartMethodCreateWindow(statementSpec);
        }
        if (statementSpec.getCreateIndexDesc() != null) {
            return new EPStatementStartMethodCreateIndex(statementSpec);
        }
        if (statementSpec.getCreateGraphDesc() != null) {
            return new EPStatementStartMethodCreateGraph(statementSpec);
        }
        if (statementSpec.getCreateSchemaDesc() != null) {
            return new EPStatementStartMethodCreateSchema(statementSpec);
        }
        if (statementSpec.getCreateVariableDesc() != null) {
            return new EPStatementStartMethodCreateVariable(statementSpec);
        }
        if (statementSpec.getCreateTableDesc() != null) {
            return new EPStatementStartMethodCreateTable(statementSpec);
        }
        if (statementSpec.getContextDesc() != null) {
            return new EPStatementStartMethodCreateContext(statementSpec);
        }
        if (statementSpec.getCreateExpressionDesc() != null) {
            return new EPStatementStartMethodCreateExpression(statementSpec);
        }
        return new EPStatementStartMethodSelect(statementSpec);
    }
}

