/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateTable;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateTableResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementCreateAggregationVariableDesc;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprTypedNoEvalNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.CreateTableColumn;
import com.espertech.esper.epl.spec.CreateTableDesc;
import com.espertech.esper.epl.table.mgmt.TableColumnDesc;
import com.espertech.esper.epl.table.mgmt.TableColumnDescAgg;
import com.espertech.esper.epl.table.mgmt.TableColumnDescTyped;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairAggAccess;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairAggMethod;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairPlainCol;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPlain;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import com.espertech.esper.epl.table.mgmt.TableStateRowFactory;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPStatementStartMethodCreateTable
extends EPStatementStartMethodBase {
    private static final Logger log = LoggerFactory.getLogger(EPStatementStartMethodCreateTable.class);

    public EPStatementStartMethodCreateTable(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(final EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementDestroyMethod destroyStatementMethod;
        EPStatementStopMethod stopStatementMethod;
        Viewable outputView;
        TableMetadata metadata;
        CreateTableDesc createDesc = this.statementSpec.getCreateTableDesc();
        VariableServiceUtil.checkAlreadyDeclaredVariable(createDesc.getTableName(), services.getVariableService());
        if (isNewStatement) {
            VariableServiceUtil.checkAlreadyDeclaredTable(createDesc.getTableName(), services.getTableService());
        }
        if (services.getEventAdapterService().getExistsTypeByName(createDesc.getTableName()) != null) {
            throw new ExprValidationException("An event type or schema by name '" + createDesc.getTableName() + "' already exists");
        }
        String internalTypeName = "table_" + createDesc.getTableName() + "__internal";
        String publicTypeName = "table_" + createDesc.getTableName() + "__public";
        try {
            Class[] keyTypes = this.getKeyTypes(createDesc.getColumns(), services.getEngineImportService());
            List<TableColumnDesc> columnDescs = this.validateExpressions(createDesc.getColumns(), services, statementContext);
            TableAccessAnalysisResult plan = this.analyzePlanAggregations(createDesc.getTableName(), statementContext, columnDescs, services, internalTypeName, publicTypeName);
            TableStateRowFactory tableStateRowFactory = plan.getStateRowFactory();
            boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
            metadata = services.getTableService().addTable(createDesc.getTableName(), statementContext.getExpression(), statementContext.getStatementName(), keyTypes, plan.getTableColumns(), tableStateRowFactory, plan.getNumberMethodAggregations(), statementContext, plan.getInternalEventType(), plan.getPublicEventType(), plan.getEventToPublic(), queryPlanLogging);
        }
        catch (ExprValidationException ex) {
            services.getEventAdapterService().removeType(internalTypeName);
            services.getEventAdapterService().removeType(publicTypeName);
            throw ex;
        }
        StatementAgentInstanceFactoryCreateTable contextFactory = new StatementAgentInstanceFactoryCreateTable(metadata);
        statementContext.setStatementAgentInstanceFactory(contextFactory);
        if (this.statementSpec.getOptionalContextName() != null) {
            ContextMergeView mergeView;
            final String contextName = this.statementSpec.getOptionalContextName();
            outputView = mergeView = new ContextMergeView(metadata.getPublicEventType());
            ContextManagedStatementCreateAggregationVariableDesc statement = new ContextManagedStatementCreateAggregationVariableDesc(this.statementSpec, statementContext, mergeView, contextFactory);
            services.getContextManagementService().addStatement(this.statementSpec.getOptionalContextName(), statement, isRecoveringResilient);
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    services.getContextManagementService().stoppedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getExpression(), statementContext.getExceptionHandlingService());
                }
            };
            destroyStatementMethod = new EPStatementDestroyMethod(){

                @Override
                public void destroy() {
                    services.getContextManagementService().destroyedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId());
                    services.getStatementVariableRefService().removeReferencesStatement(statementContext.getStatementName());
                }
            };
        } else {
            AgentInstanceContext defaultAgentInstanceContext = this.getDefaultAgentInstanceContext(statementContext);
            StatementAgentInstanceFactoryCreateTableResult result = contextFactory.newContext(defaultAgentInstanceContext, false);
            if (statementContext.getStatementExtensionServicesContext() != null && statementContext.getStatementExtensionServicesContext().getStmtResources() != null) {
                StatementResourceHolder holder = statementContext.getStatementExtensionServicesContext().extractStatementResourceHolder(result);
                statementContext.getStatementExtensionServicesContext().getStmtResources().setUnpartitioned(holder);
            }
            outputView = result.getFinalView();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                }
            };
            destroyStatementMethod = new EPStatementDestroyMethod(){

                @Override
                public void destroy() {
                    services.getStatementVariableRefService().removeReferencesStatement(statementContext.getStatementName());
                }
            };
        }
        services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), createDesc.getTableName());
        return new EPStatementStartResult(outputView, stopStatementMethod, destroyStatementMethod);
    }

    private Class[] getKeyTypes(List<CreateTableColumn> columns, EngineImportService engineImportService) throws ExprValidationException {
        ArrayList<Class> keys = new ArrayList<Class>();
        for (CreateTableColumn col : columns) {
            if (col.getPrimaryKey() == null || !col.getPrimaryKey().booleanValue()) continue;
            String msg = "Column '" + col.getColumnName() + "' may not be tagged as primary key";
            if (col.getOptExpression() != null) {
                throw new ExprValidationException(msg + ", an expression cannot become a primary key column");
            }
            if (col.getOptTypeIsArray() != null && col.getOptTypeIsArray().booleanValue()) {
                throw new ExprValidationException(msg + ", an array-typed column cannot become a primary key column");
            }
            Object type = EventTypeUtility.buildType(new ColumnDesc(col.getColumnName(), col.getOptTypeName(), false, false), engineImportService);
            if (!(type instanceof Class)) {
                throw new ExprValidationException(msg + ", received unexpected event type '" + type + "'");
            }
            keys.add((Class)type);
        }
        return keys.toArray(new Class[keys.size()]);
    }

    private ExprAggregateNode validateAggregationExpr(ExprNode columnExpressionType, EventType optionalProvidedType, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        boolean[] istreamOnly;
        String[] streamNames;
        EventType[] types;
        if (optionalProvidedType != null) {
            types = new EventType[]{optionalProvidedType};
            streamNames = new String[]{types[0].getName()};
            istreamOnly = new boolean[]{false};
        } else {
            types = new EventType[]{};
            streamNames = new String[]{};
            istreamOnly = new boolean[]{};
        }
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(types, streamNames, istreamOnly, services.getEngineURI(), false, false);
        ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), new ExprEvaluatorContextStatement(statementContext, false), statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
        for (ExprNode childNode : columnExpressionType.getChildNodes()) {
            if (!(childNode instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)childNode;
            String propname = identNode.getFullUnresolvedName().trim();
            Class clazz = JavaClassHelper.getClassForSimpleName(propname, services.getEngineImportService().getClassForNameProvider());
            if (propname.toLowerCase(Locale.ENGLISH).trim().equals("object")) {
                clazz = Object.class;
            }
            EngineImportException ex = null;
            if (clazz == null) {
                try {
                    clazz = services.getEngineImportService().resolveClass(propname, false);
                }
                catch (EngineImportException e) {
                    ex = e;
                }
            }
            if (clazz != null) {
                ExprTypedNoEvalNode typeNode = new ExprTypedNoEvalNode(propname, clazz);
                ExprNodeUtilityCore.replaceChildNode(columnExpressionType, identNode, typeNode);
                continue;
            }
            if (optionalProvidedType != null) continue;
            if (ex != null) {
                throw new ExprValidationException("Failed to resolve type '" + propname + "': " + ex.getMessage(), ex);
            }
            throw new ExprValidationException("Failed to resolve type '" + propname + "'");
        }
        ExprNode validated = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.CREATETABLECOLUMN, columnExpressionType, validationContext);
        if (!(validated instanceof ExprAggregateNode)) {
            throw new ExprValidationException("Expression '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(validated) + "' is not an aggregation");
        }
        return (ExprAggregateNode)validated;
    }

    private List<TableColumnDesc> validateExpressions(List<CreateTableColumn> columns, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        HashSet<String> columnNames = new HashSet<String>();
        ArrayList<TableColumnDesc> descriptors = new ArrayList<TableColumnDesc>();
        int positionInDeclaration = 0;
        for (CreateTableColumn column : columns) {
            TableColumnDesc descriptor;
            String msgprefix = "For column '" + column.getColumnName() + "'";
            if (columnNames.contains(column.getColumnName())) {
                throw new ExprValidationException("Column '" + column.getColumnName() + "' is listed more than once");
            }
            columnNames.add(column.getColumnName());
            EventType optionalEventType = EPStatementStartMethodCreateTable.validateExpressionGetEventType(msgprefix, column.getAnnotations(), services.getEventAdapterService());
            if (column.getOptExpression() != null) {
                ExprAggregateNode validated = this.validateAggregationExpr(column.getOptExpression(), optionalEventType, services, statementContext);
                descriptor = new TableColumnDescAgg(positionInDeclaration, column.getColumnName(), validated, optionalEventType);
            } else {
                Object unresolvedType = EventTypeUtility.buildType(new ColumnDesc(column.getColumnName(), column.getOptTypeName(), column.getOptTypeIsArray() == null ? false : column.getOptTypeIsArray(), column.getOptTypeIsPrimitiveArray() == null ? false : column.getOptTypeIsPrimitiveArray()), services.getEngineImportService());
                descriptor = new TableColumnDescTyped(positionInDeclaration, column.getColumnName(), unresolvedType, column.getPrimaryKey() == null ? false : column.getPrimaryKey());
            }
            descriptors.add(descriptor);
            ++positionInDeclaration;
        }
        return descriptors;
    }

    private static EventType validateExpressionGetEventType(String msgprefix, List<AnnotationDesc> annotations, EventAdapterService eventAdapterService) throws ExprValidationException {
        String typeName;
        Map<String, List<AnnotationDesc>> annos = AnnotationUtil.mapByNameLowerCase(annotations);
        List<AnnotationDesc> typeAnnos = annos.remove("type");
        if (!annos.isEmpty()) {
            throw new ExprValidationException(msgprefix + " unrecognized annotation '" + annos.keySet().iterator().next() + "'");
        }
        EventType optionalType = null;
        if (typeAnnos != null && (optionalType = eventAdapterService.getExistsTypeByName(typeName = AnnotationUtil.getExpectSingleStringValue(msgprefix, typeAnnos))) == null) {
            throw new ExprValidationException(msgprefix + " failed to find event type '" + typeName + "'");
        }
        return optionalType;
    }

    private TableAccessAnalysisResult analyzePlanAggregations(String tableName, StatementContext statementContext, List<TableColumnDesc> columns, EPServicesContext services, String internalTypeName, String publicTypeName) throws ExprValidationException {
        ObjectArrayEventType publicEventType;
        ObjectArrayEventType internalEventType;
        HashMap<TableColumnDesc, AggregationMethodFactory> aggregationFactories = new HashMap<TableColumnDesc, AggregationMethodFactory>();
        for (TableColumnDesc column : columns) {
            if (!(column instanceof TableColumnDescAgg)) continue;
            TableColumnDescAgg agg = (TableColumnDescAgg)column;
            AggregationMethodFactory factory = agg.getAggregation().getFactory();
            aggregationFactories.put(column, factory);
        }
        ArrayList<TableColumnDescTyped> plainColumns = new ArrayList<TableColumnDescTyped>();
        ArrayList<TableColumnDescAgg> methodAggColumns = new ArrayList<TableColumnDescAgg>();
        ArrayList<TableColumnDescAgg> accessAggColumns = new ArrayList<TableColumnDescAgg>();
        LinkedHashMap<String, Object> allColumnsPublicTypes = new LinkedHashMap<String, Object>();
        for (TableColumnDesc column : columns) {
            if (column instanceof TableColumnDescTyped) {
                TableColumnDescTyped typed = (TableColumnDescTyped)column;
                plainColumns.add(typed);
                allColumnsPublicTypes.put(column.getColumnName(), typed.getUnresolvedType());
                continue;
            }
            TableColumnDescAgg agg = (TableColumnDescAgg)column;
            AggregationMethodFactory aggFactory = (AggregationMethodFactory)aggregationFactories.get(agg);
            if (aggFactory.isAccessAggregation()) {
                accessAggColumns.add(agg);
            } else {
                methodAggColumns.add(agg);
            }
            allColumnsPublicTypes.put(column.getColumnName(), agg.getAggregation().getEvaluationType());
        }
        LinkedHashMap<String, TableMetadataColumn> columnMetadata = new LinkedHashMap<String, TableMetadataColumn>();
        LinkedHashMap<String, Object> allColumnsInternalTypes = new LinkedHashMap<String, Object>();
        allColumnsInternalTypes.put("internal-reserved", Object.class);
        int indexPlain = 1;
        ArrayList<Integer> groupKeyIndexes = new ArrayList<Integer>();
        TableMetadataColumnPairPlainCol[] assignPairsPlain = new TableMetadataColumnPairPlainCol[plainColumns.size()];
        for (TableColumnDescTyped typedColumn : plainColumns) {
            allColumnsInternalTypes.put(typedColumn.getColumnName(), typedColumn.getUnresolvedType());
            columnMetadata.put(typedColumn.getColumnName(), new TableMetadataColumnPlain(typedColumn.getColumnName(), typedColumn.isKey(), indexPlain));
            if (typedColumn.isKey()) {
                groupKeyIndexes.add(indexPlain);
            }
            assignPairsPlain[indexPlain - 1] = new TableMetadataColumnPairPlainCol(typedColumn.getPositionInDeclaration(), indexPlain);
            ++indexPlain;
        }
        try {
            internalEventType = (ObjectArrayEventType)services.getEventAdapterService().addNestableObjectArrayType(internalTypeName, allColumnsInternalTypes, null, false, false, false, false, false, true, tableName);
            publicEventType = (ObjectArrayEventType)services.getEventAdapterService().addNestableObjectArrayType(publicTypeName, allColumnsPublicTypes, null, false, false, false, false, false, false, null);
        }
        catch (EPException ex) {
            throw new ExprValidationException("Invalid type information: " + ex.getMessage(), ex);
        }
        services.getStatementEventTypeRefService().addReferences(statementContext.getStatementName(), new String[]{internalTypeName, publicTypeName});
        AggregationMethodFactory[] methodFactories = new AggregationMethodFactory[methodAggColumns.size()];
        int index = 0;
        TableMetadataColumnPairAggMethod[] assignPairsMethod = new TableMetadataColumnPairAggMethod[methodAggColumns.size()];
        for (TableColumnDescAgg column : methodAggColumns) {
            AggregationMethodFactory factory = (AggregationMethodFactory)aggregationFactories.get(column);
            EPType optionalEnumerationType = EPTypeHelper.optionalFromEnumerationExpr(statementContext.getStatementId(), statementContext.getEventAdapterService(), column.getAggregation());
            methodFactories[index] = factory;
            columnMetadata.put(column.getColumnName(), new TableMetadataColumnAggregation(column.getColumnName(), factory, index, null, optionalEnumerationType, column.getOptionalAssociatedType()));
            assignPairsMethod[index] = new TableMetadataColumnPairAggMethod(column.getPositionInDeclaration());
            ++index;
        }
        AggregationStateFactory[] stateFactories = new AggregationStateFactory[accessAggColumns.size()];
        TableMetadataColumnPairAggAccess[] assignPairsAccess = new TableMetadataColumnPairAggAccess[accessAggColumns.size()];
        index = 0;
        for (TableColumnDescAgg column : accessAggColumns) {
            AggregationMethodFactory factory = (AggregationMethodFactory)aggregationFactories.get(column);
            AggregationStateFactoryForge forge = factory.getAggregationStateFactory(false);
            stateFactories[index] = forge.makeFactory(statementContext.getEngineImportService(), false, statementContext.getStatementName());
            AggregationAccessor accessor = factory.getAccessorForge() == null ? null : factory.getAccessorForge().getAccessor(statementContext.getEngineImportService(), false, statementContext.getStatementName());
            AggregationAccessorSlotPair pair = new AggregationAccessorSlotPair(index, accessor);
            EPType optionalEnumerationType = EPTypeHelper.optionalFromEnumerationExpr(statementContext.getStatementId(), statementContext.getEventAdapterService(), column.getAggregation());
            columnMetadata.put(column.getColumnName(), new TableMetadataColumnAggregation(column.getColumnName(), factory, -1, pair, optionalEnumerationType, column.getOptionalAssociatedType()));
            assignPairsAccess[index] = new TableMetadataColumnPairAggAccess(column.getPositionInDeclaration(), accessor);
            ++index;
        }
        int[] groupKeyIndexesArr = CollectionUtil.intArray(groupKeyIndexes);
        TableStateRowFactory stateRowFactory = new TableStateRowFactory(internalEventType, statementContext.getEngineImportService(), methodFactories, stateFactories, groupKeyIndexesArr, services.getEventAdapterService());
        TableMetadataInternalEventToPublic eventToPublic = new TableMetadataInternalEventToPublic(publicEventType, assignPairsPlain, assignPairsMethod, assignPairsAccess, services.getEventAdapterService());
        return new TableAccessAnalysisResult(stateRowFactory, columnMetadata, methodAggColumns.size(), internalEventType, publicEventType, eventToPublic);
    }

    private static class TableAccessAnalysisResult {
        private final TableStateRowFactory stateRowFactory;
        private final Map<String, TableMetadataColumn> tableColumns;
        private final int numberMethodAggregations;
        private final ObjectArrayEventType internalEventType;
        private final ObjectArrayEventType publicEventType;
        private final TableMetadataInternalEventToPublic eventToPublic;

        private TableAccessAnalysisResult(TableStateRowFactory stateRowFactory, Map<String, TableMetadataColumn> tableColumns, int numberMethodAggregations, ObjectArrayEventType internalEventType, ObjectArrayEventType publicEventType, TableMetadataInternalEventToPublic eventToPublic) {
            this.stateRowFactory = stateRowFactory;
            this.tableColumns = tableColumns;
            this.numberMethodAggregations = numberMethodAggregations;
            this.internalEventType = internalEventType;
            this.publicEventType = publicEventType;
            this.eventToPublic = eventToPublic;
        }

        public TableStateRowFactory getStateRowFactory() {
            return this.stateRowFactory;
        }

        public Map<String, TableMetadataColumn> getTableColumns() {
            return this.tableColumns;
        }

        public int getNumberMethodAggregations() {
            return this.numberMethodAggregations;
        }

        public ObjectArrayEventType getInternalEventType() {
            return this.internalEventType;
        }

        public ObjectArrayEventType getPublicEventType() {
            return this.publicEventType;
        }

        public TableMetadataInternalEventToPublic getEventToPublic() {
            return this.eventToPublic;
        }
    }
}

