/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.table.mgmt.TableService;
import java.util.List;

public class StatementContextFactoryUtil {
    public static boolean determineHasTableAccess(List<ExprSubselectNode> subselectNodes, StatementSpecRaw statementSpecRaw, EPServicesContext engineServices) {
        boolean hasTableAccess = statementSpecRaw.getTableExpressions() != null && !statementSpecRaw.getTableExpressions().isEmpty() || statementSpecRaw.getIntoTableSpec() != null;
        hasTableAccess = hasTableAccess || StatementContextFactoryUtil.isJoinWithTable(statementSpecRaw, engineServices.getTableService()) || StatementContextFactoryUtil.isSubqueryWithTable(subselectNodes, engineServices.getTableService()) || StatementContextFactoryUtil.isInsertIntoTable(statementSpecRaw, engineServices.getTableService());
        return hasTableAccess;
    }

    private static boolean isInsertIntoTable(StatementSpecRaw statementSpecRaw, TableService tableService) {
        if (statementSpecRaw.getInsertIntoDesc() == null) {
            return false;
        }
        return tableService.getTableMetadata(statementSpecRaw.getInsertIntoDesc().getEventTypeName()) != null;
    }

    private static boolean isSubqueryWithTable(List<ExprSubselectNode> subselectNodes, TableService tableService) {
        for (ExprSubselectNode node : subselectNodes) {
            FilterStreamSpecRaw spec = (FilterStreamSpecRaw)node.getStatementSpecRaw().getStreamSpecs().get(0);
            if (tableService.getTableMetadata(spec.getRawFilterSpec().getEventTypeName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isJoinWithTable(StatementSpecRaw statementSpecRaw, TableService tableService) {
        for (StreamSpecRaw stream : statementSpecRaw.getStreamSpecs()) {
            FilterStreamSpecRaw filter;
            if (!(stream instanceof FilterStreamSpecRaw) || tableService.getTableMetadata((filter = (FilterStreamSpecRaw)stream).getRawFilterSpec().getEventTypeName()) == null) continue;
            return true;
        }
        return false;
    }
}

