/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.core.service.ExpressionResultCacheForDeclaredExprLastColl;
import com.espertech.esper.core.service.ExpressionResultCacheForDeclaredExprLastValue;
import com.espertech.esper.core.service.ExpressionResultCacheForEnumerationMethod;
import com.espertech.esper.core.service.ExpressionResultCacheForPropUnwrap;
import com.espertech.esper.core.service.ExpressionResultCacheServiceHolder;

public class ExpressionResultCacheService {
    private final int declareExprCacheSize;
    private final ThreadLocal<ExpressionResultCacheServiceHolder> threadCache;

    public ExpressionResultCacheService(final int declareExprCacheSize) {
        this.declareExprCacheSize = declareExprCacheSize;
        this.threadCache = new ThreadLocal<ExpressionResultCacheServiceHolder>(){

            @Override
            protected synchronized ExpressionResultCacheServiceHolder initialValue() {
                return new ExpressionResultCacheServiceHolder(declareExprCacheSize);
            }
        };
    }

    public ExpressionResultCacheForPropUnwrap getAllocateUnwrapProp() {
        return this.threadCache.get().getAllocateUnwrapProp();
    }

    public ExpressionResultCacheForDeclaredExprLastValue getAllocateDeclaredExprLastValue() {
        return this.threadCache.get().getAllocateDeclaredExprLastValue();
    }

    public ExpressionResultCacheForDeclaredExprLastColl getAllocateDeclaredExprLastColl() {
        return this.threadCache.get().getAllocateDeclaredExprLastColl();
    }

    public ExpressionResultCacheForEnumerationMethod getAllocateEnumerationMethod() {
        return this.threadCache.get().getAllocateEnumerationMethod();
    }

    public boolean isDeclaredExprCacheEnabled() {
        return this.declareExprCacheSize > 0;
    }
}

