/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.subselect;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactory;
import com.espertech.esper.core.context.subselect.SubSelectStrategyRealization;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.lookup.SubordFullTableScanLookupStrategyLocking;
import com.espertech.esper.epl.lookup.SubordFullTableScanTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyLocking;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupTableStrategy;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordinateQueryPlanDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlanner;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerUtil;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorBase;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredUngrouped;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableServiceImpl;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;

public class SubSelectStrategyFactoryIndexShare
implements SubSelectStrategyFactory {
    private final NamedWindowProcessor optionalNamedWindowProcessor;
    private final TableMetadata optionalTableMetadata;
    private final ExprEvaluator filterExprEval;
    private final AggregationServiceFactoryDesc aggregationServiceFactory;
    private final ExprEvaluator[] groupByKeys;
    private final TableService tableService;
    private SubordinateQueryPlanDesc queryPlan;

    public SubSelectStrategyFactoryIndexShare(final String statementName, int statementId, int subqueryNum, EventType[] outerEventTypesSelect, final NamedWindowProcessor optionalNamedWindowProcessor, TableMetadata optionalTableMetadata, boolean fullTableScan, IndexHint optionalIndexHint, SubordPropPlan joinedPropPlan, ExprEvaluator filterExprEval, AggregationServiceFactoryDesc aggregationServiceFactory, ExprEvaluator[] groupByKeys, TableService tableService, Annotation[] annotations, StatementStopService statementStopService, EngineImportService engineImportService) throws ExprValidationException {
        Logger log;
        boolean isLogging;
        this.optionalNamedWindowProcessor = optionalNamedWindowProcessor;
        this.optionalTableMetadata = optionalTableMetadata;
        this.filterExprEval = filterExprEval;
        this.aggregationServiceFactory = aggregationServiceFactory;
        this.groupByKeys = groupByKeys;
        this.tableService = tableService;
        if (optionalTableMetadata != null) {
            isLogging = optionalTableMetadata.isQueryPlanLogging();
            log = TableServiceImpl.getQueryPlanLog();
            this.queryPlan = SubordinateQueryPlanner.planSubquery(outerEventTypesSelect, joinedPropPlan, false, fullTableScan, optionalIndexHint, true, subqueryNum, false, optionalTableMetadata.getEventTableIndexMetadataRepo(), optionalTableMetadata.getUniqueKeyProps(), true, statementName, statementId, annotations);
            if (this.queryPlan != null) {
                for (int i = 0; i < this.queryPlan.getIndexDescs().length; ++i) {
                    optionalTableMetadata.addIndexReference(this.queryPlan.getIndexDescs()[i].getIndexName(), statementName);
                }
            }
        } else {
            isLogging = optionalNamedWindowProcessor.getRootView().isQueryPlanLogging();
            log = NamedWindowRootView.getQueryPlanLog();
            this.queryPlan = SubordinateQueryPlanner.planSubquery(outerEventTypesSelect, joinedPropPlan, false, fullTableScan, optionalIndexHint, true, subqueryNum, optionalNamedWindowProcessor.isVirtualDataWindow(), optionalNamedWindowProcessor.getEventTableIndexMetadataRepo(), optionalNamedWindowProcessor.getOptionalUniqueKeyProps(), false, statementName, statementId, annotations);
            if (this.queryPlan != null && this.queryPlan.getIndexDescs() != null) {
                SubordinateQueryPlannerUtil.addIndexMetaAndRef(this.queryPlan.getIndexDescs(), optionalNamedWindowProcessor.getEventTableIndexMetadataRepo(), statementName);
                statementStopService.addSubscriber(new StatementStopCallback(){

                    @Override
                    public void statementStopped() {
                        for (int i = 0; i < SubSelectStrategyFactoryIndexShare.this.queryPlan.getIndexDescs().length; ++i) {
                            boolean last = optionalNamedWindowProcessor.getEventTableIndexMetadataRepo().removeIndexReference(SubSelectStrategyFactoryIndexShare.this.queryPlan.getIndexDescs()[i].getIndexMultiKey(), statementName);
                            if (!last) continue;
                            optionalNamedWindowProcessor.getEventTableIndexMetadataRepo().removeIndex(SubSelectStrategyFactoryIndexShare.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                            optionalNamedWindowProcessor.removeAllInstanceIndexes(SubSelectStrategyFactoryIndexShare.this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                        }
                    }
                });
            }
        }
        SubordinateQueryPlannerUtil.queryPlanLogOnSubq(isLogging, log, this.queryPlan, subqueryNum, annotations, engineImportService);
    }

    @Override
    public SubSelectStrategyRealization instantiate(EPServicesContext services, Viewable viewableRoot, AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbackList, int subqueryNumber, boolean isRecoveringResilient) {
        SubordTableLookupStrategy subqueryLookup;
        SubselectAggregationPreprocessorBase subselectAggregationPreprocessor = null;
        AggregationService aggregationService = null;
        if (this.aggregationServiceFactory != null) {
            aggregationService = this.aggregationServiceFactory.getAggregationServiceFactory().makeService(agentInstanceContext, agentInstanceContext.getEngineImportService(), true, subqueryNumber);
            subselectAggregationPreprocessor = this.groupByKeys == null ? (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredUngrouped(aggregationService, this.filterExprEval, null) : new SubselectAggregationPreprocessorFilteredUngrouped(aggregationService, this.filterExprEval, null)) : (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredGrouped(aggregationService, this.filterExprEval, this.groupByKeys) : new SubselectAggregationPreprocessorFilteredGrouped(aggregationService, this.filterExprEval, this.groupByKeys));
        }
        if (this.optionalNamedWindowProcessor != null) {
            NamedWindowProcessorInstance instance = this.optionalNamedWindowProcessor.getProcessorInstance(agentInstanceContext);
            if (this.queryPlan == null) {
                if (instance.getRootViewInstance().isQueryPlanLogging() && NamedWindowRootView.getQueryPlanLog().isInfoEnabled()) {
                    NamedWindowRootView.getQueryPlanLog().info("shared, full table scan");
                }
                subqueryLookup = new SubordFullTableScanLookupStrategyLocking(instance.getRootViewInstance().getDataWindowContents(), agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock());
            } else {
                EventTable[] tables = null;
                if (!this.optionalNamedWindowProcessor.isVirtualDataWindow()) {
                    tables = SubordinateQueryPlannerUtil.realizeTables(this.queryPlan.getIndexDescs(), instance.getRootViewInstance().getEventType(), instance.getRootViewInstance().getIndexRepository(), instance.getRootViewInstance().getDataWindowContents(), agentInstanceContext, isRecoveringResilient);
                }
                SubordTableLookupStrategy strategy = this.queryPlan.getLookupStrategyFactory().makeStrategy(tables, instance.getRootViewInstance().getVirtualDataWindow());
                subqueryLookup = new SubordIndexedTableLookupStrategyLocking(strategy, instance.getTailViewInstance().getAgentInstanceContext().getAgentInstanceLock());
            }
        } else {
            Lock lock;
            TableStateInstance state = this.tableService.getState(this.optionalTableMetadata.getTableName(), agentInstanceContext.getAgentInstanceId());
            Lock lock2 = lock = agentInstanceContext.getStatementContext().isWritesToTables() ? state.getTableLevelRWLock().writeLock() : state.getTableLevelRWLock().readLock();
            if (this.queryPlan == null) {
                subqueryLookup = new SubordFullTableScanTableLookupStrategy(lock, state.getIterableTableScan());
            } else {
                EventTable[] indexes = new EventTable[this.queryPlan.getIndexDescs().length];
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i] = state.getIndexRepository().getIndexByDesc(this.queryPlan.getIndexDescs()[i].getIndexMultiKey());
                }
                subqueryLookup = this.queryPlan.getLookupStrategyFactory().makeStrategy(indexes, null);
                subqueryLookup = new SubordIndexedTableLookupTableStrategy(subqueryLookup, lock);
            }
        }
        return new SubSelectStrategyRealization(subqueryLookup, subselectAggregationPreprocessor, aggregationService, Collections.emptyMap(), Collections.emptyMap(), null, null);
    }
}

