/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.mgr.ContextControllerInitTermState;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedState;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.mgr.ContextStatePathValueBinding;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.SerializerUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ContextStateCacheNoSave
implements ContextStateCache {
    public static final ContextStatePathValueBinding DEFAULT_SPI_TEST_BINDING = new MyContextStatePathValueBindingSerializable();

    @Override
    public ContextStatePathValueBinding getBinding(Object bindingInfo) {
        if (bindingInfo instanceof ContextDetailInitiatedTerminated) {
            return new ContextStateCacheNoSaveInitTermBinding();
        }
        if (bindingInfo instanceof ContextDetailPartitioned) {
            return new ContextStateCacheNoSavePartitionBinding();
        }
        return DEFAULT_SPI_TEST_BINDING;
    }

    @Override
    public void updateContextPath(String contextName, ContextStatePathKey key, ContextStatePathValue value) {
    }

    @Override
    public void addContextPath(String contextName, int level, int parentPath, int subPath, Integer optionalContextPartitionId, Object additionalInfo, ContextStatePathValueBinding binding) {
    }

    @Override
    public void removeContextParentPath(String contextName, int level, int parentPath) {
    }

    @Override
    public void removeContextPath(String contextName, int level, int parentPath, int subPath) {
    }

    @Override
    public TreeMap<ContextStatePathKey, ContextStatePathValue> getContextPaths(String contextName) {
        return null;
    }

    @Override
    public void removeContext(String contextName) {
    }

    private static void hydrate(Map<String, Object> state, EventAdapterService eventAdapterService) {
        for (Map.Entry<String, Object> entry : state.entrySet()) {
            if (!(entry.getValue() instanceof EventBeanNameValuePair)) continue;
            EventBeanNameValuePair event = (EventBeanNameValuePair)entry.getValue();
            EventType type = eventAdapterService.getExistsTypeByName(event.getEventTypeName());
            Object underlying = SerializerUtil.byteArrToObject(event.getBytes());
            state.put(entry.getKey(), eventAdapterService.adapterForType(underlying, type));
        }
    }

    private static Map<String, Object> dehydrate(Map<String, Object> state) {
        HashMap<String, Object> serializableProps = new HashMap<String, Object>();
        if (state != null) {
            serializableProps.putAll(state);
            for (Map.Entry<String, Object> entry : state.entrySet()) {
                if (!(entry.getValue() instanceof EventBean)) continue;
                EventBean event = (EventBean)entry.getValue();
                serializableProps.put(entry.getKey(), new EventBeanNameValuePair(event.getEventType().getName(), SerializerUtil.objectToByteArr(event.getUnderlying())));
            }
        }
        return serializableProps;
    }

    private static class EventBeanNameValuePair
    implements Serializable {
        private static final long serialVersionUID = 1385687612285835734L;
        private final String eventTypeName;
        private final byte[] bytes;

        private EventBeanNameValuePair(String eventTypeName, byte[] bytes) {
            this.eventTypeName = eventTypeName;
            this.bytes = bytes;
        }

        public String getEventTypeName() {
            return this.eventTypeName;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    public static class ContextStateCacheNoSaveInitTermBinding
    implements ContextStatePathValueBinding {
        @Override
        public Object byteArrayToObject(byte[] bytes, EventAdapterService eventAdapterService) {
            ContextControllerInitTermState state = (ContextControllerInitTermState)SerializerUtil.byteArrToObject(bytes);
            ContextStateCacheNoSave.hydrate(state.getPatternData(), eventAdapterService);
            return state;
        }

        @Override
        public byte[] toByteArray(Object contextInfo) {
            ContextControllerInitTermState state = (ContextControllerInitTermState)contextInfo;
            Map serializableProps = ContextStateCacheNoSave.dehydrate(state.getPatternData());
            ContextControllerInitTermState serialized = new ContextControllerInitTermState(state.getStartTime(), serializableProps);
            return SerializerUtil.objectToByteArr(serialized);
        }
    }

    public static class ContextStateCacheNoSavePartitionBinding
    implements ContextStatePathValueBinding {
        @Override
        public Object byteArrayToObject(byte[] bytes, EventAdapterService eventAdapterService) {
            ContextControllerPartitionedState state = (ContextControllerPartitionedState)SerializerUtil.byteArrToObject(bytes);
            ContextStateCacheNoSave.hydrate(state.getInitEvents(), eventAdapterService);
            return state;
        }

        @Override
        public byte[] toByteArray(Object contextInfo) {
            if (!(contextInfo instanceof ContextControllerPartitionedState)) {
                Object[] objectArray;
                if (contextInfo instanceof Object[]) {
                    objectArray = (Object[])contextInfo;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = contextInfo;
                }
                contextInfo = new ContextControllerPartitionedState(objectArray, Collections.emptyMap());
            }
            ContextControllerPartitionedState state = (ContextControllerPartitionedState)contextInfo;
            Map serializableProps = ContextStateCacheNoSave.dehydrate(state.getInitEvents());
            ContextControllerPartitionedState serialized = new ContextControllerPartitionedState(state.getPartitionKey(), serializableProps);
            return SerializerUtil.objectToByteArr(serialized);
        }
    }

    public static class MyContextStatePathValueBindingSerializable
    implements ContextStatePathValueBinding {
        @Override
        public Object byteArrayToObject(byte[] bytes, EventAdapterService eventAdapterService) {
            return SerializerUtil.byteArrToObject(bytes);
        }

        @Override
        public byte[] toByteArray(Object contextInfo) {
            return SerializerUtil.objectToByteArr(contextInfo);
        }
    }
}

