/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierPartitioned;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.client.context.ContextPartitionSelectorSegmented;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextControllerConditionFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedEntry;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedFactoryImpl;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedFilterCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedInstanceManageCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedState;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStateUtil;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filter.FilterFaultHandler;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.filterspec.MatchedEventMapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ContextControllerPartitioned
implements ContextController,
ContextControllerPartitionedInstanceManageCallback {
    protected final int pathId;
    protected final ContextControllerLifecycleCallback activationCallback;
    protected final ContextControllerPartitionedFactoryImpl factory;
    protected final List<ContextControllerPartitionedFilterCallback> filterCallbacks = new ArrayList<ContextControllerPartitionedFilterCallback>();
    protected final HashMap<Object, ContextControllerPartitionedEntry> partitionKeys = new HashMap();
    private ContextInternalFilterAddendum activationFilterAddendum;
    protected int currentSubpathId;
    private EventBean lastTerminatingEvent;

    public ContextControllerPartitioned(int pathId, ContextControllerLifecycleCallback activationCallback, ContextControllerPartitionedFactoryImpl factory) {
        this.pathId = pathId;
        this.activationCallback = activationCallback;
        this.factory = factory;
    }

    @Override
    public void importContextPartitions(ContextControllerState state, int pathIdToUse, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector) {
        this.initializeFromState(null, null, filterAddendum, state, pathIdToUse, agentInstanceSelector, true);
    }

    @Override
    public void deletePath(ContextPartitionIdentifier identifier) {
        ContextPartitionIdentifierPartitioned partitioned = (ContextPartitionIdentifierPartitioned)identifier;
        ContextControllerPartitionedEntry entry = this.partitionKeys.remove(this.getKeyObjectForLookup(partitioned.getKeys()));
        if (entry != null && entry.getOptionalTermination() != null) {
            entry.getOptionalTermination().deactivate();
        }
    }

    @Override
    public void visitSelectedPartitions(ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor) {
        int nestingLevel = this.factory.getFactoryContext().getNestingLevel();
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filtered = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            ContextPartitionIdentifierPartitioned identifier = new ContextPartitionIdentifierPartitioned();
            for (Map.Entry<Object, ContextControllerPartitionedEntry> entry : this.partitionKeys.entrySet()) {
                identifier.setContextPartitionId(entry.getValue().getInstanceHandle().getContextPartitionOrPathId());
                Object[] identifierOA = this.getKeyObjectsAccountForMultikey(entry.getKey());
                identifier.setKeys(identifierOA);
                if (!filtered.filter(identifier)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), identifierOA, this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorSegmented) {
            ContextPartitionSelectorSegmented partitioned = (ContextPartitionSelectorSegmented)contextPartitionSelector;
            if (partitioned.getPartitionKeys() == null || partitioned.getPartitionKeys().isEmpty()) {
                return;
            }
            for (Object[] keyObjects : partitioned.getPartitionKeys()) {
                Object key = this.getKeyObjectForLookup(keyObjects);
                ContextControllerPartitionedEntry entry = this.partitionKeys.get(key);
                ContextControllerInstanceHandle instanceHandle = entry == null ? null : entry.getInstanceHandle();
                if (instanceHandle == null || instanceHandle.getContextPartitionOrPathId() == null) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), keyObjects, this, instanceHandle);
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById filtered = (ContextPartitionSelectorById)contextPartitionSelector;
            for (Map.Entry<Object, ContextControllerPartitionedEntry> entry : this.partitionKeys.entrySet()) {
                if (!filtered.getContextPartitionIds().contains(entry.getValue().getInstanceHandle().getContextPartitionOrPathId())) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), new ContextControllerPartitionedState(this.getKeyObjectsAccountForMultikey(entry.getKey()), Collections.emptyMap()), this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            for (Map.Entry<Object, ContextControllerPartitionedEntry> entry : this.partitionKeys.entrySet()) {
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), this.getKeyObjectsAccountForMultikey(entry.getKey()), this, entry.getValue().getInstanceHandle());
            }
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorSegmented.class}, contextPartitionSelector);
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, ContextInternalFilterAddendum filterAddendum, Integer importPathId) {
        this.activationFilterAddendum = filterAddendum;
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        this.activateFilters(factoryContext, optionalTriggeringEvent, filterAddendum);
        if (factoryContext.getNestingLevel() == 1) {
            controllerState = ContextControllerStateUtil.getRecoveryStates(this.factory.getFactoryContext().getStateCache(), factoryContext.getOutermostContextName());
        }
        if (controllerState == null) {
            return;
        }
        int pathIdToUse = importPathId != null ? importPathId : this.pathId;
        this.initializeFromState(optionalTriggeringEvent, optionalTriggeringPattern, filterAddendum, controllerState, pathIdToUse, null, false);
    }

    @Override
    public ContextControllerFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getPathId() {
        return this.pathId;
    }

    @Override
    public synchronized void deactivate() {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        for (ContextControllerPartitionedFilterCallback contextControllerPartitionedFilterCallback : this.filterCallbacks) {
            contextControllerPartitionedFilterCallback.destroy(factoryContext.getServicesContext().getFilterService());
        }
        if (this.factory.getSegmentedSpec().getOptionalTermination() != null) {
            for (Map.Entry entry : this.partitionKeys.entrySet()) {
                ((ContextControllerPartitionedEntry)entry.getValue()).getOptionalTermination().deactivate();
            }
        }
        this.partitionKeys.clear();
        this.filterCallbacks.clear();
        this.factory.getFactoryContext().getStateCache().removeContextParentPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId);
    }

    @Override
    public synchronized void createKey(Object key, EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches, String initConditionAsName) {
        boolean exists = this.partitionKeys.containsKey(key);
        if (exists || theEvent == this.lastTerminatingEvent) {
            return;
        }
        this.lastTerminatingEvent = null;
        ++this.currentSubpathId;
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        Map<String, Object> initEvents = initConditionAsName != null ? Collections.singletonMap(initConditionAsName, theEvent) : Collections.emptyMap();
        Map<String, Object> props = ContextPropertyEventType.getPartitionBean(factoryContext.getContextName(), 0, key, this.factory.getSegmentedSpec().getItems().get(0).getPropertyNames(), initEvents);
        ContextInternalFilterAddendum filterAddendum = this.activationFilterAddendum;
        if (this.factory.hasFiltersSpecsNestedContexts()) {
            filterAddendum = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
            this.factory.populateContextInternalFilterAddendums(filterAddendum, key);
        }
        ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, theEvent, null, key, props, null, filterAddendum, false, ContextPartitionState.STARTED, () -> new ContextPartitionIdentifierPartitioned(this.getKeyObjectsAccountForMultikey(key)));
        ContextControllerCondition terminationCondition = null;
        if (this.factory.getSegmentedSpec().getOptionalTermination() != null) {
            terminationCondition = this.activateTermination(key, props, theEvent, handle, initConditionAsName);
        }
        ContextControllerPartitionedEntry partition = new ContextControllerPartitionedEntry(handle, terminationCondition);
        this.partitionKeys.put(key, partition);
        long filterVersion = factoryContext.getServicesContext().getFilterService().getFiltersVersion();
        this.factory.getFactoryContext().getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filterVersion);
        ContextControllerPartitionedState state = new ContextControllerPartitionedState(this.getKeyObjectsAccountForMultikey(key), initConditionAsName, theEvent);
        this.factory.getFactoryContext().getStateCache().addContextPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId, this.currentSubpathId, handle.getContextPartitionOrPathId(), state, this.factory.getBinding());
    }

    private ContextControllerCondition activateTermination(final Object key, final Map<String, Object> props, EventBean optionalTriggeringEvent, ContextControllerInstanceHandle handle, String initCondAsName) {
        ContextControllerConditionCallback callback = new ContextControllerConditionCallback(){

            @Override
            public void rangeNotification(Map<String, Object> builtinProperties, ContextControllerCondition originEndpoint, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern, ContextInternalFilterAddendum filterAddendum) {
                ContextControllerPartitionedEntry entry = ContextControllerPartitioned.this.partitionKeys.remove(key);
                if (entry == null) {
                    return;
                }
                ContextControllerPartitioned.this.lastTerminatingEvent = optionalTriggeringEvent != null ? optionalTriggeringEvent : optionalTriggeringEventPattern;
                ContextControllerPartitioned.this.activationCallback.contextPartitionTerminate(entry.getInstanceHandle(), props, false, null);
                entry.getOptionalTermination().deactivate();
                ContextControllerPartitioned.this.factory.getFactoryContext().getStateCache().removeContextPath(ContextControllerPartitioned.this.factory.getFactoryContext().getOutermostContextName(), ContextControllerPartitioned.this.factory.getFactoryContext().getNestingLevel(), ContextControllerPartitioned.this.pathId, entry.getInstanceHandle().getSubPathId());
            }
        };
        ContextInternalFilterAddendum terminationAddendum = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
        this.factory.populateContextInternalFilterAddendumsTermination(terminationAddendum, key);
        ContextControllerCondition terminationCondition = ContextControllerConditionFactory.getEndpoint(this.factory.getFactoryContext().getContextName(), this.factory.getFactoryContext().getServicesContext(), this.factory.getFactoryContext().getAgentInstanceContextCreate(), this.factory.getSegmentedSpec().getOptionalTermination(), callback, terminationAddendum, false, this.factory.getFactoryContext().getNestingLevel(), this.pathId, this.currentSubpathId);
        MatchedEventMapImpl priorMatches = null;
        if (initCondAsName != null) {
            Object[] propsMatchedEventMap = new Object[this.factory.getTermConditionMatchEventMap().getTagsPerIndex().length];
            int count = 0;
            for (String name : this.factory.getTermConditionMatchEventMap().getTagsPerIndex()) {
                propsMatchedEventMap[count++] = props.get(name);
            }
            priorMatches = new MatchedEventMapImpl(this.factory.getTermConditionMatchEventMap(), propsMatchedEventMap);
        }
        terminationCondition.activate(optionalTriggeringEvent, priorMatches, 0L, false);
        for (AgentInstance agentInstance : handle.getInstances().getAgentInstances()) {
            agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().setFilterFaultHandler(ContextControllerWTerminationFilterFaultHandler.INSTANCE);
        }
        return terminationCondition;
    }

    private Object[] getKeyObjectsAccountForMultikey(Object key) {
        if (key instanceof MultiKeyUntyped) {
            return ((MultiKeyUntyped)key).getKeys();
        }
        return new Object[]{key};
    }

    private Object getKeyObjectForLookup(Object[] keyObjects) {
        if (keyObjects.length > 1) {
            return new MultiKeyUntyped(keyObjects);
        }
        return keyObjects[0];
    }

    private void initializeFromState(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextInternalFilterAddendum filterAddendum, ContextControllerState controllerState, int pathIdToUse, AgentInstanceSelector agentInstanceSelector, boolean loadingExistingState) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        TreeMap<ContextStatePathKey, ContextStatePathValue> states = controllerState.getStates();
        int maxSubpathId = Integer.MIN_VALUE;
        NavigableMap<ContextStatePathKey, ContextStatePathValue> childContexts = ContextControllerStateUtil.getChildContexts(factoryContext, pathIdToUse, states);
        EventAdapterService eventAdapterService = this.factory.getFactoryContext().getServicesContext().getEventAdapterService();
        for (Map.Entry entry : childContexts.entrySet()) {
            int n;
            ContextControllerPartitionedEntry existingHandle;
            ContextControllerPartitionedState state = (ContextControllerPartitionedState)this.factory.getBinding().byteArrayToObject(((ContextStatePathValue)entry.getValue()).getBlob(), eventAdapterService);
            Object mapKey = this.getKeyObjectForLookup(state.getPartitionKey());
            ContextInternalFilterAddendum myFilterAddendum = this.activationFilterAddendum;
            if (this.factory.hasFiltersSpecsNestedContexts()) {
                filterAddendum = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                this.factory.populateContextInternalFilterAddendums(filterAddendum, mapKey);
            }
            if (controllerState.isImported() && (existingHandle = this.partitionKeys.get(mapKey)) != null) {
                this.activationCallback.contextPartitionNavigate(existingHandle.getInstanceHandle(), this, controllerState, ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), myFilterAddendum, agentInstanceSelector, ((ContextStatePathValue)entry.getValue()).getBlob(), loadingExistingState);
                continue;
            }
            Map<String, Object> props = ContextPropertyEventType.getPartitionBean(factoryContext.getContextName(), 0, mapKey, this.factory.getSegmentedSpec().getItems().get(0).getPropertyNames(), state.getInitEvents());
            if (!controllerState.isImported()) {
                n = ((ContextStatePathKey)entry.getKey()).getSubPath();
            } else {
                n = this.currentSubpathId + 1;
                this.currentSubpathId = this.currentSubpathId;
            }
            int assignedSubpathId = n;
            ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), assignedSubpathId, ((ContextStatePathKey)entry.getKey()).getSubPath(), this, optionalTriggeringEvent, optionalTriggeringPattern, mapKey, props, controllerState, myFilterAddendum, loadingExistingState || factoryContext.isRecoveringResilient(), ((ContextStatePathValue)entry.getValue()).getState(), () -> new ContextPartitionIdentifierPartitioned(this.getKeyObjectsAccountForMultikey(state.getPartitionKey())));
            ContextControllerCondition terminationCondition = null;
            if (this.factory.getSegmentedSpec().getOptionalTermination() != null) {
                Map.Entry<String, Object> initEvent = state.getInitEvents().isEmpty() ? null : state.getInitEvents().entrySet().iterator().next();
                terminationCondition = this.activateTermination(mapKey, props, initEvent == null ? null : (EventBean)initEvent.getValue(), handle, initEvent == null ? null : initEvent.getKey());
            }
            ContextControllerPartitionedEntry partition = new ContextControllerPartitionedEntry(handle, terminationCondition);
            this.partitionKeys.put(mapKey, partition);
            if (((ContextStatePathKey)entry.getKey()).getSubPath() <= maxSubpathId) continue;
            maxSubpathId = assignedSubpathId;
        }
        if (!controllerState.isImported()) {
            this.currentSubpathId = maxSubpathId != Integer.MIN_VALUE ? maxSubpathId : 0;
        }
    }

    private void activateFilters(ContextControllerFactoryContext factoryContext, EventBean optionalTriggeringEvent, ContextInternalFilterAddendum filterAddendum) {
        List<ContextDetailConditionFilter> optionalInit = this.factory.getSegmentedSpec().getOptionalInit();
        if (optionalInit == null || optionalInit.isEmpty()) {
            this.activateFiltersFromPartitionKeys(factoryContext, optionalTriggeringEvent, filterAddendum);
        } else {
            this.activateFiltersFromInit(factoryContext, optionalTriggeringEvent, filterAddendum);
        }
    }

    private void activateFiltersFromPartitionKeys(ContextControllerFactoryContext factoryContext, EventBean optionalTriggeringEvent, ContextInternalFilterAddendum filterAddendum) {
        for (ContextDetailPartitionItem item : this.factory.getSegmentedSpec().getItems()) {
            this.activateFilter(factoryContext, optionalTriggeringEvent, item.getGetters(), item.getFilterSpecCompiled(), filterAddendum, item.getAliasName());
        }
    }

    private void activateFiltersFromInit(ContextControllerFactoryContext factoryContext, EventBean optionalTriggeringEvent, ContextInternalFilterAddendum filterAddendum) {
        List<ContextDetailConditionFilter> inits = this.factory.getSegmentedSpec().getOptionalInit();
        for (ContextDetailConditionFilter init : inits) {
            ContextDetailPartitionItem found = null;
            for (ContextDetailPartitionItem item : this.factory.getSegmentedSpec().getItems()) {
                if (item.getFilterSpecCompiled().getFilterForEventType() != init.getFilterSpecCompiled().getFilterForEventType()) continue;
                found = item;
                break;
            }
            if (found == null) {
                throw new IllegalArgumentException("Failed to find matching partition for type '" + init.getFilterSpecCompiled().getFilterForEventType());
            }
            this.activateFilter(factoryContext, optionalTriggeringEvent, found.getGetters(), init.getFilterSpecCompiled(), filterAddendum, init.getOptionalFilterAsName());
        }
    }

    private void activateFilter(ContextControllerFactoryContext factoryContext, EventBean optionalTriggeringEvent, EventPropertyGetter[] getters, FilterSpecCompiled filterSpecCompiled, ContextInternalFilterAddendum filterAddendum, String optionalInitConditionAsName) {
        boolean match;
        ContextControllerPartitionedFilterCallback callback = new ContextControllerPartitionedFilterCallback(factoryContext.getServicesContext(), factoryContext.getAgentInstanceContextCreate(), getters, filterSpecCompiled, this, filterAddendum, optionalInitConditionAsName);
        this.filterCallbacks.add(callback);
        if (optionalTriggeringEvent != null && (match = StatementAgentInstanceUtil.evaluateFilterForStatement(factoryContext.getServicesContext(), optionalTriggeringEvent, factoryContext.getAgentInstanceContextCreate(), callback.getFilterHandle()))) {
            callback.matchFound(optionalTriggeringEvent, null);
        }
    }

    private static class ContextControllerWTerminationFilterFaultHandler
    implements FilterFaultHandler {
        public static final FilterFaultHandler INSTANCE = new ContextControllerWTerminationFilterFaultHandler();

        private ContextControllerWTerminationFilterFaultHandler() {
        }

        @Override
        public boolean handleFilterFault(EventBean theEvent, long version) {
            return true;
        }
    }
}

