/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierCategory;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorCategory;
import com.espertech.esper.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerCategoryFactoryImpl;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStateUtil;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ContextControllerCategory
implements ContextController {
    private final int pathId;
    private final ContextControllerLifecycleCallback activationCallback;
    private final ContextControllerCategoryFactoryImpl factory;
    private final Map<Integer, ContextControllerInstanceHandle> handleCategories = new LinkedHashMap<Integer, ContextControllerInstanceHandle>();
    private int currentSubpathId;

    public ContextControllerCategory(int pathId, ContextControllerLifecycleCallback activationCallback, ContextControllerCategoryFactoryImpl factory) {
        this.pathId = pathId;
        this.activationCallback = activationCallback;
        this.factory = factory;
    }

    @Override
    public void importContextPartitions(ContextControllerState state, int pathIdToUse, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector) {
        this.initializeFromState(null, null, filterAddendum, state, pathIdToUse, agentInstanceSelector, true);
    }

    @Override
    public void deletePath(ContextPartitionIdentifier identifier) {
        ContextPartitionIdentifierCategory category = (ContextPartitionIdentifierCategory)identifier;
        int count = 0;
        for (ContextDetailCategoryItem cat : this.factory.getCategorySpec().getItems()) {
            if (cat.getName().equals(category.getLabel())) {
                this.handleCategories.remove(count);
                break;
            }
            ++count;
        }
    }

    @Override
    public void visitSelectedPartitions(ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor) {
        int nestingLevel = this.factory.getFactoryContext().getNestingLevel();
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            ContextPartitionIdentifierCategory identifier = new ContextPartitionIdentifierCategory();
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.handleCategories.entrySet()) {
                identifier.setContextPartitionId(entry.getValue().getContextPartitionOrPathId());
                String categoryName = this.factory.getCategorySpec().getItems().get(entry.getKey()).getName();
                identifier.setLabel(categoryName);
                if (!filter.filter(identifier)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorCategory) {
            ContextPartitionSelectorCategory category = (ContextPartitionSelectorCategory)contextPartitionSelector;
            if (category.getLabels() == null || category.getLabels().isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.handleCategories.entrySet()) {
                String categoryName = this.factory.getCategorySpec().getItems().get(entry.getKey()).getName();
                if (!category.getLabels().contains(categoryName)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)contextPartitionSelector;
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.handleCategories.entrySet()) {
                int cpid = entry.getValue().getContextPartitionOrPathId();
                if (!byId.getContextPartitionIds().contains(cpid)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.handleCategories.entrySet()) {
                String categoryName = this.factory.getCategorySpec().getItems().get(entry.getKey()).getName();
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorCategory.class}, contextPartitionSelector);
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, ContextInternalFilterAddendum activationFilterAddendum, Integer importPathId) {
        if (this.factory.getFactoryContext().getNestingLevel() == 1) {
            controllerState = ContextControllerStateUtil.getRecoveryStates(this.factory.getFactoryContext().getStateCache(), this.factory.getFactoryContext().getOutermostContextName());
        }
        if (controllerState == null) {
            int count = 0;
            for (ContextDetailCategoryItem category : this.factory.getCategorySpec().getItems()) {
                Map<String, Object> context = ContextPropertyEventType.getCategorizedBean(this.factory.getFactoryContext().getContextName(), 0, category.getName());
                ++this.currentSubpathId;
                ContextInternalFilterAddendum filterAddendumToUse = activationFilterAddendum;
                if (this.factory.hasFiltersSpecsNestedContexts()) {
                    filterAddendumToUse = activationFilterAddendum != null ? activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                    this.factory.populateContextInternalFilterAddendums(filterAddendumToUse, count);
                }
                ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, optionalTriggeringEvent, optionalTriggeringPattern, count, context, controllerState, filterAddendumToUse, this.factory.getFactoryContext().isRecoveringResilient(), ContextPartitionState.STARTED, () -> new ContextPartitionIdentifierCategory(category.getName()));
                this.handleCategories.put(count, handle);
                this.factory.getFactoryContext().getStateCache().addContextPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId, this.currentSubpathId, handle.getContextPartitionOrPathId(), count, this.factory.getBinding());
                ++count;
            }
            return;
        }
        int pathIdToUse = importPathId != null ? importPathId : this.pathId;
        this.initializeFromState(optionalTriggeringEvent, optionalTriggeringPattern, activationFilterAddendum, controllerState, pathIdToUse, null, false);
    }

    @Override
    public ContextControllerFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getPathId() {
        return this.pathId;
    }

    @Override
    public void deactivate() {
        this.handleCategories.clear();
    }

    private void initializeFromState(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextInternalFilterAddendum activationFilterAddendum, ContextControllerState controllerState, int pathIdToUse, AgentInstanceSelector agentInstanceSelector, boolean loadingExistingState) {
        TreeMap<ContextStatePathKey, ContextStatePathValue> states = controllerState.getStates();
        NavigableMap<ContextStatePathKey, ContextStatePathValue> childContexts = ContextControllerStateUtil.getChildContexts(this.factory.getFactoryContext(), pathIdToUse, states);
        int maxSubpathId = Integer.MIN_VALUE;
        for (Map.Entry entry : childContexts.entrySet()) {
            int n;
            ContextControllerInstanceHandle existingHandle;
            int categoryNumber = (Integer)this.factory.getBinding().byteArrayToObject(((ContextStatePathValue)entry.getValue()).getBlob(), null);
            ContextDetailCategoryItem category = this.factory.getCategorySpec().getItems().get(categoryNumber);
            ContextInternalFilterAddendum filterAddendumToUse = activationFilterAddendum;
            if (this.factory.hasFiltersSpecsNestedContexts()) {
                filterAddendumToUse = activationFilterAddendum != null ? activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                this.factory.populateContextInternalFilterAddendums(filterAddendumToUse, categoryNumber);
            }
            if (controllerState.isImported() && (existingHandle = this.handleCategories.get(categoryNumber)) != null) {
                this.activationCallback.contextPartitionNavigate(existingHandle, this, controllerState, ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), filterAddendumToUse, agentInstanceSelector, ((ContextStatePathValue)entry.getValue()).getBlob(), loadingExistingState);
                continue;
            }
            Map<String, Object> context = ContextPropertyEventType.getCategorizedBean(this.factory.getFactoryContext().getContextName(), 0, category.getName());
            int contextPartitionId = ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId();
            if (!controllerState.isImported()) {
                n = ((ContextStatePathKey)entry.getKey()).getSubPath();
            } else {
                n = this.currentSubpathId + 1;
                this.currentSubpathId = this.currentSubpathId;
            }
            int assignedSubPathId = n;
            ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(contextPartitionId, assignedSubPathId, ((ContextStatePathKey)entry.getKey()).getSubPath(), this, null, null, categoryNumber, context, controllerState, filterAddendumToUse, loadingExistingState || this.factory.getFactoryContext().isRecoveringResilient(), ((ContextStatePathValue)entry.getValue()).getState(), () -> new ContextPartitionIdentifierCategory(category.getName()));
            this.handleCategories.put(categoryNumber, handle);
            if (((ContextStatePathKey)entry.getKey()).getSubPath() <= maxSubpathId) continue;
            maxSubpathId = assignedSubPathId;
        }
        if (!controllerState.isImported()) {
            this.currentSubpathId = maxSubpathId != Integer.MIN_VALUE ? maxSubpathId : 0;
        }
    }
}

