/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import java.io.Serializable;
import java.util.Arrays;

public final class MultiKeyUntyped
implements Serializable {
    private final Object[] keys;
    private final int hashCode;
    private static final long serialVersionUID = -3890626073105861216L;

    public MultiKeyUntyped(Object[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        int total = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            total *= 31;
            total ^= keys[i].hashCode();
        }
        this.hashCode = total;
        this.keys = keys;
    }

    public MultiKeyUntyped(Object key) {
        this(new Object[]{key});
    }

    public MultiKeyUntyped(Object key1, Object key2) {
        this(new Object[]{key1, key2});
    }

    public MultiKeyUntyped(Object key1, Object key2, Object key3) {
        this(new Object[]{key1, key2, key3});
    }

    public MultiKeyUntyped(Object key1, Object key2, Object key3, Object key4) {
        this(new Object[]{key1, key2, key3, key4});
    }

    public final int size() {
        return this.keys.length;
    }

    public final Object get(int index) {
        return this.keys[index];
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKeyUntyped) {
            MultiKeyUntyped otherKeys = (MultiKeyUntyped)other;
            return Arrays.equals(this.keys, otherKeys.keys);
        }
        return false;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "MultiKeyUntyped" + Arrays.asList(this.keys).toString();
    }
}

