/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.util;

import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenClassMethods;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.core.CodegenMethodFootprint;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CodegenStackGenerator {
    public static void recursiveBuildStack(CodegenMethodNode methodNode, String name, CodegenClassMethods methods) {
        if (methodNode.getOptionalSymbolProvider() == null) {
            throw new IllegalArgumentException("Method node does not have symbol provider");
        }
        HashMap<String, Class> currentSymbols = new HashMap<String, Class>();
        methodNode.getOptionalSymbolProvider().provide(currentSymbols);
        if (!(methodNode instanceof CodegenCtor)) {
            CodegenMethodFootprint footprint = new CodegenMethodFootprint(methodNode.getReturnType(), methodNode.getLocalParams(), methodNode.getAdditionalDebugInfo());
            CodegenMethod method = new CodegenMethod(name, footprint, methodNode.getBlock(), true);
            methodNode.setAssignedMethod(method);
            methods.getPublicMethods().add(method);
        }
        for (CodegenMethodNode child : methodNode.getChildren()) {
            CodegenStackGenerator.recursiveAdd(child, currentSymbols, methods.getPrivateMethods());
        }
    }

    private static void recursiveAdd(CodegenMethodNode methodNode, Map<String, Class> currentSymbols, List<CodegenMethod> privateMethods) {
        TreeSet<String> namesPassed = CodegenStackGenerator.getNamesPassed(methodNode);
        methodNode.setDeepParameters(namesPassed);
        ArrayList<CodegenNamedParam> paramset = new ArrayList<CodegenNamedParam>(namesPassed.size() + methodNode.getLocalParams().size());
        for (CodegenNamedParam named : methodNode.getLocalParams()) {
            paramset.add(named);
        }
        if (methodNode.getOptionalSymbolProvider() == null) {
            for (String name : namesPassed) {
                Class symbolType = currentSymbols.get(name);
                if (symbolType == null) {
                    throw new IllegalStateException("Failed to find named parameter '" + name + "' for method from " + methodNode.getAdditionalDebugInfo());
                }
                paramset.add(new CodegenNamedParam(symbolType, name));
            }
        } else {
            currentSymbols = new HashMap<String, Class>();
            methodNode.getOptionalSymbolProvider().provide(currentSymbols);
        }
        String name = "m" + privateMethods.size();
        CodegenMethodFootprint footprint = new CodegenMethodFootprint(methodNode.getReturnType(), paramset, methodNode.getAdditionalDebugInfo());
        CodegenMethod method = new CodegenMethod(name, footprint, methodNode.getBlock(), false);
        methodNode.setAssignedMethod(method);
        privateMethods.add(method);
        for (CodegenMethodNode child : methodNode.getChildren()) {
            CodegenStackGenerator.recursiveAdd(child, currentSymbols, privateMethods);
        }
    }

    private static TreeSet<String> getNamesPassed(CodegenMethodNode node) {
        TreeSet<String> names = new TreeSet<String>();
        CodegenStackGenerator.recursiveGetNamesPassed(node, names);
        return names;
    }

    private static void recursiveGetNamesPassed(CodegenMethodNode node, Set<String> names) {
        if (node.getOptionalSymbolProvider() != null) {
            return;
        }
        for (CodegenExpressionRef ref : node.getEnvironment()) {
            names.add(ref.getRef());
        }
        for (CodegenMethodNode child : node.getChildren()) {
            CodegenStackGenerator.recursiveGetNamesPassed(child, names);
        }
    }
}

