/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.model.statement;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.core.CodegenIndent;
import com.espertech.esper.codegen.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;

public class CodegenStatementSwitch
extends CodegenStatementWBlockBase {
    private final String ref;
    private final int numOptions;
    private final CodegenBlock[] blocks;
    private final boolean blocksReturnValues;

    public CodegenStatementSwitch(CodegenBlock parent, String ref, int numOptions, boolean blocksReturnValues) {
        super(parent);
        this.ref = ref;
        this.numOptions = numOptions;
        this.blocks = new CodegenBlock[numOptions];
        for (int i = 0; i < numOptions; ++i) {
            this.blocks[i] = new CodegenBlock(this);
        }
        this.blocksReturnValues = blocksReturnValues;
    }

    public CodegenBlock[] getBlocks() {
        return this.blocks;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("switch(").append(this.ref).append(") {\n");
        for (int i = 0; i < this.numOptions; ++i) {
            indent.indent(builder, level + 1);
            builder.append("case ").append(i).append(": {\n");
            this.blocks[i].render(builder, imports, isInnerClass, level + 2, indent);
            if (!this.blocksReturnValues) {
                indent.indent(builder, level + 2);
                builder.append("break;\n");
            }
            indent.indent(builder, level + 1);
            builder.append("}\n");
        }
        indent.indent(builder, level + 1);
        builder.append("default: throw new UnsupportedOperationException();\n");
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        for (int i = 0; i < this.numOptions; ++i) {
            this.blocks[i].mergeClasses(classes);
        }
    }
}

