/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.base;

import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenIndent;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionExprDotMethod;
import com.espertech.esper.codegen.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionStaticMethod;
import com.espertech.esper.codegen.model.statement.CodegenStatement;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignArrayElement;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignArrayElement2Dim;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignCompound;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignNamed;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignRef;
import com.espertech.esper.codegen.model.statement.CodegenStatementBreakLoop;
import com.espertech.esper.codegen.model.statement.CodegenStatementCommentFullLine;
import com.espertech.esper.codegen.model.statement.CodegenStatementContinue;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVar;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVarNull;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVarWCast;
import com.espertech.esper.codegen.model.statement.CodegenStatementExpression;
import com.espertech.esper.codegen.model.statement.CodegenStatementFor;
import com.espertech.esper.codegen.model.statement.CodegenStatementForEach;
import com.espertech.esper.codegen.model.statement.CodegenStatementForIntSimple;
import com.espertech.esper.codegen.model.statement.CodegenStatementIf;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfConditionReturnConst;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNotTypeReturnConst;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNullReturnFalse;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNullReturnNull;
import com.espertech.esper.codegen.model.statement.CodegenStatementReturnExpression;
import com.espertech.esper.codegen.model.statement.CodegenStatementReturnNoValue;
import com.espertech.esper.codegen.model.statement.CodegenStatementSwitch;
import com.espertech.esper.codegen.model.statement.CodegenStatementSynchronized;
import com.espertech.esper.codegen.model.statement.CodegenStatementThrow;
import com.espertech.esper.codegen.model.statement.CodegenStatementTryCatch;
import com.espertech.esper.codegen.model.statement.CodegenStatementWBlockBase;
import com.espertech.esper.codegen.model.statement.CodegenStatementWhile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenBlock {
    private final CodegenCtor parentCtor;
    private final CodegenMethodNode parentMethodNode;
    private final CodegenStatementWBlockBase parentWBlock;
    private boolean closed;
    protected List<CodegenStatement> statements = new ArrayList<CodegenStatement>(4);

    private CodegenBlock(CodegenCtor parentCtor, CodegenMethodNode parentMethodNode, CodegenStatementWBlockBase parentWBlock) {
        this.parentCtor = parentCtor;
        this.parentMethodNode = parentMethodNode;
        this.parentWBlock = parentWBlock;
    }

    public CodegenBlock() {
        this(null, null, null);
    }

    public CodegenBlock(CodegenCtor parentCtor) {
        this(parentCtor, null, null);
    }

    public CodegenBlock(CodegenMethodNode parentMethodNode) {
        this(null, parentMethodNode, null);
    }

    public CodegenBlock(CodegenStatementWBlockBase parentWBlock) {
        this(null, null, parentWBlock);
    }

    public CodegenBlock expression(CodegenExpression expression) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(expression));
        return this;
    }

    public CodegenBlock decrement(CodegenExpressionRef expression) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(CodegenExpressionBuilder.decrement(expression)));
        return this;
    }

    public CodegenBlock decrement(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(CodegenExpressionBuilder.decrement(ref)));
        return this;
    }

    public CodegenBlock increment(CodegenExpressionRef expression) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(CodegenExpressionBuilder.increment(expression)));
        return this;
    }

    public CodegenBlock increment(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(CodegenExpressionBuilder.increment(ref)));
        return this;
    }

    public CodegenBlock ifConditionReturnConst(CodegenExpression condition, Object constant) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfConditionReturnConst(condition, constant));
        return this;
    }

    public CodegenBlock ifNotInstanceOf(String name, Class clazz) {
        return this.ifInstanceOf(name, clazz, true);
    }

    public CodegenBlock ifInstanceOf(String name, Class clazz) {
        return this.ifInstanceOf(name, clazz, false);
    }

    private CodegenBlock ifInstanceOf(String name, Class clazz, boolean not) {
        return this.ifCondition(!not ? CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref(name), clazz) : CodegenExpressionBuilder.notInstanceOf(CodegenExpressionBuilder.ref(name), clazz));
    }

    public CodegenBlock ifRefNull(String ref) {
        return this.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(ref)));
    }

    public CodegenBlock ifRefNull(CodegenExpressionRef ref) {
        return this.ifCondition(CodegenExpressionBuilder.equalsNull(ref));
    }

    public CodegenBlock ifRefNotNull(String ref) {
        return this.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(ref)));
    }

    public CodegenBlock ifCondition(CodegenExpression condition) {
        this.checkClosed();
        CodegenStatementIf builder = new CodegenStatementIf(this);
        this.statements.add(builder);
        return builder.ifBlock(condition);
    }

    public CodegenBlock synchronizedOn(CodegenExpression expression) {
        this.checkClosed();
        CodegenStatementSynchronized builder = new CodegenStatementSynchronized(this, expression);
        this.statements.add(builder);
        return builder.makeBlock();
    }

    public CodegenBlock forLoopIntSimple(String name, CodegenExpression upperLimit) {
        this.checkClosed();
        CodegenStatementForIntSimple forStmt = new CodegenStatementForIntSimple(this, name, upperLimit);
        CodegenBlock block = new CodegenBlock(forStmt);
        forStmt.setBlock(block);
        this.statements.add(forStmt);
        return block;
    }

    public CodegenBlock forLoop(Class type, String name, CodegenExpression initialization, CodegenExpression termination, CodegenExpression increment) {
        this.checkClosed();
        CodegenStatementFor forStmt = new CodegenStatementFor(this, type, name, initialization, termination, increment);
        CodegenBlock block = new CodegenBlock(forStmt);
        forStmt.setBlock(block);
        this.statements.add(forStmt);
        return block;
    }

    public CodegenBlock forEach(Class type, String name, CodegenExpression target) {
        this.checkClosed();
        CodegenStatementForEach forStmt = new CodegenStatementForEach(this, type, name, target);
        CodegenBlock block = new CodegenBlock(forStmt);
        forStmt.setBlock(block);
        this.statements.add(forStmt);
        return block;
    }

    public CodegenBlock tryCatch() {
        this.checkClosed();
        CodegenStatementTryCatch tryCatch = new CodegenStatementTryCatch(this);
        CodegenBlock block = new CodegenBlock(tryCatch);
        tryCatch.setTry(block);
        this.statements.add(tryCatch);
        return block;
    }

    public CodegenBlock declareVarWCast(Class clazz, String var, String rhsName) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVarWCast(clazz, var, rhsName));
        return this;
    }

    public CodegenBlock declareVar(Class clazz, String var, CodegenExpression initializer) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVar(clazz, null, var, initializer));
        return this;
    }

    public CodegenBlock declareVar(String typeName, String var, CodegenExpression initializer) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVar(typeName, null, var, initializer));
        return this;
    }

    public CodegenBlock declareVar(Class clazz, Class optionalTypeVariable, String var, CodegenExpression initializer) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVar(clazz, optionalTypeVariable, var, initializer));
        return this;
    }

    public CodegenBlock declareVarNoInit(Class clazz, String var) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVar(clazz, null, var, null));
        return this;
    }

    public CodegenBlock declareVarNull(Class clazz, String var) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVarNull(clazz, var));
        return this;
    }

    public CodegenBlock assignRef(String ref, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignNamed(ref, assignment));
        return this;
    }

    public CodegenBlock assignRef(CodegenExpressionRef ref, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignRef(ref, assignment));
        return this;
    }

    public CodegenBlock breakLoop() {
        this.checkClosed();
        this.statements.add(CodegenStatementBreakLoop.INSTANCE);
        return this;
    }

    public CodegenBlock assignArrayElement(String ref, CodegenExpression index, CodegenExpression assignment) {
        return this.assignArrayElement(CodegenExpressionBuilder.ref(ref), index, assignment);
    }

    public CodegenBlock assignArrayElement2Dim(String ref, CodegenExpression indexOne, CodegenExpression indexTwo, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignArrayElement2Dim(CodegenExpressionBuilder.ref(ref), indexOne, indexTwo, assignment));
        return this;
    }

    public CodegenBlock assignArrayElement(CodegenExpression ref, CodegenExpression index, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignArrayElement(ref, index, assignment));
        return this;
    }

    public CodegenBlock exprDotMethod(CodegenExpression expression, String method, CodegenExpression ... params) {
        this.expression(new CodegenExpressionExprDotMethod(expression, method, params));
        return this;
    }

    public CodegenBlock staticMethod(Class clazz, String method, CodegenExpression ... params) {
        this.expression(new CodegenExpressionStaticMethod(clazz, method, params));
        return this;
    }

    public CodegenBlock localMethod(CodegenMethodNode methodNode, CodegenExpression ... parameters) {
        this.expression(new CodegenExpressionLocalMethod(methodNode, Arrays.asList(parameters)));
        return this;
    }

    public CodegenBlock ifRefNullReturnFalse(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNullReturnFalse(ref));
        return this;
    }

    public CodegenBlock ifRefNotTypeReturnConst(String ref, Class type, Object constant) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNotTypeReturnConst(ref, type, constant));
        return this;
    }

    public CodegenBlock ifRefNullReturnNull(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNullReturnNull(CodegenExpressionBuilder.ref(ref)));
        return this;
    }

    public CodegenBlock ifRefNullReturnNull(CodegenExpressionRef ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNullReturnNull(ref));
        return this;
    }

    public CodegenBlock blockReturn(CodegenExpression expression) {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementReturnExpression(expression));
        return this.parentWBlock.getParent();
    }

    public CodegenBlock blockReturnNoValue() {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(CodegenStatementReturnNoValue.INSTANCE);
        return this.parentWBlock.getParent();
    }

    public CodegenStatementTryCatch tryReturn(CodegenExpression expression) {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        if (!(this.parentWBlock instanceof CodegenStatementTryCatch)) {
            throw new IllegalStateException("Codeblock parent is not try-catch");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementReturnExpression(expression));
        return (CodegenStatementTryCatch)this.parentWBlock;
    }

    public CodegenStatementTryCatch tryEnd() {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        if (!(this.parentWBlock instanceof CodegenStatementTryCatch)) {
            throw new IllegalStateException("Codeblock parent is not try-catch");
        }
        this.closed = true;
        return (CodegenStatementTryCatch)this.parentWBlock;
    }

    public CodegenBlock blockThrow(CodegenExpression expression) {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementThrow(expression));
        return this.parentWBlock.getParent();
    }

    public CodegenBlock blockEnd() {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        return this.parentWBlock.getParent();
    }

    public CodegenMethodNode methodThrowUnsupported() {
        if (this.parentMethodNode == null) {
            throw new IllegalStateException("No method parent, use 'blockReturn...' instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementThrow(CodegenExpressionBuilder.newInstance(UnsupportedOperationException.class, new CodegenExpression[0])));
        return this.parentMethodNode;
    }

    public CodegenMethodNode methodThrow(CodegenExpression expression) {
        if (this.parentMethodNode == null) {
            throw new IllegalStateException("No method parent, use 'blockReturn...' instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementThrow(expression));
        return this.parentMethodNode;
    }

    public CodegenMethodNode methodReturn(CodegenExpression expression) {
        if (this.parentMethodNode == null) {
            throw new IllegalStateException("No method parent, use 'blockReturn...' instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementReturnExpression(expression));
        return this.parentMethodNode;
    }

    public CodegenMethodNode methodEnd() {
        if (this.parentMethodNode == null) {
            throw new IllegalStateException("No method node parent, use 'blockReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        return this.parentMethodNode;
    }

    public void ctorEnd() {
        if (this.parentCtor == null) {
            throw new IllegalStateException("No ctor node parent");
        }
        this.checkClosed();
        this.closed = true;
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        for (CodegenStatement statement : this.statements) {
            indent.indent(builder, level);
            statement.render(builder, imports, isInnerClass, level, indent);
        }
    }

    public void mergeClasses(Set<Class> classes) {
        for (CodegenStatement statement : this.statements) {
            statement.mergeClasses(classes);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Code block already closed");
        }
    }

    public CodegenBlock ifElseIf(CodegenExpression condition) {
        this.checkClosed();
        this.closed = true;
        if (this.parentMethodNode != null) {
            throw new IllegalStateException("If-block-end in method?");
        }
        if (!(this.parentWBlock instanceof CodegenStatementIf)) {
            throw new IllegalStateException("If-block-end in method?");
        }
        CodegenStatementIf ifBuilder = (CodegenStatementIf)this.parentWBlock;
        return ifBuilder.addElseIf(condition);
    }

    public CodegenBlock ifElse() {
        this.closed = true;
        if (this.parentMethodNode != null) {
            throw new IllegalStateException("If-block-end in method?");
        }
        if (!(this.parentWBlock instanceof CodegenStatementIf)) {
            throw new IllegalStateException("If-block-end in method?");
        }
        CodegenStatementIf ifBuilder = (CodegenStatementIf)this.parentWBlock;
        return ifBuilder.addElse();
    }

    public void ifReturn(CodegenExpression result) {
        this.checkClosed();
        this.closed = true;
        if (this.parentMethodNode != null) {
            throw new IllegalStateException("If-block-end in method?");
        }
        if (!(this.parentWBlock instanceof CodegenStatementIf)) {
            throw new IllegalStateException("If-block-end in method?");
        }
        this.statements.add(new CodegenStatementReturnExpression(result));
    }

    public CodegenBlock blockContinue() {
        this.checkClosed();
        this.closed = true;
        if (this.parentMethodNode != null) {
            throw new IllegalStateException("If-block-end in method?");
        }
        this.statements.add(CodegenStatementContinue.INSTANCE);
        return this.parentWBlock.getParent();
    }

    public CodegenBlock whileLoop(CodegenExpression expression) {
        this.checkClosed();
        CodegenStatementWhile whileStmt = new CodegenStatementWhile(this, expression);
        CodegenBlock block = new CodegenBlock(whileStmt);
        whileStmt.setBlock(block);
        this.statements.add(whileStmt);
        return block;
    }

    public void returnMethodOrBlock(CodegenExpression expression) {
        if (this.parentMethodNode != null) {
            this.methodReturn(expression);
        } else {
            this.blockReturn(expression);
        }
    }

    public CodegenBlock[] switchBlockOfLength(String ref, int length, boolean withDefaultUnsupported) {
        this.checkClosed();
        CodegenStatementSwitch switchStmt = new CodegenStatementSwitch(this, ref, length, withDefaultUnsupported);
        this.statements.add(switchStmt);
        return switchStmt.getBlocks();
    }

    public CodegenBlock apply(Consumer<CodegenBlock> consumer) {
        this.checkClosed();
        consumer.accept(this);
        return this;
    }

    public CodegenBlock applyConditional(boolean flag, Consumer<CodegenBlock> consumer) {
        if (flag) {
            this.apply(consumer);
        }
        return this;
    }

    public CodegenBlock assignCompound(CodegenExpressionRef expressionRef, String operator, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignCompound(expressionRef, operator, assignment));
        return this;
    }

    public CodegenBlock assignCompound(String ref, String operator, CodegenExpression assignment) {
        return this.assignCompound(CodegenExpressionBuilder.ref(ref), operator, assignment);
    }

    public CodegenBlock commentFullLine(String comment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementCommentFullLine(comment));
        return this;
    }
}

