/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class NamedParameterExpression
extends ExpressionBase {
    private static final long serialVersionUID = 3556889255505413412L;
    private String name;

    public NamedParameterExpression() {
    }

    public NamedParameterExpression(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.name);
        writer.write(58);
        if (this.getChildren().size() > 1 || this.getChildren().isEmpty()) {
            writer.write(40);
        }
        String delimiter = "";
        for (Expression expr : this.getChildren()) {
            writer.write(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        if (this.getChildren().size() > 1 || this.getChildren().isEmpty()) {
            writer.write(41);
        }
    }
}

