/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class ExpressionBase
implements Expression {
    private static final long serialVersionUID = 0L;
    private String treeObjectName;
    private List<Expression> children = new ArrayList<Expression>();

    @Override
    public String getTreeObjectName() {
        return this.treeObjectName;
    }

    @Override
    public void setTreeObjectName(String treeObjectName) {
        this.treeObjectName = treeObjectName;
    }

    @Override
    public List<Expression> getChildren() {
        return this.children;
    }

    public void addChild(Expression expression) {
        this.children.add(expression);
    }

    @Override
    public void setChildren(List<Expression> children) {
        this.children = children;
    }

    @Override
    public final void toEPL(StringWriter writer, ExpressionPrecedenceEnum parentPrecedence) {
        if (this.getPrecedence().getLevel() < parentPrecedence.getLevel()) {
            writer.write("(");
            this.toPrecedenceFreeEPL(writer);
            writer.write(")");
        } else {
            this.toPrecedenceFreeEPL(writer);
        }
    }

    protected static void toPrecedenceFreeEPL(String functionName, List<Expression> children, StringWriter writer) {
        writer.write(functionName);
        writer.write("(");
        ExpressionBase.toPrecedenceFreeEPL(children, writer);
        writer.write(41);
    }

    public static void toPrecedenceFreeEPL(List<Expression> children, StringWriter writer) {
        String delimiter = "";
        for (Expression expr : children) {
            writer.write(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
    }

    protected static void renderAggregation(StringWriter writer, String name, boolean distinct, List<Expression> children) {
        writer.write(name);
        writer.write("(");
        if (distinct) {
            writer.write("distinct ");
        }
        String delimiter = "";
        for (Expression param : children) {
            writer.write(delimiter);
            delimiter = ",";
            param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(")");
    }

    public abstract void toPrecedenceFreeEPL(StringWriter var1);
}

