/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.core.service.EPServiceProviderImpl;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class EPServiceProviderManager {
    private static Map<String, EPServiceProviderSPI> runtimes = new ConcurrentHashMap<String, EPServiceProviderSPI>();

    public static EPServiceProvider getDefaultProvider() {
        return EPServiceProviderManager.getProvider("default", new Configuration());
    }

    public static EPServiceProvider getDefaultProvider(Configuration configuration) throws ConfigurationException {
        return EPServiceProviderManager.getProvider("default", configuration);
    }

    public static EPServiceProvider getProvider(String providerURI) {
        return EPServiceProviderManager.getProvider(providerURI, new Configuration());
    }

    public static EPServiceProvider getProvider(String providerURI, Configuration configuration) throws ConfigurationException {
        String providerURINonNull;
        String string = providerURINonNull = providerURI == null ? "default" : providerURI;
        if (runtimes.containsKey(providerURINonNull)) {
            EPServiceProviderSPI provider = runtimes.get(providerURINonNull);
            if (provider.isDestroyed()) {
                provider = EPServiceProviderManager.getProviderInternal(configuration, providerURINonNull);
                runtimes.put(providerURINonNull, provider);
            } else {
                provider.setConfiguration(configuration);
            }
            return provider;
        }
        EPServiceProviderSPI runtime = EPServiceProviderManager.getProviderInternal(configuration, providerURINonNull);
        runtimes.put(providerURINonNull, runtime);
        runtime.postInitialize();
        return runtime;
    }

    public static EPServiceProvider getExistingProvider(String providerURI) {
        String providerURINonNull = providerURI == null ? "default" : providerURI;
        EPServiceProviderSPI provider = runtimes.get(providerURINonNull);
        if (provider == null || provider.isDestroyed()) {
            return null;
        }
        return provider;
    }

    public static String[] getProviderURIs() {
        Set<String> uriSet = runtimes.keySet();
        return uriSet.toArray(new String[uriSet.size()]);
    }

    private static EPServiceProviderSPI getProviderInternal(Configuration configuration, String providerURINonNull) {
        return new EPServiceProviderImpl(configuration, providerURINonNull, runtimes);
    }
}

