/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

public class BigDecimalBenchmark {
    @Benchmark
    public byte[] write(MyState state) {
        state.output.reset();
        state.serializer.write(null, state.output, (Object)state.decimal);
        return state.output.getBuffer();
    }

    @Benchmark
    public BigDecimal read(MyState state) {
        state.input.reset();
        return (BigDecimal)state.serializer.read(null, state.input, BigDecimal.class);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + BigDecimalBenchmark.class.getSimpleName() + ".*").timeUnit(TimeUnit.MICROSECONDS).warmupIterations(1).warmupTime(TimeValue.seconds((long)1L)).measurementIterations(4).measurementTime(TimeValue.seconds((long)1L)).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class MyState {
        final Serializer<BigDecimal> serializer = new DefaultSerializers.BigDecimalSerializer();
        Output output;
        Input input;
        @Param(value={"null", "zero", "one", "0", "2", "10", "max_in_long", "20", "-2", "-10", "min_in_long", "-20"})
        String numOfDigits = "5";
        int scale = 2;
        BigDecimal decimal;

        @Setup(value=Level.Iteration)
        public void setUp() {
            this.decimal = MyState.newDecimal(this.numOfDigits, this.scale);
            this.output = new Output(2, -1);
            this.serializer.write(null, this.output, (Object)this.decimal);
            this.input = new Input(this.output.toBytes());
            this.output.reset();
        }

        private static BigDecimal newDecimal(String numOfDigits, int scale) {
            switch (numOfDigits) {
                case "null": {
                    return null;
                }
                case "zero": {
                    return BigDecimal.ZERO;
                }
                case "one": {
                    return BigDecimal.ONE;
                }
                case "0": {
                    return BigDecimal.valueOf(0L, scale);
                }
                case "max_in_long": {
                    return BigDecimal.valueOf(Long.MAX_VALUE, scale);
                }
                case "min_in_long": {
                    return BigDecimal.valueOf(Long.MIN_VALUE, scale);
                }
            }
            int digits = Integer.parseInt(numOfDigits.replace("-", ""));
            BigDecimal d = BigDecimal.valueOf(10L, 1 - digits).subtract(BigDecimal.ONE).scaleByPowerOfTen(-scale);
            return numOfDigits.charAt(0) != '-' ? d : d.negate();
        }

        @TearDown(value=Level.Iteration)
        public void tearDown() {
            this.output.close();
            this.input.close();
        }
    }
}

