/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@State(value=Scope.Benchmark)
public class ConcurrencyBenchmark {
    @Benchmark
    public void single(SingleThreadState state, Blackhole blackhole) {
        String data = UUID.randomUUID().toString();
        Object result = state.roundTrip(data);
        blackhole.consume(result);
    }

    @Benchmark
    public void threadLocal(ThreadLocalState state, Blackhole blackhole) {
        String data = UUID.randomUUID().toString();
        Object result = state.roundTrip(data);
        blackhole.consume(result);
    }

    @Benchmark
    public void pool(PoolState state, Blackhole blackhole) {
        String data = UUID.randomUUID().toString();
        Object result = state.roundTrip(data);
        blackhole.consume(result);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + ConcurrencyBenchmark.class.getSimpleName() + ".*").warmupIterations(3).warmupTime(TimeValue.seconds((long)3L)).measurementIterations(3).measurementTime(TimeValue.seconds((long)3L)).threads(2).forks(1).build();
        new Runner(opt).run();
    }

    public static abstract class AbstractConcurrencyState {
        public abstract Object roundTrip(Object var1);

        byte[] serialize(Kryo kryo, Output output, Object data) {
            try {
                byte[] byArray;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    output.setOutputStream((OutputStream)stream);
                    kryo.writeClassAndObject(output, data);
                    output.flush();
                    byArray = stream.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
                return byArray;
            }
            finally {
                output.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object deserialize(Kryo kryo, Input input, byte[] data) {
            try {
                input.setBuffer(data);
                Object object = kryo.readClassAndObject(input);
                return object;
            }
            finally {
                input.reset();
            }
        }

        static Kryo createKryo() {
            Kryo kryo = new Kryo();
            kryo.register(ArrayList.class);
            return kryo;
        }

        static Output createOutput() {
            return new Output(4096, -1);
        }

        static Input createInput() {
            return new Input(4096);
        }
    }

    @State(value=Scope.Benchmark)
    public static class PoolState
    extends AbstractConcurrencyState {
        static final int CAPACITY = 8;
        static final Pool<Kryo> kryoPool = new Pool<Kryo>(true, false, 8){

            protected Kryo create() {
                return AbstractConcurrencyState.createKryo();
            }
        };
        static final Pool<Output> outputPool = new Pool<Output>(true, false, 8){

            protected Output create() {
                return AbstractConcurrencyState.createOutput();
            }
        };
        static final Pool<Input> inputPool = new Pool<Input>(true, false, 8){

            protected Input create() {
                return AbstractConcurrencyState.createInput();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object roundTrip(Object data) {
            Kryo k = (Kryo)kryoPool.obtain();
            Output out = (Output)outputPool.obtain();
            Input in = (Input)inputPool.obtain();
            try {
                byte[] result = this.serialize(k, out, data);
                outputPool.free((Object)out);
                Object object = this.deserialize(k, in, result);
                return object;
            }
            finally {
                kryoPool.free((Object)k);
                inputPool.free((Object)in);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class ThreadLocalState
    extends AbstractConcurrencyState {
        static final ThreadLocal<Kryo> kryo = ThreadLocal.withInitial(AbstractConcurrencyState::createKryo);
        static final ThreadLocal<Output> output = ThreadLocal.withInitial(AbstractConcurrencyState::createOutput);
        static final ThreadLocal<Input> input = ThreadLocal.withInitial(AbstractConcurrencyState::createInput);

        @Override
        public Object roundTrip(Object data) {
            Kryo k = kryo.get();
            Output out = output.get();
            Input in = input.get();
            byte[] result = this.serialize(k, out, data);
            return this.deserialize(k, in, result);
        }
    }

    @State(value=Scope.Benchmark)
    public static class SingleThreadState
    extends AbstractConcurrencyState {
        final Kryo kryo = SingleThreadState.createKryo();
        final Output output = SingleThreadState.createOutput();
        final Input input = SingleThreadState.createInput();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object roundTrip(Object data) {
            Kryo kryo = this.kryo;
            synchronized (kryo) {
                byte[] result = this.serialize(this.kryo, this.output, data);
                return this.deserialize(this.kryo, this.input, result);
            }
        }
    }
}

