/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils;

import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.SecurityUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With")) || "XMLHttpRequest".equalsIgnoreCase(request.getParameter("X-Requested-With"));
    }

    public static void setStateParam(String name, String value, HttpServletRequest req, HttpServletResponse res) {
        HttpUtils.setStateParam(name, value, req, res, false);
    }

    public static void setStateParam(String name, String value, HttpServletRequest req, HttpServletResponse res, boolean httpOnly) {
        HttpUtils.setRawCookie(name, value, req, res, httpOnly, -1);
    }

    public static String getStateParam(String name, HttpServletRequest req) {
        return HttpUtils.getCookieValue(req, name);
    }

    public static void removeStateParam(String name, HttpServletRequest req, HttpServletResponse res) {
        HttpUtils.setRawCookie(name, "", req, res, false, 0);
    }

    public static void setRawCookie(String name, String value, HttpServletRequest req, HttpServletResponse res, boolean httpOnly, int maxAge) {
        if (StringUtils.isBlank((CharSequence)name) || value == null || req == null || res == null) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(httpOnly);
        cookie.setMaxAge(maxAge < 0 ? Para.getConfig().sessionTimeoutSec() : maxAge);
        cookie.setPath("/");
        cookie.setSecure(req.isSecure());
        res.addCookie(cookie);
    }

    public static String getCookieValue(HttpServletRequest req, String name) {
        if (StringUtils.isBlank((CharSequence)name) || req == null) {
            return null;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void setAuthCookie(String name, String value, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        HttpUtils.setAuthCookie(name, value, true, maxAge, "Lax", request, response);
    }

    public static void setAuthCookie(String name, String value, boolean httpOnly, int maxAge, String sameSite, HttpServletRequest request, HttpServletResponse response) {
        String expires = DateFormatUtils.format((long)(System.currentTimeMillis() + (long)(maxAge * 1000)), (String)"EEE, dd-MMM-yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"));
        String contextPath = request.getContextPath();
        String path = contextPath.length() > 0 ? contextPath : "/";
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("=").append(value).append(";");
        sb.append("Path=").append(path).append(";");
        sb.append("Expires=").append(expires).append(";");
        sb.append("Max-Age=").append(maxAge).append(";");
        if (httpOnly) {
            sb.append("HttpOnly;");
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)SecurityUtils.getRedirectUrl(request), (CharSequence)"https://") || request.isSecure()) {
            sb.append("Secure;");
        }
        if (!StringUtils.isBlank((CharSequence)sameSite)) {
            sb.append("SameSite=").append(sameSite);
        }
        response.addHeader("Set-Cookie", sb.toString());
    }
}

