/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.storage;

import com.erudika.para.core.storage.FileStore;
import com.erudika.para.core.utils.Para;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileStore
implements FileStore {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileStore.class);
    private String folder;

    public LocalFileStore() {
        this(Para.getConfig().localFileStoreFolder());
    }

    public LocalFileStore(String folder) {
        this.folder = StringUtils.endsWith((CharSequence)folder, (CharSequence)File.separator) ? folder : folder.concat(File.separator);
    }

    public InputStream load(String path) {
        block9: {
            if (StringUtils.startsWith((CharSequence)path, (CharSequence)File.separator)) {
                path = path.substring(1);
            }
            if (!StringUtils.isBlank((CharSequence)path)) {
                ByteArrayInputStream byteArrayInputStream;
                File f = new File(this.folder + path);
                if (!f.exists() || !f.canRead()) break block9;
                FileInputStream fin = new FileInputStream(f);
                try {
                    byte[] buf = new byte[(int)f.length()];
                    IOUtils.readFully((InputStream)fin, (byte[])buf);
                    byteArrayInputStream = new ByteArrayInputStream(buf);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)fin).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        logger.debug(null, (Throwable)ex);
                    }
                }
                ((InputStream)fin).close();
                return byteArrayInputStream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String store(String path, InputStream data) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)File.separator)) {
            path = path.substring(1);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        int maxFileSizeMBytes = Para.getConfig().localFileStoreMaxFileSizeMb();
        try {
            File f = new File(this.folder + path);
            if (!f.exists() || f.canWrite()) {
                String string;
                long bytesWritten = 0L;
                try (FileOutputStream fos = new FileOutputStream(f);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = data.read(bytes)) != -1) {
                        bos.write(bytes, 0, read);
                        if ((bytesWritten += (long)read) <= (long)(maxFileSizeMBytes * 1024 * 1024)) continue;
                        break;
                    }
                }
                if (bytesWritten > (long)(maxFileSizeMBytes * 1024 * 1024)) {
                    logger.warn("Failed to store file on disk because it's too large - {}, {} bytes", (Object)path, (Object)bytesWritten);
                    f.delete();
                    string = null;
                    return string;
                }
                string = f.getAbsolutePath();
                return string;
            }
            logger.warn("Failed to write file {} to disk - no permissions.", (Object)(this.folder + path));
        }
        catch (FileNotFoundException ex) {
            logger.error("File {} not found.", (Object)(this.folder + path));
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                logger.error(null, (Throwable)e);
            }
        }
        return null;
    }

    public boolean delete(String path) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)File.separator)) {
            path = path.substring(1);
        }
        if (!StringUtils.isBlank((CharSequence)path)) {
            File f = new File(this.folder + path);
            return f.canWrite() && f.delete();
        }
        return false;
    }
}

