/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.filters.SAMLAuthFilter;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class SAMLMetadataFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLMetadataFilter.class);
    public static final String SAML_ACTION = "/saml_metadata";

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestURI = request.getServletPath();
        if (requestURI.startsWith(SAML_ACTION)) {
            String appid = Para.getConfig().getRootAppIdentifier();
            if (requestURI.startsWith("/saml_metadata/")) {
                String id = Utils.urlDecode((String)StringUtils.removeStart((String)requestURI, (String)"/saml_metadata/"));
                appid = !id.isEmpty() ? id : Para.getConfig().getRootAppIdentifier();
            }
            try {
                App app = (App)Para.getDAO().read(App.id((String)appid));
                if (app != null && app.getSetting("security.saml.sp.entityid") != null) {
                    SettingsBuilder builder = new SettingsBuilder();
                    Saml2Settings settings = builder.fromValues(SAMLAuthFilter.getSAMLSettings(app)).build();
                    settings.setSPValidationOnly(true);
                    String metadata = settings.getSPMetadata();
                    List errors = Saml2Settings.validateMetadata((String)metadata);
                    if (errors.isEmpty()) {
                        response.setContentType("text/xml");
                        response.setCharacterEncoding(Para.getConfig().defaultEncoding());
                        response.getOutputStream().println(metadata);
                        response.setStatus(200);
                        return;
                    }
                    response.sendError(400, StringUtils.join((Iterable)errors, (String)"; "));
                    response.setStatus(400);
                    return;
                }
            }
            catch (SettingsException ex) {
                LOG.error("Invalid SAML settings for app {}:", (Object)appid, (Object)ex);
            }
            catch (Exception ex) {
                LOG.error(null, (Throwable)ex);
            }
            response.sendError(400);
            response.setStatus(400);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

