/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.onelogin.saml2.Auth;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class SAMLAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLAuthFilter.class);
    public static final String SAML_ACTION = "/saml_auth";

    public SAMLAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication attemptAuthentication(HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) throws IOException {
        UserAuthentication userAuth;
        block18: {
            String requestURI = request.getServletPath();
            userAuth = null;
            if (requestURI.startsWith(SAML_ACTION)) {
                String appid = Para.getConfig().getRootAppIdentifier();
                if (requestURI.startsWith("/saml_auth/")) {
                    String id = Utils.urlDecode((String)StringUtils.removeStart((String)requestURI, (String)"/saml_auth/"));
                    appid = !id.isEmpty() ? id : Para.getConfig().getRootAppIdentifier();
                }
                boolean samlSettingsLoaded = false;
                try {
                    Map samlSettings;
                    App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
                    if (app == null) break block18;
                    SettingsBuilder builder = new SettingsBuilder();
                    String idpMetaUrl = Para.getConfig().getSettingForApp(app, "security.saml.idp.metadata_url", "");
                    if (StringUtils.isBlank((CharSequence)idpMetaUrl)) {
                        samlSettings = SAMLAuthFilter.getSAMLSettings(app);
                    } else {
                        samlSettings = IdPMetadataParser.parseRemoteXML((URL)new URI(idpMetaUrl).toURL(), (String)request.getParameter("entityid"));
                        samlSettings.putAll(SAMLAuthFilter.getSAMLSettings(app));
                    }
                    Saml2Settings settings = builder.fromValues(samlSettings).build();
                    Auth auth = new Auth(settings, (javax.servlet.http.HttpServletRequest)new HttpServletRequestWrapper(request), (HttpServletResponse)new HttpServletResponseWrapper(response));
                    samlSettingsLoaded = true;
                    if (request.getParameter("SAMLResponse") != null) {
                        auth.processResponse();
                        if (!auth.isAuthenticated()) break block18;
                        List errors = auth.getErrors();
                        if (errors.isEmpty()) {
                            userAuth = this.getOrCreateUser(app, auth.getAttributes());
                            break block18;
                        }
                        throw new AuthenticationServiceException(StringUtils.join((Iterable)errors, (String)"; "));
                    }
                    auth.login(settings.getSpAssertionConsumerServiceUrl().toString());
                    Authentication authentication = null;
                    return authentication;
                }
                catch (SettingsException ex) {
                    LOG.error("Failed to authenticate app '{}' with SAML: {}", (Object)appid, (Object)ex.getMessage());
                }
                catch (IOException ex) {
                    LOG.error("Failed to load certificate from properties for app '{}': {}", (Object)appid, (Object)ex.getMessage());
                }
                catch (InvalidKeySpecException ex) {
                    LOG.error("Invalid SAML certificate key for app '{}': {}", (Object)appid, (Object)ex.getMessage());
                }
                catch (Exception ex) {
                    LOG.error("Failed to authenticate app '" + appid + "' with SAML: ", (Throwable)ex);
                }
                finally {
                    if (!samlSettingsLoaded) {
                        LOG.error("Failed to load SAML certificate for app '{}', check the format and encoding.", (Object)appid);
                    }
                }
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, Map<String, List<String>> samlAttributes) throws IOException {
        UserAuthentication userAuth = null;
        User user = new User();
        Map<String, String> userData = SAMLAuthFilter.populateUserData(app, samlAttributes);
        if (!userData.isEmpty()) {
            String samlUserId = userData.get("uid");
            String pic = userData.getOrDefault("pic", null);
            Object email = userData.getOrDefault("email", null);
            String name = userData.getOrDefault("name", "");
            String emailDomain = userData.get("domain");
            if (StringUtils.isBlank((CharSequence)email)) {
                if (Utils.isValidEmail((String)samlUserId)) {
                    email = samlUserId;
                } else if (!StringUtils.isBlank((CharSequence)emailDomain)) {
                    email = samlUserId.concat("@").concat(emailDomain);
                } else {
                    LOG.warn("Blank email attribute for SAML user '{}'.", (Object)samlUserId);
                    email = samlUserId + "@scoold.com";
                }
            }
            user.setAppid(this.getAppid(app));
            user.setIdentifier("saml:".concat(samlUserId));
            user.setEmail((String)email);
            user = User.readUserForIdentifier((User)user);
            if (user == null) {
                user = new User();
                user.setActive(Boolean.valueOf(true));
                user.setAppid(this.getAppid(app));
                user.setEmail((String)email);
                user.setName(StringUtils.isBlank((CharSequence)name) ? "Anonymous" : name);
                user.setPassword(Utils.generateSecurityToken());
                user.setPicture(SAMLAuthFilter.getPicture(pic));
                user.setIdentifier("saml:".concat(samlUserId));
                String id = user.create();
                if (id == null) {
                    throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                }
            } else if (this.updateUserInfo(user, pic, (String)email, name)) {
                user.update();
            }
            userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(User user, String pic, String email, String name) {
        String picture = SAMLAuthFilter.getPicture(pic);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return update;
    }

    private static Map<String, String> populateUserData(App app, Map<String, List<String>> attributes) {
        HashMap<String, String> data = new HashMap<String, String>();
        String useridIdParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.id", "UserID");
        String pictureParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.picture", "Picture");
        String emailParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.email", "EmailAddress");
        String nameParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.name", "GivenName");
        String fnameParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.firstname", "FirstName");
        String lnameParam = Para.getConfig().getSettingForApp(app, "security.saml.attributes.lastname", "LastName");
        String emailDomain = Para.getConfig().getSettingForApp(app, "security.saml.domain", "paraio.com");
        if (attributes.containsKey(useridIdParam)) {
            data.put("uid", attributes.get(useridIdParam).get(0));
            data.put("domain", emailDomain);
            if (attributes.containsKey(pictureParam) && !attributes.get(pictureParam).isEmpty()) {
                data.put("pic", attributes.get(pictureParam).get(0));
            }
            if (attributes.containsKey(emailParam) && !attributes.get(emailParam).isEmpty()) {
                data.put("email", attributes.get(emailParam).get(0));
            } else {
                LOG.warn("Missing value for SAML attribute '{}'.", (Object)emailParam);
            }
            if (attributes.containsKey(nameParam) && !attributes.get(nameParam).isEmpty()) {
                data.put("name", attributes.get(nameParam).get(0));
            }
            if (!data.containsKey("name") && attributes.containsKey(fnameParam)) {
                String fname = attributes.get(fnameParam).get(0);
                if (attributes.containsKey(lnameParam)) {
                    data.put("name", StringUtils.trimToEmpty((String)(fname + " " + attributes.get(lnameParam).get(0))));
                }
            }
            if (!data.containsKey("name") || StringUtils.isBlank((CharSequence)((CharSequence)data.get("name")))) {
                LOG.warn("Missing values for SAML attributes '{}', '{}', '{}'.", new Object[]{nameParam, fnameParam, lnameParam});
            }
        } else {
            LOG.error("Incorrect SAML attibute mapping - couldn't find user id value for key '{}'.", (Object)useridIdParam);
        }
        return data;
    }

    private static String getPicture(String pic) {
        if (pic != null) {
            if (pic.contains("?")) {
                return pic.substring(0, pic.indexOf(63));
            }
            return pic;
        }
        return null;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }

    protected static Map<String, Object> getSAMLSettings(App app) {
        if (app == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("onelogin.saml2.strict", true);
        conf.put("onelogin.saml2.debug", !Para.getConfig().inProduction());
        String spEntityId = SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.sp.entityid", "");
        String spACS = SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.sp.assertion_consumer_service.url", spEntityId);
        conf.put("onelogin.saml2.sp.entityid", spEntityId);
        conf.put("onelogin.saml2.sp.assertion_consumer_service.url", StringUtils.isBlank((CharSequence)spACS) ? spEntityId : spACS);
        conf.put("onelogin.saml2.sp.nameidformat", SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.sp.nameidformat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        conf.put("onelogin.saml2.sp.x509cert", Utils.base64dec((String)SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.sp.x509cert", "")));
        conf.put("onelogin.saml2.sp.privatekey", Utils.base64dec((String)SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.sp.privatekey", "")));
        String entityId = SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.idp.entityid", "");
        String ssoServiceUrl = SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.idp.single_sign_on_service.url", "");
        String idpCert = Utils.base64dec((String)SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.idp.x509cert", ""));
        if (!StringUtils.isBlank((CharSequence)entityId)) {
            conf.put("onelogin.saml2.idp.entityid", entityId);
        }
        if (!StringUtils.isBlank((CharSequence)ssoServiceUrl)) {
            conf.put("onelogin.saml2.idp.single_sign_on_service.url", ssoServiceUrl);
        }
        if (!StringUtils.isBlank((CharSequence)idpCert)) {
            conf.put("onelogin.saml2.idp.x509cert", idpCert);
        }
        conf.put("onelogin.saml2.security.authnrequest_signed", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.authnrequest_signed", false));
        conf.put("onelogin.saml2.security.want_messages_signed", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_messages_signed", false));
        conf.put("onelogin.saml2.security.want_assertions_signed", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_assertions_signed", false));
        conf.put("onelogin.saml2.security.want_assertions_encrypted", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_assertions_encrypted", false));
        conf.put("onelogin.saml2.security.want_nameid", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_nameid", true));
        conf.put("onelogin.saml2.security.want_nameid_encrypted", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_nameid_encrypted", false));
        conf.put("onelogin.saml2.security.sign_metadata", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.sign_metadata", false));
        conf.put("onelogin.saml2.security.want_xml_validation", SAMLAuthFilter.getConfigPropBool(app, "onelogin.saml2.security.want_xml_validation", true));
        conf.put("onelogin.saml2.security.signature_algorithm", SAMLAuthFilter.getConfigProp(app, "onelogin.saml2.security.signature_algorithm", ""));
        return conf;
    }

    private static String getConfigProp(App app, String propKey, String defaultValue) {
        return Para.getConfig().getSettingForApp(app, "security.saml" + StringUtils.removeStart((String)propKey, (String)"onelogin.saml2"), defaultValue);
    }

    private static boolean getConfigPropBool(App app, String propKey, boolean defaultValue) {
        return Boolean.parseBoolean(SAMLAuthFilter.getConfigProp(app, propKey, Boolean.toString(defaultValue)));
    }
}

