/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.LDAPAuthentication;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.InetOrgPerson;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class LdapAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthFilter.class);
    public static final String LDAP_ACTION = "ldap_auth";

    public LdapAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getServletPath();
        UserAuthentication userAuth = null;
        String username = request.getParameter(Para.getConfig().ldapUsernameParameter());
        String password = request.getParameter(Para.getConfig().ldapPasswordParameter());
        String appid = SecurityUtils.getAppidFromAuthRequest(request);
        if (requestURI.endsWith(LDAP_ACTION) && !StringUtils.isBlank((CharSequence)username) && !StringUtils.isBlank((CharSequence)password)) {
            try {
                App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
                LDAPAuthentication auth = new LDAPAuthentication(username, password).withApp(app);
                SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"})));
                Authentication ldapAuth = this.getAuthenticationManager().authenticate((Authentication)auth);
                if (ldapAuth != null) {
                    userAuth = this.getOrCreateUser(app, ldapAuth);
                } else {
                    LOG.error("LDAP authentication failed.");
                }
            }
            catch (Exception ex) {
                LOG.info("Failed to authenticate '{}' with LDAP server: {}", (Object)username, (Object)ex.getMessage());
                throw new AuthenticationServiceException(ex.getMessage(), ex.getCause());
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    private UserAuthentication getOrCreateUser(App app, Authentication ldapAuth) {
        LOG.debug("LDAP response: {}", (Object)ldapAuth);
        if (ldapAuth == null) {
            return null;
        }
        UserAuthentication userAuth = null;
        User user = new User();
        InetOrgPerson profile = (InetOrgPerson)ldapAuth.getPrincipal();
        if (profile != null && profile.isEnabled() && profile.isAccountNonLocked() && profile.isAccountNonExpired()) {
            String ldapAccountId = profile.getUsername();
            Object email = profile.getMail();
            String name = StringUtils.join((Object[])profile.getCn(), (String)", ");
            String adDomain = (String)app.getSetting("security.ldap.active_directory_domain");
            String memberOf = ((Collection)Optional.ofNullable(profile.getAuthorities()).orElse(Collections.emptyList())).stream().map(ga -> "CN=" + ga.getAuthority()).collect(Collectors.joining(","));
            String groups = this.getGroupsFromDN(profile.getDn(), memberOf, app);
            if (StringUtils.isBlank((CharSequence)email)) {
                if (Utils.isValidEmail((String)ldapAccountId)) {
                    email = ldapAccountId;
                } else if (!StringUtils.isBlank((CharSequence)adDomain)) {
                    LOG.warn("The AD doesn't have email attribute. Instead, it uses domain name for email address: {}@{}.", (Object)ldapAccountId, (Object)adDomain);
                    email = ldapAccountId.concat("@").concat(adDomain);
                } else {
                    LOG.warn("Blank email attribute for LDAP user '{}'.", (Object)ldapAccountId);
                    email = ldapAccountId + "@paraio.com";
                }
            }
            if (Boolean.parseBoolean(String.valueOf(app.getSetting("security.ldap.username_as_name")))) {
                name = ((String)email).split("@")[0];
            }
            user.setAppid(this.getAppid(app));
            user.setIdentifier("ldap:".concat(ldapAccountId));
            user.setEmail((String)email);
            user = User.readUserForIdentifier((User)user);
            if (user == null) {
                user = new User();
                user.setActive(Boolean.valueOf(true));
                user.setAppid(this.getAppid(app));
                user.setEmail((String)email);
                user.setGroups(groups);
                user.setName(StringUtils.isBlank((CharSequence)name) ? "No Name" : name);
                user.setPassword(Utils.generateSecurityToken());
                user.setIdentifier("ldap:".concat(ldapAccountId));
                String id = user.create();
                if (id == null) {
                    throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                }
            } else if (this.updateUserInfo(user, (String)email, name, groups)) {
                user.update();
            }
            userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
        } else {
            LOG.error("Failed to create account - is the LDAP user active? principal={}", (Object)profile);
        }
        return userAuth;
    }

    private boolean updateUserInfo(User user, String email, String name, String groups) {
        boolean update = false;
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)groups) && !StringUtils.equals((CharSequence)user.getGroups(), (CharSequence)groups)) {
            user.setGroups(groups);
            CoreUtils.getInstance().overwrite(user.getAppid(), (ParaObject)user);
            update = false;
        }
        return update;
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        UserAuthentication userAuth = null;
        if (accessToken != null && accessToken.contains(Para.getConfig().separator())) {
            String[] parts = accessToken.split(Para.getConfig().separator(), 2);
            String username = parts[0];
            String password = parts[1];
            try {
                LDAPAuthentication auth = new LDAPAuthentication(username, password).withApp(app);
                SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"})));
                Authentication ldapAuth = this.getAuthenticationManager().authenticate((Authentication)auth);
                if (ldapAuth != null) {
                    userAuth = this.getOrCreateUser(app, ldapAuth);
                }
            }
            catch (Exception ex) {
                LOG.info("Failed to authenticate '{}' with LDAP server: {}", (Object)username, (Object)ex.getMessage());
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), false);
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }

    private String getGroupsFromDN(String dn, String memberOf, App app) {
        String group = User.Groups.USERS.toString();
        if (!StringUtils.isBlank((CharSequence)dn)) {
            String modsNode = (String)app.getSetting("security.ldap.mods_group_node");
            String adminsNode = (String)app.getSetting("security.ldap.admins_group_node");
            if (!StringUtils.isBlank((CharSequence)modsNode) && (StringUtils.containsIgnoreCase((CharSequence)dn, (CharSequence)modsNode) || StringUtils.containsIgnoreCase((CharSequence)memberOf, (CharSequence)modsNode))) {
                group = User.Groups.MODS.toString();
            }
            if (!StringUtils.isBlank((CharSequence)adminsNode) && (StringUtils.containsIgnoreCase((CharSequence)dn, (CharSequence)adminsNode) || StringUtils.containsIgnoreCase((CharSequence)memberOf, (CharSequence)adminsNode))) {
                group = User.Groups.ADMINS.toString();
            }
        }
        return group;
    }
}

