/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.CsrfProtectionRequestMatcher;
import com.erudika.para.server.security.IgnoredRequestMatcher;
import com.erudika.para.server.security.JWTAuthenticationProvider;
import com.erudika.para.server.security.JwtConfigurer;
import com.erudika.para.server.security.LDAPAuthenticationProvider;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SimpleAccessDeniedHandler;
import com.erudika.para.server.security.SimpleAuthenticationEntryPoint;
import com.erudika.para.server.security.SimpleRequestCache;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import jakarta.annotation.security.DeclareRoles;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableWebSecurity
@DeclareRoles(value={"ROLE_USER", "ROLE_MOD", "ROLE_ADMIN", "ROLE_APP"})
public class SecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String[] DEFAULT_ROLES = new String[]{"USER", "MOD", "ADMIN", "APP"};

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> {
            DefaultHttpFirewall firewall = new DefaultHttpFirewall();
            firewall.setAllowUrlEncodedSlash(true);
            web.httpFirewall((HttpFirewall)firewall);
        };
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        String signinPath = Para.getConfig().signinPath();
        String signoutPath = Para.getConfig().signoutPath();
        String accessDeniedPath = Para.getConfig().accessDeniedPath();
        String signoutSuccessPath = Para.getConfig().signoutSuccessPath();
        ConfigObject protectedResources = Para.getConfig().protectedPaths();
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/**"})).permitAll());
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new RequestMatcher[]{IgnoredRequestMatcher.INSTANCE})).permitAll());
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new RequestMatcher[]{RestRequestMatcher.INSTANCE})).authenticated());
        this.parseProtectedResources(http, protectedResources);
        if (Para.getConfig().csrfProtectionEnabled()) {
            CookieCsrfTokenRepository tokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
            XorCsrfTokenRequestAttributeHandler delegate = new XorCsrfTokenRequestAttributeHandler();
            delegate.setCsrfRequestAttributeName("_csrf");
            CsrfTokenRequestHandler requestHandler = (arg_0, arg_1, arg_2) -> ((XorCsrfTokenRequestAttributeHandler)delegate).handle(arg_0, arg_1, arg_2);
            http.csrf(csrf -> csrf.requireCsrfProtectionMatcher(CsrfProtectionRequestMatcher.INSTANCE).csrfTokenRepository((CsrfTokenRepository)tokenRepository).csrfTokenRequestHandler(requestHandler)).addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.sessionManagement(session -> session.enableSessionUrlRewriting(false));
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.NEVER));
        http.sessionManagement(session -> session.sessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy()));
        http.exceptionHandling(session -> session.authenticationEntryPoint((AuthenticationEntryPoint)new SimpleAuthenticationEntryPoint(signinPath)));
        http.exceptionHandling(session -> session.accessDeniedHandler((AccessDeniedHandler)new SimpleAccessDeniedHandler(accessDeniedPath)));
        http.requestCache(cache -> cache.requestCache((RequestCache)new SimpleRequestCache()));
        http.logout(logout -> logout.deleteCookies(new String[]{Para.getConfig().authCookieName()}).invalidateHttpSession(true).logoutUrl(signoutPath).logoutSuccessUrl(signoutSuccessPath));
        http.rememberMe(rme -> rme.disable());
        http.authenticationProvider((AuthenticationProvider)new JWTAuthenticationProvider());
        http.authenticationProvider((AuthenticationProvider)new LDAPAuthenticationProvider());
        http.with((SecurityConfigurerAdapter)new JwtConfigurer(), c -> {});
        return (SecurityFilterChain)http.build();
    }

    private void parseProtectedResources(HttpSecurity http, ConfigObject protectedResources) throws Exception {
        if (protectedResources == null || protectedResources.isEmpty()) {
            return;
        }
        for (ConfigValue cv : protectedResources.values()) {
            LinkedList<String> patterns = new LinkedList<String>();
            LinkedList<String> roles = new LinkedList<String>();
            HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
            for (ConfigValue configValue : (ConfigList)cv) {
                try {
                    if (configValue instanceof ConfigList) {
                        for (ConfigValue role : (ConfigList)configValue) {
                            String r = ((String)role.unwrapped()).toUpperCase().trim();
                            HttpMethod m = HttpMethod.valueOf((String)r);
                            if (m != null) {
                                methods.add(m);
                                continue;
                            }
                            roles.add(r);
                        }
                        continue;
                    }
                    patterns.add((String)configValue.unwrapped());
                }
                catch (Exception e) {
                    logger.error("Invalid config syntax for protected resource: {}.", (Object)configValue.render(), (Object)e);
                }
            }
            String[] rolz = roles.isEmpty() ? DEFAULT_ROLES : (String[])roles.toArray(String[]::new);
            String[] patternz = (String[])patterns.toArray(String[]::new);
            if (methods.isEmpty()) {
                http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(patternz)).hasAnyRole(rolz));
                continue;
            }
            for (HttpMethod method : methods) {
                http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(method, patternz)).hasAnyRole(rolz));
            }
        }
    }

    private static final class CsrfCookieFilter
    extends OncePerRequestFilter {
        private CsrfCookieFilter() {
        }

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            CsrfToken csrfToken = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
            csrfToken.getToken();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

