/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuth1HmacSigner {
    private static final Logger logger = LoggerFactory.getLogger(OAuth1HmacSigner.class);

    private OAuth1HmacSigner() {
    }

    public static String sign(String httpMethod, String url, Map<String, String[]> params, String apiKey, String apiSecret, String oauthToken, String tokenSecret) {
        try {
            if (httpMethod != null && url != null && !url.trim().isEmpty() && params != null && apiSecret != null) {
                TreeMap<String, String[]> paramMap = new TreeMap<String, String[]>(params);
                String keyString = OAuth1HmacSigner.percentEncode(apiSecret) + "&" + OAuth1HmacSigner.percentEncode(tokenSecret);
                byte[] keyBytes = keyString.getBytes(Para.getConfig().defaultEncoding());
                SecretKeySpec key = new SecretKeySpec(keyBytes, "HmacSHA1");
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(key);
                OAuth1HmacSigner.addRequiredParameters(paramMap, apiKey, oauthToken);
                String sbs = httpMethod.toUpperCase() + "&" + OAuth1HmacSigner.percentEncode(OAuth1HmacSigner.normalizeRequestUrl(url)) + "&" + OAuth1HmacSigner.percentEncode(OAuth1HmacSigner.normalizeRequestParameters(paramMap));
                logger.debug("Oatuh1 base string: {}", (Object)sbs);
                byte[] text = sbs.getBytes(Para.getConfig().defaultEncoding());
                String sig = Utils.base64enc((byte[])mac.doFinal(text)).trim();
                logger.debug("Oauth1 Signature: {}", (Object)sig);
                StringBuilder sb = new StringBuilder();
                sb.append("OAuth ");
                if (paramMap.containsKey("realm")) {
                    String val = ((String[])paramMap.get("realm"))[0];
                    sb.append("realm=\"".concat(val).concat("\""));
                    sb.append(", ");
                }
                Map<String, SortedSet<String>> oauthParams = OAuth1HmacSigner.getOAuthParameters(paramMap);
                TreeSet<String> set = new TreeSet<String>();
                set.add(OAuth1HmacSigner.percentEncode(sig));
                oauthParams.put("oauth_signature", set);
                Iterator<String> iter = oauthParams.keySet().iterator();
                while (iter.hasNext()) {
                    String param = iter.next();
                    SortedSet<String> valSet = oauthParams.get(param);
                    String value = valSet == null || valSet.isEmpty() ? null : valSet.first();
                    String headerElem = value == null ? null : param + "=\"" + value + "\"";
                    sb.append(headerElem);
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                String header = sb.toString();
                logger.debug("OAuth1 signed header: {}", (Object)header);
                return header;
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return null;
    }

    private static String normalizeRequestUrl(String url) throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        URI uri = new URI(url);
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(58)) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    private static String normalizeRequestParameters(Map<String, String[]> params) throws IOException {
        if (params == null) {
            return "";
        }
        ArrayList<ComparableParameter> paramz = new ArrayList<ComparableParameter>(params.size());
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            if ("oauth_signature".equals(param.getKey()) && !"realm".equals(param.getKey())) continue;
            for (String val : param.getValue()) {
                paramz.add(new ComparableParameter(param.getKey(), val));
            }
        }
        Collections.sort(paramz);
        StringBuilder sb = new StringBuilder();
        Iterator iter = paramz.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            ComparableParameter p = (ComparableParameter)iter.next();
            String param = p.key;
            String value = p.value;
            if (!first) {
                sb.append("&");
            }
            if (value == null) {
                sb.append(param.concat("="));
            } else {
                sb.append(param.concat("=").concat(value));
            }
            first = false;
        }
        String s = sb.toString();
        return s;
    }

    private static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, Para.getConfig().defaultEncoding()).replaceAll("\\+", "%20").replaceAll("\\*", "%2A").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    private static Map<String, SortedSet<String>> getOAuthParameters(Map<String, String[]> params) {
        TreeMap<String, SortedSet<String>> oauthParams = new TreeMap<String, SortedSet<String>>();
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            String key = param.getKey();
            if (!key.startsWith("oauth_") && !key.startsWith("x_oauth_") || param.getValue() == null) continue;
            TreeSet<String> set = new TreeSet<String>();
            for (String val : param.getValue()) {
                if (val == null) continue;
                set.add(val);
            }
            if (set.isEmpty()) continue;
            oauthParams.put(key, set);
        }
        return oauthParams;
    }

    private static void addRequiredParameters(Map<String, String[]> pMap, String apiKey, String oauthToken) {
        if (pMap != null) {
            if (oauthToken != null) {
                pMap.put("oauth_token", new String[]{oauthToken});
            }
            if (pMap.get("oauth_consumer_key") == null) {
                pMap.put("oauth_consumer_key", new String[]{apiKey});
            }
            if (pMap.get("oauth_signature_method") == null) {
                pMap.put("oauth_signature_method", new String[]{"HMAC-SHA1"});
            }
            if (pMap.get("oauth_timestamp") == null) {
                pMap.put("oauth_timestamp", new String[]{Long.toString(System.currentTimeMillis() / 1000L)});
            }
            if (pMap.get("oauth_nonce") == null) {
                String nonce = Utils.stripAndTrim((String)Utils.generateSecurityToken((int)32));
                pMap.put("oauth_nonce", new String[]{nonce.length() > 32 ? nonce.substring(0, 32) : nonce});
            }
            if (pMap.get("oauth_version") == null) {
                pMap.put("oauth_version", new String[]{"1.0"});
            }
        }
    }

    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        private final String value;
        private final String key;
        private final String encodedKey;

        ComparableParameter(String key, String value) {
            this.value = value;
            String n = ComparableParameter.toString(key);
            String v = ComparableParameter.toString(value);
            this.key = OAuth1HmacSigner.percentEncode(n);
            this.encodedKey = OAuth1HmacSigner.percentEncode(n) + " " + OAuth1HmacSigner.percentEncode(v);
        }

        private static String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.encodedKey.compareTo(that.encodedKey);
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + Objects.hashCode(this.value);
            hash = 19 * hash + Objects.hashCode(this.key);
            hash = 19 * hash + Objects.hashCode(this.encodedKey);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparableParameter other = (ComparableParameter)obj;
            if (!Objects.equals(this.value, other.value)) {
                return false;
            }
            if (!Objects.equals(this.key, other.key)) {
                return false;
            }
            return Objects.equals(this.encodedKey, other.encodedKey);
        }

        public String toString() {
            return this.encodedKey;
        }
    }
}

