/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.server.security.LDAPAuthentication;
import com.erudika.para.server.security.LDAPAuthenticator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class LDAPAuthenticationProvider
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) {
        LDAPAuthentication auth = (LDAPAuthentication)((Object)authentication);
        if (auth != null && this.supports(authentication.getClass())) {
            Map<String, String> ldapSettings = auth.getLdapSettings();
            if (!ldapSettings.isEmpty()) {
                LdapAuthenticationProvider ldapProvider;
                String adDomain = ldapSettings.get("security.ldap.active_directory_domain");
                String adEnabled = ldapSettings.get("security.ldap.ad_mode_enabled");
                String ldapServerURL = ldapSettings.get("security.ldap.server_url");
                String searchFilter = ldapSettings.get("security.ldap.user_search_filter");
                if (adEnabled.equals("true") || !StringUtils.isBlank((CharSequence)adDomain)) {
                    String upn = auth.getName();
                    if (!adDomain.isEmpty()) {
                        upn = StringUtils.substringBefore((String)upn, (String)"@");
                    }
                    authentication = new LDAPAuthentication(upn, auth.getCredentials());
                    String rootDn = ldapSettings.get("security.ldap.base_dn");
                    ldapProvider = StringUtils.isBlank((CharSequence)rootDn) ? new ActiveDirectoryLdapAuthenticationProvider(adDomain, ldapServerURL) : new ActiveDirectoryLdapAuthenticationProvider(adDomain, ldapServerURL, rootDn);
                    ((ActiveDirectoryLdapAuthenticationProvider)ldapProvider).setConvertSubErrorCodesToExceptions(true);
                    if (!StringUtils.isBlank((CharSequence)searchFilter)) {
                        ((ActiveDirectoryLdapAuthenticationProvider)ldapProvider).setSearchFilter(searchFilter);
                    }
                } else {
                    ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new LDAPAuthenticator(ldapSettings));
                }
                ldapProvider.setUserDetailsContextMapper((UserDetailsContextMapper)new InetOrgPersonContextMapper());
                return ldapProvider.authenticate(authentication);
            }
            throw new AuthenticationServiceException("LDAP configuration is missing.");
        }
        throw new AuthenticationServiceException("Unsupported authentication type.");
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

