/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.server.ParaServer;
import com.erudika.para.server.security.JWTRestfulAuthFilter;
import com.erudika.para.server.security.RestAuthFilter;
import com.erudika.para.server.security.filters.SAMLMetadataFilter;
import jakarta.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JwtConfigurer
extends AbstractHttpConfigurer<JwtConfigurer, HttpSecurity> {
    public void configure(HttpSecurity builder) throws Exception {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        JWTRestfulAuthFilter jwtAuthFilter = new JWTRestfulAuthFilter(authenticationManager);
        RestAuthFilter restAuthFilter = new RestAuthFilter();
        SAMLMetadataFilter samlMetadataFilter = new SAMLMetadataFilter();
        ParaServer.injectInto((Object)jwtAuthFilter);
        jwtAuthFilter.getPasswordAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getPasswordAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getPasswordlessAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getPasswordlessAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getFacebookAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getFacebookAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getGoogleAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getGoogleAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getLinkedinAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getLinkedinAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getTwitterAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getTwitterAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getGithubAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getGithubAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getMicrosoftAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getMicrosoftAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getSlackAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getSlackAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getAmazonAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getAmazonAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getGenericOAuth2Auth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getGenericOAuth2Auth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getLdapAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getLdapAuth(), BasicAuthenticationFilter.class);
        jwtAuthFilter.getSamlAuth().setAuthenticationManager(authenticationManager);
        builder.addFilterAfter((Filter)jwtAuthFilter.getSamlAuth(), BasicAuthenticationFilter.class);
        builder.addFilterAfter((Filter)samlMetadataFilter, BasicAuthenticationFilter.class);
        builder.addFilterBefore((Filter)jwtAuthFilter, RememberMeAuthenticationFilter.class);
        builder.addFilterBefore((Filter)restAuthFilter, RememberMeAuthenticationFilter.class);
    }

    public static JwtConfigurer customDsl() {
        return new JwtConfigurer();
    }
}

