/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.server.security.AppAuthentication;
import com.erudika.para.server.security.JWTAuthentication;
import com.erudika.para.server.security.SecurityUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;

public class JWTAuthenticationProvider
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) {
        JWTAuthentication jwtToken = (JWTAuthentication)authentication;
        if (jwtToken != null && this.supports(authentication.getClass())) {
            User user = SecurityUtils.getAuthenticatedUser(authentication);
            App app = jwtToken.getApp();
            if (app != null) {
                boolean isUser = user != null;
                String secret = jwtToken.getApp().getSecret() + (isUser ? user.getTokenSecret() : "");
                if (SecurityUtils.isValidJWToken(secret, jwtToken.getJwt())) {
                    return isUser ? jwtToken : new AppAuthentication(app);
                }
                throw new BadCredentialsException("Invalid or expired token.");
            }
            throw new AuthenticationServiceException("App not found.");
        }
        throw new AuthenticationServiceException("Unsupported token type.");
    }

    public boolean supports(Class<?> authentication) {
        return JWTAuthentication.class.isAssignableFrom(authentication);
    }
}

