/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.IgnoredRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class CsrfProtectionRequestMatcher
implements RequestMatcher {
    public static final RequestMatcher INSTANCE = new CsrfProtectionRequestMatcher();
    private final Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private final RegexRequestMatcher authEndpoints = new RegexRequestMatcher("^/\\w+_auth", null, true);
    private final RegexRequestMatcher passAuthEndpoint = new RegexRequestMatcher("^/password_auth", null, true);
    private final RegexRequestMatcher samlEndpoint = new RegexRequestMatcher("^/saml_auth.*", null, true);
    private final RegexRequestMatcher samlMetaEndpoint = new RegexRequestMatcher("^/saml_metadata.*", null, true);
    private final RegexRequestMatcher signinEndpoint = new RegexRequestMatcher("^" + Para.getConfig().signinPath() + ".*", null, true);

    private CsrfProtectionRequestMatcher() {
    }

    public boolean matches(HttpServletRequest request) {
        boolean matches = !RestRequestMatcher.INSTANCE.matches(request) && !IgnoredRequestMatcher.INSTANCE.matches(request) && !this.samlMetaEndpoint.matches(request) && !this.samlEndpoint.matches(request) && !this.authEndpoints.matches(request) && !this.allowedMethods.matcher(request.getMethod()).matches();
        return matches || this.passAuthEndpoint.matches(request) || this.signinEndpoint.matches(request);
    }
}

