/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.search;

import com.erudika.para.core.search.MockSearch;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.utils.Para;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;

public class SearchModule
extends AbstractModule {
    protected void configure() {
        String selectedSearch = Para.getConfig().searchPlugin();
        Search searchPlugin = this.loadExternalSearch(selectedSearch);
        if (searchPlugin != null) {
            this.bind(Search.class).to(searchPlugin.getClass()).asEagerSingleton();
        } else {
            this.bindToDefault();
        }
    }

    void bindToDefault() {
        this.bind(Search.class).to(MockSearch.class).asEagerSingleton();
    }

    final Search loadExternalSearch(String classSimpleName) {
        ServiceLoader<Search> searchLoader = ServiceLoader.load(Search.class, Para.getParaClassLoader());
        for (Search search : searchLoader) {
            if (search == null || !classSimpleName.equalsIgnoreCase(search.getClass().getSimpleName())) continue;
            return search;
        }
        return null;
    }
}

