/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.rest;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.User;
import com.erudika.para.core.metrics.Metrics;
import com.erudika.para.core.rest.CustomResourceHandler;
import com.erudika.para.core.rest.GenericExceptionMapper;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.HumanTime;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.core.validation.Constraint;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.utils.HealthUtils;
import com.erudika.para.server.utils.filters.FieldFilter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.nimbusds.jwt.SignedJWT;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Api1
extends ResourceConfig {
    public static final String PATH = "/v1/";
    private static final Logger logger = LoggerFactory.getLogger(Api1.class);
    private static final String JSON = "application/json";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String PATCH = "PATCH";

    public Api1() {
        if (!Para.getConfig().apiEnabled()) {
            return;
        }
        this.property("jersey.config.server.wadl.disableWadl", true);
        this.setApplicationName(Para.getConfig().getRootAppIdentifier());
        this.register(GenericExceptionMapper.class);
        this.register(new JacksonJsonProvider(ParaObjectUtils.getJsonMapper()));
        this.register(FieldFilter.class);
        Resource.Builder logo = Resource.builder((String)"/");
        logo.addMethod(GET).produces(new String[]{JSON}).handledBy(this.introHandler());
        this.registerResources(new Resource[]{logo.build()});
        this.registerCrudApi("{type}", this.typeCrudHandler(), Api1.linksHandler());
        Resource.Builder searchRes = Resource.builder((String)"search/{querytype}");
        searchRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.searchHandler(null, null));
        this.registerResources(new Resource[]{searchRes.build()});
        Resource.Builder setupRes = Resource.builder((String)"_setup");
        setupRes.addMethod(GET).produces(new String[]{JSON}).handledBy(this.setupHandler());
        setupRes.addChildResource("{appid}").addMethod(GET).produces(new String[]{JSON}).handledBy(this.setupHandler());
        this.registerResources(new Resource[]{setupRes.build()});
        Resource.Builder keysRes = Resource.builder((String)"_newkeys");
        keysRes.addMethod(POST).produces(new String[]{JSON}).handledBy(this.keysHandler());
        this.registerResources(new Resource[]{keysRes.build()});
        Resource.Builder typesRes = Resource.builder((String)"_types");
        typesRes.addMethod(GET).produces(new String[]{JSON}).handledBy(this.listTypesHandler());
        this.registerResources(new Resource[]{typesRes.build()});
        Resource.Builder meRes = Resource.builder((String)"_me");
        meRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.meHandler());
        this.registerResources(new Resource[]{meRes.build()});
        Resource.Builder idRes = Resource.builder((String)"_id/{id}");
        idRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.readIdHandler());
        this.registerResources(new Resource[]{idRes.build()});
        Resource.Builder confRes = Resource.builder((String)"_config");
        confRes.addChildResource("options").addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.configOptionsHandler());
        this.registerResources(new Resource[]{confRes.build()});
        Resource.Builder valRes = Resource.builder((String)"_constraints");
        valRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.getConstrHandler(null));
        valRes.addChildResource("{type}").addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.getConstrHandler(null));
        valRes.addChildResource("{type}/{field}/{cname}").addMethod(PUT).produces(new String[]{JSON}).handledBy(Api1.addConstrHandler(null));
        valRes.addChildResource("{type}/{field}/{cname}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(Api1.removeConstrHandler(null));
        this.registerResources(new Resource[]{valRes.build()});
        Resource.Builder permRes = Resource.builder((String)"_permissions");
        permRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.getPermitHandler(null));
        permRes.addChildResource("{subjectid}").addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.getPermitHandler(null));
        permRes.addChildResource("{subjectid}/{type}/{method}").addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.checkPermitHandler(null));
        permRes.addChildResource("{subjectid}/{type}").addMethod(PUT).produces(new String[]{JSON}).handledBy(Api1.grantPermitHandler(null));
        permRes.addChildResource("{subjectid}/{type}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(Api1.revokePermitHandler(null));
        permRes.addChildResource("{subjectid}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(Api1.revokePermitHandler(null));
        this.registerResources(new Resource[]{permRes.build()});
        Resource.Builder appSettingsRes = Resource.builder((String)"_settings");
        appSettingsRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.appSettingsHandler(null));
        appSettingsRes.addMethod(PUT).produces(new String[]{JSON}).handledBy(Api1.appSettingsHandler(null));
        appSettingsRes.addChildResource("{key}").addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.appSettingsHandler(null));
        appSettingsRes.addChildResource("{key}").addMethod(PUT).produces(new String[]{JSON}).handledBy(Api1.appSettingsHandler(null));
        appSettingsRes.addChildResource("{key}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(Api1.appSettingsHandler(null));
        this.registerResources(new Resource[]{appSettingsRes.build()});
        Resource.Builder healthCheckRes = Resource.builder((String)"_health");
        healthCheckRes.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.healthCheckHandler());
        this.registerResources(new Resource[]{healthCheckRes.build()});
        Resource.Builder utilsRes = Resource.builder((String)"utils/{method}");
        utilsRes.addMethod(GET).produces(new String[]{JSON}).handledBy(this.utilsHandler());
        this.registerResources(new Resource[]{utilsRes.build()});
        Resource.Builder reindexRes = Resource.builder((String)"_reindex");
        reindexRes.addMethod(POST).produces(new String[]{JSON}).handledBy(Api1.reindexHandler());
        this.registerResources(new Resource[]{reindexRes.build()});
        Resource.Builder backupRes = Resource.builder((String)"_export");
        backupRes.addMethod(GET).produces(new String[]{"application/zip"}).handledBy(Api1.backupHandler(null));
        this.registerResources(new Resource[]{backupRes.build()});
        Resource.Builder restoreRes = Resource.builder((String)"_import");
        restoreRes.addMethod(PUT).produces(new String[]{JSON}).consumes(new String[]{"application/zip"}).handledBy(Api1.restoreHandler(null));
        this.registerResources(new Resource[]{restoreRes.build()});
        for (final CustomResourceHandler handler : Para.getCustomResourceHandlers()) {
            Resource.Builder custom = Resource.builder((String)handler.getRelativePath());
            custom.addMethod(GET).produces(new String[]{JSON}).handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext ctx) {
                    String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
                    try (Metrics.Context context = Metrics.time((String)appid, (Class)handler.getClass(), (String[])new String[]{"handleGet"});){
                        Response response = handler.handleGet(ctx);
                        return response;
                    }
                }
            });
            custom.addMethod(POST).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext ctx) {
                    String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
                    try (Metrics.Context context = Metrics.time((String)appid, (Class)handler.getClass(), (String[])new String[]{"handlePost"});){
                        Response response = handler.handlePost(ctx);
                        return response;
                    }
                }
            });
            custom.addMethod(PATCH).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext ctx) {
                    String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
                    try (Metrics.Context context = Metrics.time((String)appid, (Class)handler.getClass(), (String[])new String[]{"handlePatch"});){
                        Response response = handler.handlePatch(ctx);
                        return response;
                    }
                }
            });
            custom.addMethod(PUT).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext ctx) {
                    String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
                    try (Metrics.Context context = Metrics.time((String)appid, (Class)handler.getClass(), (String[])new String[]{"handlePut"});){
                        Response response = handler.handlePut(ctx);
                        return response;
                    }
                }
            });
            custom.addMethod(DELETE).produces(new String[]{JSON}).handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext ctx) {
                    String appid = ParaObjectUtils.getAppidFromAuthHeader((String)((String)ctx.getHeaders().getFirst((Object)"Authorization")));
                    try (Metrics.Context context = Metrics.time((String)appid, (Class)handler.getClass(), (String[])new String[]{"handleDelete"});){
                        Response response = handler.handleDelete(ctx);
                        return response;
                    }
                }
            });
            this.registerResources(new Resource[]{custom.build()});
        }
    }

    private void registerCrudApi(String path, Inflector<ContainerRequestContext, Response> handler, Inflector<ContainerRequestContext, Response> linksHandler) {
        Resource.Builder core = Resource.builder((String)path);
        core.addMethod(GET).produces(new String[]{JSON}).handledBy(handler);
        core.addChildResource("search/{querytype}").addMethod(GET).produces(new String[]{JSON}).handledBy(handler);
        core.addChildResource("search").addMethod(GET).produces(new String[]{JSON}).handledBy(handler);
        core.addMethod(POST).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(handler);
        core.addChildResource("{id}").addMethod(GET).produces(new String[]{JSON}).handledBy(handler);
        core.addChildResource("{id}").addMethod(PUT).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(handler);
        core.addChildResource("{id}").addMethod(PATCH).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(handler);
        core.addChildResource("{id}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(handler);
        core.addChildResource("{id}/links/{type2}/{id2}").addMethod(GET).produces(new String[]{JSON}).handledBy(linksHandler);
        core.addChildResource("{id}/links/{type2}").addMethod(GET).produces(new String[]{JSON}).handledBy(linksHandler);
        core.addChildResource("{id}/links/{id2}").addMethod(POST).produces(new String[]{JSON}).handledBy(linksHandler);
        core.addChildResource("{id}/links/{id2}").addMethod(PUT).produces(new String[]{JSON}).handledBy(linksHandler);
        core.addChildResource("{id}/links/{type2}/{id2}").addMethod(DELETE).produces(new String[]{JSON}).handledBy(linksHandler);
        core.addChildResource("{id}/links").addMethod(DELETE).produces(new String[]{JSON}).handledBy(linksHandler);
        Resource.Builder batch = Resource.builder((String)"_batch");
        batch.addMethod(POST).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(Api1.batchCreateHandler(null));
        batch.addMethod(GET).produces(new String[]{JSON}).handledBy(Api1.batchReadHandler(null));
        batch.addMethod(PUT).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(Api1.batchCreateHandler(null));
        batch.addMethod(PATCH).produces(new String[]{JSON}).consumes(new String[]{JSON}).handledBy(Api1.batchUpdateHandler(null));
        batch.addMethod(DELETE).produces(new String[]{JSON}).handledBy(Api1.batchDeleteHandler(null));
        this.registerResources(new Resource[]{core.build()});
        this.registerResources(new Resource[]{batch.build()});
    }

    private Inflector<ContainerRequestContext, Response> utilsHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                MultivaluedMap params = ctx.getUriInfo().getQueryParameters();
                String method = RestUtils.pathParam("method", ctx);
                String string = method = StringUtils.isBlank((CharSequence)method) ? (String)params.getFirst((Object)"method") : method;
                if ("newid".equals(method)) {
                    return Response.ok((Object)Utils.getNewId(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("timestamp".equals(method)) {
                    return Response.ok((Object)Utils.timestamp(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("formatdate".equals(method)) {
                    String format = (String)params.getFirst((Object)"format");
                    String locale = (String)params.getFirst((Object)"locale");
                    Locale loc = Utils.getLocale((String)locale);
                    return Response.ok((Object)Utils.formatDate((String)format, (Locale)loc), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("formatmessage".equals(method)) {
                    String msg = (String)params.getFirst((Object)"message");
                    Object[] paramz = ((List)params.get((Object)"fields")).toArray();
                    return Response.ok((Object)Utils.formatMessage((String)msg, (Object[])paramz), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("nospaces".equals(method)) {
                    String str = (String)params.getFirst((Object)"string");
                    String repl = (String)params.getFirst((Object)"replacement");
                    return Response.ok((Object)Utils.noSpaces((String)str, (String)repl), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("nosymbols".equals(method)) {
                    String str = (String)params.getFirst((Object)"string");
                    return Response.ok((Object)Utils.stripAndTrim((String)str), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                if ("md2html".equals(method)) {
                    String md = (String)params.getFirst((Object)"md");
                    return Response.ok((Object)Utils.markdownToHtml((String)md), (String)"text/html").build();
                }
                if ("timeago".equals(method)) {
                    String d = (String)params.getFirst((Object)"delta");
                    long delta = NumberUtils.toLong((String)d, (long)1L);
                    return Response.ok((Object)HumanTime.approximately((long)delta), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Unknown method: " + (method == null ? "empty" : method));
            }
        };
    }

    private Inflector<ContainerRequestContext, Response> introHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                TreeMap<String, String> info = new TreeMap<String, String>();
                info.put("info", "Para - the backend for busy developers.");
                if (Para.getConfig().versionBannerEnabled()) {
                    info.put("version", StringUtils.replace((String)Para.getVersion(), (String)"-SNAPSHOT", (String)""));
                }
                return Response.ok(info).build();
            }
        };
    }

    private Inflector<ContainerRequestContext, Response> typeCrudHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                String typePlural = RestUtils.pathParam("type", ctx);
                App app = SecurityUtils.getPrincipalApp();
                if (app != null && !StringUtils.isBlank((CharSequence)typePlural)) {
                    String type = (String)ParaObjectUtils.getAllTypes((App)app).get(typePlural);
                    if (type == null) {
                        type = typePlural;
                    }
                    return (Response)Api1.crudHandler(app, type).apply((Object)ctx);
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> crudHandler(final App app, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                String id = RestUtils.pathParam("id", ctx);
                if (StringUtils.isBlank((CharSequence)id)) {
                    if (Api1.GET.equals(ctx.getMethod())) {
                        return (Response)Api1.searchHandler(app, type).apply((Object)ctx);
                    }
                    if (Api1.POST.equals(ctx.getMethod())) {
                        return (Response)Api1.createHandler(app, type).apply((Object)ctx);
                    }
                    if (ctx.getUriInfo().getPath().contains("search")) {
                        return (Response)Api1.searchHandler(app, type).apply((Object)ctx);
                    }
                } else {
                    if (Api1.GET.equals(ctx.getMethod())) {
                        return (Response)Api1.readHandler(app, type).apply((Object)ctx);
                    }
                    if (Api1.PUT.equals(ctx.getMethod())) {
                        return (Response)Api1.overwriteHandler(app, type).apply((Object)ctx);
                    }
                    if (Api1.PATCH.equals(ctx.getMethod())) {
                        return (Response)Api1.updateHandler(app, type).apply((Object)ctx);
                    }
                    if (Api1.DELETE.equals(ctx.getMethod())) {
                        return (Response)Api1.deleteHandler(app, type).apply((Object)ctx);
                    }
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "Type '" + type + "' not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> linksHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                MultivaluedMap params = ctx.getUriInfo().getQueryParameters();
                MultivaluedMap pathp = ctx.getUriInfo().getPathParameters();
                String id = (String)pathp.getFirst((Object)"id");
                String type = (String)pathp.getFirst((Object)"type");
                String id2 = (String)pathp.getFirst((Object)"id2");
                String type2 = (String)pathp.getFirst((Object)"type2");
                App app = SecurityUtils.getPrincipalApp();
                if (app == null) {
                    return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, new String[0]);
                }
                String typeSingular = type == null ? null : (String)ParaObjectUtils.getAllTypes((App)app).get(type);
                type = typeSingular == null ? type : typeSingular;
                id2 = StringUtils.isBlank((CharSequence)id2) ? null : id2;
                type2 = StringUtils.isBlank((CharSequence)type2) ? null : ParaObjectUtils.toObject((App)app, (String)type2).getType();
                ParaObject pobj = ParaObjectUtils.toObject((App)app, (String)type);
                pobj.setId(id);
                pobj = Para.getDAO().read(app.getAppIdentifier(), pobj.getId());
                Pager pager = RestUtils.getPagerFromParams((MultivaluedMap<String, String>)params);
                String childrenOnly = (String)params.getFirst((Object)"childrenonly");
                if (pobj != null) {
                    if (Api1.POST.equals(ctx.getMethod()) || Api1.PUT.equals(ctx.getMethod())) {
                        return RestUtils.createLinksHandler(pobj, id2);
                    }
                    if (Api1.GET.equals(ctx.getMethod())) {
                        return RestUtils.readLinksHandler(pobj, id2, type2, (MultivaluedMap<String, String>)params, pager, childrenOnly != null);
                    }
                    if (Api1.DELETE.equals(ctx.getMethod())) {
                        return RestUtils.deleteLinksHandler(pobj, id2, type2, childrenOnly != null);
                    }
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "Object not found: " + id);
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> meHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                if (Api1.GET.equals(ctx.getMethod())) {
                    User user = SecurityUtils.getAuthenticatedUser();
                    App app = SecurityUtils.getAuthenticatedApp();
                    if (user != null) {
                        return Response.ok((Object)user).build();
                    }
                    if (app != null) {
                        String bearer = (String)ctx.getHeaders().getFirst((Object)"Authorization");
                        if (app.isRootApp() && StringUtils.startsWith((CharSequence)bearer, (CharSequence)"Bearer")) {
                            try {
                                App a;
                                String token = bearer.substring(6).trim();
                                SignedJWT jwt = SignedJWT.parse((String)token);
                                if (jwt != null && jwt.getJWTClaimsSet().getClaim("getCredentials") != null && (a = (App)Para.getDAO().read(App.id((String)((String)jwt.getJWTClaimsSet().getClaim("getCredentials"))))) != null) {
                                    Map obj = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue(ParaObjectUtils.toJSON((ParaObject)a));
                                    obj.put("credentials", a.getCredentials());
                                    return Response.ok((Object)obj).build();
                                }
                            }
                            catch (Exception ex) {
                                logger.error("Operation failed: {}", (Object)ex.getMessage());
                            }
                        }
                        return Response.ok((Object)app).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> readIdHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = SecurityUtils.getPrincipalApp();
                String id = RestUtils.pathParam("id", ctx);
                if (app != null) {
                    return RestUtils.getReadResponse(app, Para.getDAO().read(app.getAppIdentifier(), id));
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> configOptionsHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                String format = RestUtils.queryParam("format", ctx);
                String groupby = RestUtils.queryParam("groupby", ctx);
                String type = "text/plain";
                if ("markdown".equalsIgnoreCase(format)) {
                    type = "text/markdown";
                } else if ("hocon".equalsIgnoreCase(format)) {
                    type = "application/hocon";
                } else if (StringUtils.isBlank((CharSequence)format) || "json".equalsIgnoreCase(format)) {
                    type = Api1.JSON;
                }
                return Response.ok((Object)Para.getConfig().renderConfigDocumentation(format, StringUtils.isBlank((CharSequence)groupby) || "category".equalsIgnoreCase(groupby)), (String)type).build();
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> getConstrHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String type = RestUtils.pathParam("type", ctx);
                if (app != null) {
                    if (type != null) {
                        return Response.ok((Object)app.getAllValidationConstraints(new String[]{type})).build();
                    }
                    return Response.ok((Object)app.getAllValidationConstraints(new String[0])).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> addConstrHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String type = RestUtils.pathParam("type", ctx);
                String field = RestUtils.pathParam("field", ctx);
                String cname = RestUtils.pathParam("cname", ctx);
                if (app != null) {
                    Map payload;
                    Response payloadRes = RestUtils.getEntity(ctx.getEntityStream(), Map.class);
                    if (payloadRes.getStatusInfo() == Response.Status.OK && app.addValidationConstraint(type, field, Constraint.build((String)cname, (Map)(payload = (Map)payloadRes.getEntity())))) {
                        app.update();
                    }
                    return Response.ok((Object)app.getAllValidationConstraints(new String[]{type})).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> removeConstrHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String type = RestUtils.pathParam("type", ctx);
                String field = RestUtils.pathParam("field", ctx);
                String cname = RestUtils.pathParam("cname", ctx);
                if (app != null) {
                    if (app.removeValidationConstraint(type, field, cname)) {
                        app.update();
                    }
                    return Response.ok((Object)app.getAllValidationConstraints(new String[]{type})).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> getPermitHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String subjectid = RestUtils.pathParam("subjectid", ctx);
                if (app != null) {
                    if (subjectid != null) {
                        return Response.ok((Object)app.getAllResourcePermissions(new String[]{subjectid})).build();
                    }
                    return Response.ok((Object)app.getAllResourcePermissions(new String[0])).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> checkPermitHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String subjectid = RestUtils.pathParam("subjectid", ctx);
                String resourcePath = Utils.base64dec((String)RestUtils.pathParam("type", ctx));
                String httpMethod = RestUtils.pathParam("method", ctx);
                if (app != null) {
                    return Response.ok((Object)app.isAllowedTo(subjectid, resourcePath, httpMethod), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> grantPermitHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String subjectid = RestUtils.pathParam("subjectid", ctx);
                String resourcePath = Utils.base64dec((String)RestUtils.pathParam("type", ctx));
                if (app != null) {
                    Response resp = RestUtils.getEntity(ctx.getEntityStream(), List.class);
                    if (resp.getStatusInfo() == Response.Status.OK) {
                        List permission = (List)resp.getEntity();
                        HashSet<App.AllowedMethods> set = new HashSet<App.AllowedMethods>(permission.size());
                        for (String perm : permission) {
                            App.AllowedMethods method;
                            if (StringUtils.isBlank((CharSequence)perm) || (method = App.AllowedMethods.fromString((String)perm)) == null) continue;
                            set.add(method);
                        }
                        if (!set.isEmpty()) {
                            if (app.grantResourcePermission(subjectid, resourcePath, EnumSet.copyOf(set))) {
                                app.update();
                            }
                            return Response.ok((Object)app.getAllResourcePermissions(new String[]{subjectid})).build();
                        }
                        return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "No allowed methods specified.");
                    }
                    return resp;
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> revokePermitHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String subjectid = RestUtils.pathParam("subjectid", ctx);
                String resourcePath = Utils.base64dec((String)RestUtils.pathParam("type", ctx));
                if (app != null) {
                    boolean revoked = !StringUtils.isBlank((CharSequence)resourcePath) ? app.revokeResourcePermission(subjectid, resourcePath) : app.revokeAllResourcePermissions(subjectid);
                    if (revoked) {
                        app.update();
                    }
                    return Response.ok((Object)app.getAllResourcePermissions(new String[]{subjectid})).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> appSettingsHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                String key = RestUtils.pathParam("key", ctx);
                if (app != null) {
                    if (Api1.PUT.equals(ctx.getMethod())) {
                        Response resp = RestUtils.getEntity(ctx.getEntityStream(), Map.class);
                        if (resp.getStatusInfo() == Response.Status.OK) {
                            Map setting = (Map)resp.getEntity();
                            if (!StringUtils.isBlank((CharSequence)key) && setting.containsKey("value")) {
                                app.addSetting(key, setting.get("value"));
                            } else {
                                app.clearSettings().addAllSettings(setting);
                            }
                            app.update();
                            return Response.ok().build();
                        }
                        return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, new String[0]);
                    }
                    if (Api1.DELETE.equals(ctx.getMethod())) {
                        app.removeSetting(key);
                        app.update();
                        return Response.ok().build();
                    }
                    if (StringUtils.isBlank((CharSequence)key)) {
                        return Response.ok((Object)app.getSettings()).build();
                    }
                    return Response.ok(Collections.singletonMap("value", app.getSetting(key))).build();
                }
                return RestUtils.getStatusResponse(Response.Status.FORBIDDEN, "Not allowed.");
            }
        };
    }

    private static Inflector<ContainerRequestContext, Response> healthCheckHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                if (HealthUtils.getInstance().isHealthy()) {
                    return Response.ok(Collections.singletonMap("message", "healthy")).build();
                }
                return RestUtils.getStatusResponse(Response.Status.INTERNAL_SERVER_ERROR, "unhealthy");
            }
        };
    }

    private Inflector<ContainerRequestContext, Response> listTypesHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                App app = SecurityUtils.getPrincipalApp();
                if (app != null) {
                    Map types = ParaObjectUtils.getAllTypes((App)app);
                    if ("true".equalsIgnoreCase(RestUtils.queryParam("count", ctx))) {
                        HashMap typesCount = new HashMap(types.size());
                        types.values().forEach(v -> typesCount.put(v, Para.getSearch().getCount(app.getAppIdentifier(), v)));
                        return Response.ok(typesCount).build();
                    }
                    return Response.ok((Object)types).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    private Inflector<ContainerRequestContext, Response> keysHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                App app = SecurityUtils.getAuthenticatedApp();
                if (app != null) {
                    app.resetSecret();
                    CoreUtils.getInstance().overwrite((ParaObject)app);
                    Map creds = app.getCredentials();
                    creds.put("info", "Save the secret key! It is showed only once!");
                    return Response.ok((Object)creds).build();
                }
                return RestUtils.getStatusResponse(Response.Status.UNAUTHORIZED, "Not an app.");
            }
        };
    }

    private Inflector<ContainerRequestContext, Response> setupHandler() {
        return new Inflector<ContainerRequestContext, Response>(this){

            public Response apply(ContainerRequestContext ctx) {
                String appid = RestUtils.pathParam("appid", ctx);
                if (!StringUtils.isBlank((CharSequence)appid)) {
                    App app = SecurityUtils.getAuthenticatedApp();
                    if (app != null && app.isRootApp()) {
                        boolean sharedIndex = "true".equals(RestUtils.queryParam("sharedIndex", ctx));
                        boolean sharedTable = "true".equals(RestUtils.queryParam("sharedTable", ctx));
                        return Response.ok((Object)Para.newApp((String)appid, (String)RestUtils.queryParam("name", ctx), (String)RestUtils.queryParam("creatorid", ctx), (boolean)sharedIndex, (boolean)sharedTable)).build();
                    }
                    return RestUtils.getStatusResponse(Response.Status.FORBIDDEN, "Only root app can create and initialize other apps.");
                }
                return Response.ok((Object)Para.setup()).build();
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> createHandler(final App a, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                return RestUtils.getCreateResponse(app, type, ctx.getEntityStream());
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> readHandler(final App a, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                ParaObject obj = ParaObjectUtils.toObject((App)app, (String)type);
                obj.setId(RestUtils.pathParam("id", ctx));
                if (app.getId().equals(obj.getId())) {
                    return RestUtils.getReadResponse(app, (ParaObject)app);
                }
                return RestUtils.getReadResponse(app, Para.getDAO().read(app.getAppIdentifier(), obj.getId()));
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> updateHandler(final App a, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                ParaObject obj = ParaObjectUtils.toObject((App)app, (String)type);
                obj.setId(RestUtils.pathParam("id", ctx));
                String appid = StringUtils.equals((CharSequence)type, (CharSequence)Utils.type(App.class)) ? app.getAppid() : app.getAppIdentifier();
                return RestUtils.getUpdateResponse(app, Para.getDAO().read(appid, obj.getId()), ctx.getEntityStream());
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> overwriteHandler(final App a, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                return RestUtils.getOverwriteResponse(app, RestUtils.pathParam("id", ctx), type, ctx.getEntityStream());
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> deleteHandler(final App a, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                ParaObject obj = ParaObjectUtils.toObject((App)app, (String)type);
                obj.setId(RestUtils.pathParam("id", ctx));
                return RestUtils.getDeleteResponse(app, obj);
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> batchCreateHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                return RestUtils.getBatchCreateResponse(app, ctx.getEntityStream());
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> batchReadHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                return RestUtils.getBatchReadResponse(app, RestUtils.queryParams("ids", ctx));
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> batchUpdateHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                Response entityRes = RestUtils.getEntity(ctx.getEntityStream(), List.class, true);
                if (entityRes.getStatusInfo() == Response.Status.OK) {
                    List newProps = (List)entityRes.getEntity();
                    ArrayList<String> ids = new ArrayList<String>(newProps.size());
                    for (Map props : newProps) {
                        if (props == null || !props.containsKey("id")) continue;
                        ids.add((String)props.get("id"));
                    }
                    return RestUtils.getBatchUpdateResponse(app, Para.getDAO().readAll(app.getAppIdentifier(), ids, true), newProps);
                }
                return entityRes;
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> batchDeleteHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = a != null ? a : SecurityUtils.getPrincipalApp();
                return RestUtils.getBatchDeleteResponse(app, RestUtils.queryParams("ids", ctx));
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> searchHandler(final App app, final String type) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app1 = app == null ? SecurityUtils.getPrincipalApp() : app;
                MultivaluedMap params = ctx.getUriInfo().getQueryParameters();
                String query = (String)params.getFirst((Object)"q");
                if (!StringUtils.isBlank((CharSequence)query) && !Para.getSearch().isValidQueryString(query)) {
                    return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Invalid query string syntax q=" + query + " in request " + ctx.getMethod() + " " + String.valueOf(ctx.getUriInfo().getRequestUri()));
                }
                String queryType = RestUtils.pathParam("querytype", ctx);
                if (StringUtils.isBlank((CharSequence)queryType)) {
                    queryType = "default";
                }
                return Response.ok(RestUtils.buildQueryAndSearch(app1, queryType, (MultivaluedMap<String, String>)params, type)).build();
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> reindexHandler() {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app = SecurityUtils.getPrincipalApp();
                if (app != null) {
                    long startTime = System.nanoTime();
                    MultivaluedMap params = ctx.getUriInfo().getQueryParameters();
                    Pager pager = RestUtils.getPagerFromParams((MultivaluedMap<String, String>)params);
                    String destinationIndex = (String)params.getFirst((Object)"destinationIndex");
                    try (Metrics.Context context = Metrics.time((String)app.getAppIdentifier(), Api1.class, (String[])new String[]{"rebuildIndex"});){
                        Para.getSearch().rebuildIndex(Para.getDAO(), app, destinationIndex, new Pager[]{pager});
                    }
                    long tookMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                    HashMap<String, Long> response = new HashMap<String, Long>(2);
                    response.put("reindexed", pager.getCount());
                    response.put("tookMillis", tookMillis);
                    return Response.ok(response, (String)Api1.JSON).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> backupHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app;
                App app2 = app = a != null ? a : SecurityUtils.getPrincipalApp();
                if (app != null) {
                    final String fileName = app.getAppIdentifier().trim() + "_" + Utils.formatDate((String)"YYYYMMdd_HHmmss", (Locale)Locale.US);
                    StreamingOutput stream = new StreamingOutput(){

                        public void write(OutputStream os) throws IOException, WebApplicationException {
                            ObjectWriter writer = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS})).build()).writer().without(SerializationFeature.INDENT_OUTPUT).without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                            try (ZipOutputStream zipOut = new ZipOutputStream(os);){
                                List objects;
                                long count = 0L;
                                int partNum = 0;
                                Pager pager = new Pager();
                                do {
                                    objects = Para.getDAO().readPage(app.getAppIdentifier(), pager);
                                    ZipEntry zipEntry = new ZipEntry(fileName + "_part" + ++partNum + ".json");
                                    zipOut.putNextEntry(zipEntry);
                                    writer.writeValue((OutputStream)zipOut, (Object)objects);
                                    count += (long)objects.size();
                                } while (!objects.isEmpty());
                                logger.info("Exported {} objects from app '{}'. (pager.count={})", new Object[]{count, app.getId(), pager.getCount()});
                            }
                            catch (IOException e) {
                                logger.error("Failed to export data.", (Throwable)e);
                            }
                        }
                    };
                    return Response.ok((Object)stream, (String)"application/zip").header("Content-Disposition", (Object)("attachment;filename=" + fileName + ".zip")).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }

    public static Inflector<ContainerRequestContext, Response> restoreHandler(final App a) {
        return new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext ctx) {
                App app;
                App app2 = app = a != null ? a : SecurityUtils.getPrincipalApp();
                if (app != null) {
                    ObjectReader reader = ParaObjectUtils.getJsonMapper().readerFor((TypeReference)new TypeReference<List<Map<String, Object>>>(this){});
                    int count = 0;
                    int importBatchSize = Para.getConfig().importBatchSize();
                    String filename = Optional.ofNullable((String)ctx.getUriInfo().getQueryParameters().getFirst((Object)"filename")).orElse(app.getAppIdentifier().trim() + "_backup.zip");
                    Sysprop s = new Sysprop();
                    s.setType("paraimport");
                    try (InputStream inputStream = ctx.getEntityStream();){
                        try (final ZipInputStream zipIn = new ZipInputStream(inputStream);){
                            ZipEntry zipEntry;
                            LinkedList toCreate = new LinkedList();
                            while ((zipEntry = zipIn.getNextEntry()) != null) {
                                if (!zipEntry.getName().endsWith(".json")) continue;
                                List objects = (List)reader.readValue((InputStream)new FilterInputStream(this, zipIn){

                                    @Override
                                    public void close() throws IOException {
                                        zipIn.closeEntry();
                                    }
                                });
                                objects.forEach(o -> toCreate.add(ParaObjectUtils.setAnnotatedFields((Map)o)));
                                if (toCreate.size() >= importBatchSize) {
                                    Para.getDAO().createAll(app.getAppIdentifier(), toCreate);
                                    toCreate.clear();
                                }
                                count += objects.size();
                            }
                            if (!toCreate.isEmpty()) {
                                Para.getDAO().createAll(app.getAppIdentifier(), toCreate);
                            }
                        }
                        s.setCreatorid(app.getAppIdentifier());
                        s.setName(filename);
                        s.addProperty("count", (Object)count);
                        logger.info("Imported {} objects to app '{}'", (Object)count, (Object)app.getId());
                        if (count > 0) {
                            Para.getDAO().create(app.getAppIdentifier(), (ParaObject)s);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Failed to import " + filename, (Throwable)e);
                        return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Import failed - " + e.getMessage());
                    }
                    return Response.ok((Object)s).build();
                }
                return RestUtils.getStatusResponse(Response.Status.NOT_FOUND, "App not found.");
            }
        };
    }
}

