/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.queue;

import com.erudika.para.core.queue.Queue;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.queue.AWSQueue;
import com.erudika.para.server.queue.LocalQueue;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class QueueModule
extends AbstractModule {
    protected void configure() {
        String selectedQueue = Para.getConfig().queuePlugin();
        if (StringUtils.isBlank((CharSequence)selectedQueue)) {
            this.bindToDefault();
        } else if ("sqs".equalsIgnoreCase(selectedQueue) || AWSQueue.class.getSimpleName().equalsIgnoreCase(selectedQueue)) {
            this.bind(Queue.class).to(AWSQueue.class).asEagerSingleton();
        } else {
            Queue queuePlugin = this.loadExternalQueue(selectedQueue);
            if (queuePlugin != null) {
                this.bind(Queue.class).to(queuePlugin.getClass()).asEagerSingleton();
            } else {
                this.bindToDefault();
            }
        }
    }

    void bindToDefault() {
        this.bind(Queue.class).to(LocalQueue.class).asEagerSingleton();
    }

    final Queue loadExternalQueue(String classSimpleName) {
        ServiceLoader<Queue> queueLoader = ServiceLoader.load(Queue.class, Para.getParaClassLoader());
        for (Queue queue : queueLoader) {
            if (queue == null || !classSimpleName.equalsIgnoreCase(queue.getClass().getSimpleName())) continue;
            return queue;
        }
        return null;
    }
}

