/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.email;

import com.erudika.para.core.email.Emailer;
import com.erudika.para.core.utils.Para;
import jakarta.activation.DataSource;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class JavaMailEmailer
implements Emailer {
    private static final Logger logger = LoggerFactory.getLogger(JavaMailEmailer.class);
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(Para.getConfig().executorThreads());
    private final JavaMailSender mailSender;

    public JavaMailEmailer() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(System.getProperty("spring.mail.host"));
        sender.setPort(NumberUtils.toInt((String)System.getProperty("spring.mail.port"), (int)965));
        sender.setUsername(System.getProperty("spring.mail.username"));
        sender.setPassword(System.getProperty("spring.mail.password"));
        Properties props = sender.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", System.getProperty("spring.mail.properties.mail.smtp.starttls.enable", "true"));
        props.put("mail.smtp.ssl.enable", System.getProperty("spring.mail.properties.mail.smtp.ssl.enable", "true"));
        props.put("mail.debug", System.getProperty("spring.mail.properties.mail.debug", "false"));
        this.mailSender = sender;
    }

    public boolean sendEmail(List<String> emails, String subject, String body) {
        return this.sendEmail(emails, subject, body, null, null, null);
    }

    public boolean sendEmail(final List<String> emails, final String subject, final String body, final InputStream attachment, final String mimeType, final String fileName) {
        if (emails == null || emails.isEmpty()) {
            return false;
        }
        this.asyncExecute(new Runnable(){
            final /* synthetic */ JavaMailEmailer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                MimeMessagePreparator preparator = new MimeMessagePreparator(){

                    public void prepare(MimeMessage mimeMessage) throws Exception {
                        MimeMessageHelper msg = new MimeMessageHelper(mimeMessage);
                        Iterator emailz = emails.iterator();
                        msg.setTo((String)emailz.next());
                        while (emailz.hasNext()) {
                            msg.addBcc((String)emailz.next());
                        }
                        msg.setSubject(subject);
                        msg.setFrom(Para.getConfig().supportEmail());
                        msg.setText(body, true);
                        if (attachment != null) {
                            msg.addAttachment(fileName, (DataSource)new ByteArrayDataSource(attachment, mimeType));
                        }
                    }
                };
                try {
                    this.this$0.mailSender.send(preparator);
                    logger.debug("Email sent to {}, {}", (Object)emails, (Object)subject);
                }
                catch (MailException ex) {
                    logger.error("Failed to send email. {}", (Object)ex.getMessage());
                }
            }
        });
        return true;
    }

    private void asyncExecute(Runnable runnable) {
        if (runnable != null) {
            try {
                EXECUTOR.execute(runnable);
            }
            catch (RejectedExecutionException ex) {
                logger.warn(ex.getMessage());
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }
}

