/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.email;

import com.erudika.para.core.email.Emailer;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.email.AWSEmailer;
import com.erudika.para.server.email.JavaMailEmailer;
import com.erudika.para.server.email.NoopEmailer;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class EmailModule
extends AbstractModule {
    protected void configure() {
        String selectedEmailer = Para.getConfig().emailerPlugin();
        if (StringUtils.isBlank((CharSequence)selectedEmailer)) {
            this.bindToDefault();
        } else if ("aws".equalsIgnoreCase(selectedEmailer) || AWSEmailer.class.getSimpleName().equalsIgnoreCase(selectedEmailer)) {
            this.bind(Emailer.class).to(AWSEmailer.class).asEagerSingleton();
        } else if ("javamail".equalsIgnoreCase(selectedEmailer) || JavaMailEmailer.class.getSimpleName().equalsIgnoreCase(selectedEmailer)) {
            this.bind(Emailer.class).to(JavaMailEmailer.class).asEagerSingleton();
        } else {
            Emailer emailerPlugin = this.loadExternalFileStore(selectedEmailer);
            if (emailerPlugin != null) {
                this.bind(Emailer.class).to(emailerPlugin.getClass()).asEagerSingleton();
            } else {
                this.bindToDefault();
            }
        }
    }

    void bindToDefault() {
        this.bind(Emailer.class).to(NoopEmailer.class).asEagerSingleton();
    }

    final Emailer loadExternalFileStore(String classSimpleName) {
        ServiceLoader<Emailer> fsLoader = ServiceLoader.load(Emailer.class, Para.getParaClassLoader());
        for (Emailer fs : fsLoader) {
            if (fs == null || !classSimpleName.equalsIgnoreCase(fs.getClass().getSimpleName())) continue;
            return fs;
        }
        return null;
    }
}

