/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.cache;

import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CaffeineCache
implements com.erudika.para.core.cache.Cache {
    private static final Logger logger = LoggerFactory.getLogger(CaffeineCache.class);
    private static final int DEFAULT_EXPIRATION_MIN = Para.getConfig().caffeineEvictAfterMin();
    private final Cache<String, Object> cache;

    public CaffeineCache() {
        this.cache = Caffeine.newBuilder().maximumSize(Para.getConfig().caffeineCacheSize()).expireAfter((Expiry)new Expiry<String, Object>(this){

            public long expireAfterCreate(String key, Object value, long currentTime) {
                return TimeUnit.MINUTES.toNanos(DEFAULT_EXPIRATION_MIN);
            }

            public long expireAfterUpdate(String key, Object value, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(String key, Object value, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).build();
    }

    CaffeineCache(Cache<String, Object> cache) {
        this.cache = cache;
    }

    public boolean contains(String appid, String id) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        boolean exists = this.get(appid, id) != null;
        logger.debug("Cache.contains({}) {}", (Object)id, (Object)exists);
        return exists;
    }

    public <T> void put(String appid, String id, T object) {
        if (!StringUtils.isBlank((CharSequence)id) && object != null && !StringUtils.isBlank((CharSequence)appid)) {
            this.cache.put((Object)this.key(appid, id), object);
            logger.debug("Cache.put() {} {}", (Object)appid, (Object)id);
        }
    }

    public <T> void put(String appid, String id, T object, Long ttlSeconds) {
        if (ttlSeconds == null || ttlSeconds <= 0L) {
            this.put(appid, id, object);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)id) && object != null && !StringUtils.isBlank((CharSequence)appid)) {
            String key = this.key(appid, id);
            this.cache.policy().expireVariably().ifPresent(t -> t.put((Object)key, object, ttlSeconds.longValue(), TimeUnit.SECONDS));
            logger.debug("Cache.put() {} {} ttl {}", new Object[]{appid, id, ttlSeconds});
        }
    }

    public <T> void putAll(String appid, Map<String, T> objects) {
        if (objects != null && !objects.isEmpty() && !StringUtils.isBlank((CharSequence)appid)) {
            LinkedHashMap<String, T> cleanMap = new LinkedHashMap<String, T>(objects.size());
            for (Map.Entry<String, T> entry : objects.entrySet()) {
                if (StringUtils.isBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                cleanMap.put(this.key(appid, entry.getKey()), entry.getValue());
            }
            this.cache.putAll(cleanMap);
            logger.debug("Cache.putAll() {} {}", (Object)appid, (Object)objects.size());
        }
    }

    public <T> T get(String appid, String id) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)appid)) {
            return null;
        }
        String key = this.key(appid, id);
        logger.debug("Cache.get() {} {}", (Object)appid, (Object)id);
        return (T)this.cache.getIfPresent((Object)key);
    }

    public <T> Map<String, T> getAll(String appid, List<String> ids) {
        if (ids == null || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, T> map1 = new LinkedHashMap<String, T>(ids.size());
        ids.remove(null);
        for (String id : ids) {
            T t = this.get(appid, id);
            if (t == null) continue;
            map1.put(id, t);
        }
        logger.debug("Cache.getAll() {} {}", (Object)appid, (Object)ids.size());
        return map1;
    }

    public void remove(String appid, String id) {
        if (!StringUtils.isBlank((CharSequence)id) && !StringUtils.isBlank((CharSequence)appid)) {
            logger.debug("Cache.remove() {} {}", (Object)appid, (Object)id);
            this.cache.invalidate((Object)this.key(appid, id));
        }
    }

    public void removeAll(String appid) {
        if (!StringUtils.isBlank((CharSequence)appid)) {
            logger.debug("Cache.removeAll() {}", (Object)appid);
            this.cache.asMap().remove("key_prefix_" + appid);
        }
    }

    public void removeAll(String appid, List<String> ids) {
        if (ids != null && !StringUtils.isBlank((CharSequence)appid)) {
            for (String id : ids) {
                if (StringUtils.isBlank((CharSequence)id)) continue;
                this.remove(appid, id);
            }
            logger.debug("Cache.removeAll() {} {}", (Object)appid, (Object)ids.size());
        }
    }

    private String key(String appid, String id) {
        return String.valueOf(this.cache.asMap().computeIfAbsent("key_prefix_" + appid, k -> Utils.getNewId())) + "_" + id;
    }

    public boolean contains(String id) {
        return this.contains(Para.getConfig().getRootAppIdentifier(), id);
    }

    public <T> void put(String id, T object) {
        this.put(Para.getConfig().getRootAppIdentifier(), id, object);
    }

    public <T> void putAll(Map<String, T> objects) {
        this.putAll(Para.getConfig().getRootAppIdentifier(), objects);
    }

    public <T> T get(String id) {
        return this.get(Para.getConfig().getRootAppIdentifier(), id);
    }

    public <T> Map<String, T> getAll(List<String> ids) {
        return this.getAll(Para.getConfig().getRootAppIdentifier(), ids);
    }

    public void remove(String id) {
        this.remove(Para.getConfig().getRootAppIdentifier(), id);
    }

    public void removeAll() {
        this.removeAll(Para.getConfig().getRootAppIdentifier());
    }

    public void removeAll(List<String> ids) {
        this.removeAll(Para.getConfig().getRootAppIdentifier(), ids);
    }
}

