/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils.filters;

import com.erudika.para.server.utils.GZipResponseUtil;
import com.erudika.para.server.utils.GZipServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipServletFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(GZipServletFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!this.isIncluded(httpRequest) && this.acceptsGZipEncoding(httpRequest) && !response.isCommitted()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} Written with gzip compression", (Object)httpRequest.getRequestURL());
            }
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(compressed);
            GZipServletResponseWrapper wrapper = new GZipServletResponseWrapper(httpResponse, gzout);
            wrapper.setDisableFlushBuffer(true);
            chain.doFilter(request, (ServletResponse)wrapper);
            wrapper.flush();
            gzout.close();
            if (response.isCommitted()) {
                return;
            }
            switch (wrapper.getStatus()) {
                case 204: 
                case 205: 
                case 304: {
                    return;
                }
            }
            byte[] compressedBytes = compressed.toByteArray();
            boolean shouldGzippedBodyBeZero = GZipResponseUtil.shouldGzippedBodyBeZero(compressedBytes, httpRequest);
            boolean shouldBodyBeZero = GZipResponseUtil.shouldBodyBeZero(httpRequest, wrapper.getStatus());
            if (shouldGzippedBodyBeZero || shouldBodyBeZero) {
                response.setContentLength(0);
                return;
            }
            GZipResponseUtil.addGzipHeader(httpResponse);
            GZipResponseUtil.addVaryAcceptEncoding(wrapper);
            response.setContentLength(compressedBytes.length);
            response.getOutputStream().write(compressedBytes);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} Written without gzip compression because the request does not accept gzip", (Object)httpRequest.getRequestURL());
            }
            chain.doFilter(request, response);
        }
    }

    private boolean isIncluded(HttpServletRequest request) {
        boolean includeRequest;
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        boolean bl = includeRequest = uri != null;
        if (includeRequest && this.log.isDebugEnabled()) {
            this.log.debug("{} resulted in an include request. This is unusable, becausethe response will be assembled into the overrall response. Not gzipping.", (Object)request.getRequestURL());
        }
        return includeRequest;
    }

    private boolean acceptsGZipEncoding(HttpServletRequest httpRequest) {
        String acceptEncoding = httpRequest.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }
}

