/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils.filters;

import com.erudika.para.core.ParaObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

@Provider
public class FieldFilter
implements ContainerResponseFilter {
    @Context
    private HttpServletRequest request;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        try {
            if (responseContext.getEntity() != null && !StringUtils.isBlank((CharSequence)this.request.getParameter("select"))) {
                String[] sarr = StringUtils.split((String)this.request.getParameter("select"), (String)",");
                ArrayList<String> fields = sarr == null ? new ArrayList(0) : Arrays.asList(sarr);
                Object entity = responseContext.getEntity();
                Object newEntity = null;
                if (entity instanceof ParaObject) {
                    newEntity = this.getFilteredProperties(entity, fields);
                } else if (entity instanceof Map) {
                    if (((Map)entity).containsKey("items")) {
                        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
                        for (ParaObject item : (List)((Map)entity).get("items")) {
                            items.add(this.getFilteredProperties(item, fields));
                        }
                        ((Map)entity).put("items", items);
                        newEntity = entity;
                    }
                } else if (entity instanceof List) {
                    newEntity = new ArrayList();
                    if (!((List)entity).isEmpty() && ((List)entity).get(0) instanceof ParaObject) {
                        for (ParaObject item : (List)entity) {
                            ((List)newEntity).add(this.getFilteredProperties(item, fields));
                        }
                    }
                }
                if (newEntity != null) {
                    responseContext.setEntity(newEntity);
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Failed to limit returned fields using ?select=:", (Throwable)e);
        }
    }

    private Map<String, Object> getFilteredProperties(Object object, List<String> fields) {
        HashMap<String, Object> newItem = new HashMap<String, Object>();
        for (String f : fields) {
            String field = StringUtils.trimToEmpty((String)f);
            newItem.put(field, this.getProperty(object, field));
        }
        return newItem;
    }

    private Object getProperty(Object obj, String prop) {
        if (obj != null && !StringUtils.isBlank((CharSequence)prop)) {
            try {
                Method m = PropertyUtils.getReadMethod((PropertyDescriptor)new PropertyDescriptor(prop, obj.getClass()));
                if (m != null && !m.isAnnotationPresent(JsonIgnore.class)) {
                    return PropertyUtils.getProperty((Object)obj, (String)prop);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

