/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils.filters;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class CORSFilter
implements Filter {
    private FilterConfig filterConfig;
    private final Collection<String> allowedOrigins = new HashSet<String>();
    private boolean anyOriginAllowed;
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean loggingEnabled;
    private boolean decorateRequest;
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String REQUEST_HEADER_ORIGIN = "Origin";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String HTTP_REQUEST_ATTRIBUTE_PREFIX = "cors.";
    public static final String HTTP_REQUEST_ATTRIBUTE_ORIGIN = "cors.request.origin";
    public static final String HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST = "cors.isCorsRequest";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE = "cors.request.type";
    public static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS = "cors.request.headers";
    public static final Collection<String> HTTP_METHODS = new HashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "TRACE", "CONNECT"));
    public static final Collection<String> COMPLEX_HTTP_METHODS = new HashSet<String>(Arrays.asList("PUT", "PATCH", "DELETE", "TRACE", "CONNECT"));
    public static final Collection<String> SIMPLE_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "HEAD"));
    public static final Collection<String> SIMPLE_HTTP_REQUEST_HEADERS = new HashSet<String>(Arrays.asList("Accept", "Accept-Language", "Content-Language"));
    public static final Collection<String> SIMPLE_HTTP_RESPONSE_HEADERS = new HashSet<String>(Arrays.asList("Cache-Control", "Content-Language", "Content-Type", "Expires", "Last-Modified", "Pragma"));
    public static final Collection<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain"));
    public static final String DEFAULT_ALLOWED_ORIGINS = "*";
    public static final String DEFAULT_ALLOWED_HTTP_METHODS = "GET,POST,HEAD,OPTIONS";
    public static final String DEFAULT_PREFLIGHT_MAXAGE = "1800";
    public static final String DEFAULT_SUPPORTS_CREDENTIALS = "true";
    public static final String DEFAULT_ALLOWED_HTTP_HEADERS = "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers";
    public static final String DEFAULT_EXPOSED_HEADERS = "";
    public static final String DEFAULT_LOGGING_ENABLED = "false";
    public static final String DEFAULT_DECORATE_REQUEST = "true";
    public static final String PARAM_CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    public static final String PARAM_CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    public static final String PARAM_CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    public static final String PARAM_CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    public static final String PARAM_CORS_ALLOWED_METHODS = "cors.allowed.methods";
    public static final String PARAM_CORS_PREFLIGHT_MAXAGE = "cors.preflight.maxage";
    public static final String PARAM_CORS_LOGGING_ENABLED = "cors.logging.enabled";
    public static final String PARAM_CORS_REQUEST_DECORATE = "cors.request.decorate";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            String message = "CORS doesn't support non-HTTP request or response.";
            throw new ServletException(message);
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        CORSRequestType requestType = this.checkRequestType(request);
        if (this.decorateRequest) {
            CORSFilter.decorateCORSProperties(request, requestType);
        }
        switch (requestType) {
            case SIMPLE: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case ACTUAL: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case PRE_FLIGHT: {
                this.handlePreflightCORS(request, response, filterChain);
                break;
            }
            case NOT_CORS: {
                this.handleNonCORS(request, response, filterChain);
                break;
            }
            default: {
                this.handleInvalidCORS(request, response, filterChain);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.parseAndStore(DEFAULT_ALLOWED_ORIGINS, DEFAULT_ALLOWED_HTTP_METHODS, DEFAULT_ALLOWED_HTTP_HEADERS, DEFAULT_EXPOSED_HEADERS, "true", DEFAULT_PREFLIGHT_MAXAGE, DEFAULT_LOGGING_ENABLED, "true");
        this.filterConfig = filterConfig;
        this.loggingEnabled = false;
        if (filterConfig != null) {
            String configAllowedOrigins = filterConfig.getInitParameter(PARAM_CORS_ALLOWED_ORIGINS);
            String configAllowedHttpMethods = filterConfig.getInitParameter(PARAM_CORS_ALLOWED_METHODS);
            String configAllowedHttpHeaders = filterConfig.getInitParameter(PARAM_CORS_ALLOWED_HEADERS);
            String configExposedHeaders = filterConfig.getInitParameter(PARAM_CORS_EXPOSED_HEADERS);
            String configSupportsCredentials = filterConfig.getInitParameter(PARAM_CORS_SUPPORT_CREDENTIALS);
            String configPreflightMaxAge = filterConfig.getInitParameter(PARAM_CORS_PREFLIGHT_MAXAGE);
            String configLoggingEnabled = filterConfig.getInitParameter(PARAM_CORS_LOGGING_ENABLED);
            String configDecorateRequest = filterConfig.getInitParameter(PARAM_CORS_REQUEST_DECORATE);
            this.parseAndStore(configAllowedOrigins, configAllowedHttpMethods, configAllowedHttpHeaders, configExposedHeaders, configSupportsCredentials, configPreflightMaxAge, configLoggingEnabled, configDecorateRequest);
        }
    }

    public void handleSimpleCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.SIMPLE && requestType != CORSRequestType.ACTUAL) {
            String message = "Expects a HttpServletRequest object of type " + CORSRequestType.SIMPLE + " or " + CORSRequestType.ACTUAL;
            throw new IllegalArgumentException(message);
        }
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        if (!this.isOriginAllowed(origin)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (!this.allowedHttpMethods.contains(method)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (this.anyOriginAllowed && !this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, DEFAULT_ALLOWED_ORIGINS);
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (this.exposedHeaders != null && !this.exposedHeaders.isEmpty()) {
            String exposedHeadersString = CORSFilter.join(this.exposedHeaders, ",");
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, exposedHeadersString);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void handlePreflightCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException("Expects a HttpServletRequest object of type " + CORSRequestType.PRE_FLIGHT.name().toLowerCase());
        }
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (!this.isOriginAllowed(origin)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        String accessControlRequestMethod = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (accessControlRequestMethod == null || !HTTP_METHODS.contains(accessControlRequestMethod.trim())) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        accessControlRequestMethod = accessControlRequestMethod.trim();
        String accessControlRequestHeadersHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        LinkedList<String> accessControlRequestHeaders = new LinkedList<String>();
        if (StringUtils.isNotBlank((CharSequence)accessControlRequestHeadersHeader)) {
            String[] headers;
            for (String header : headers = accessControlRequestHeadersHeader.trim().split(",")) {
                accessControlRequestHeaders.add(header.trim().toLowerCase());
            }
        }
        if (!this.allowedHttpMethods.contains(accessControlRequestMethod)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        for (String header : accessControlRequestHeaders) {
            if (this.allowedHttpHeaders.contains(header)) continue;
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else if (this.anyOriginAllowed) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, DEFAULT_ALLOWED_ORIGINS);
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.preflightMaxAge > 0L) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(this.preflightMaxAge));
        }
        response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, accessControlRequestMethod);
        if (this.allowedHttpHeaders != null && !this.allowedHttpHeaders.isEmpty()) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CORSFilter.join(this.allowedHttpHeaders, ","));
        }
    }

    public void handleNonCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void handleInvalidCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        String accessControlRequestHeaders = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        String message = "Invalid CORS request; Origin=" + origin + ";Method=" + method;
        if (accessControlRequestHeaders != null) {
            message = message + ";Access-Control-Request-Headers=" + accessControlRequestHeaders;
        }
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
        this.log(message);
    }

    public void destroy() {
    }

    public static void decorateCORSProperties(HttpServletRequest request, CORSRequestType corsRequestType) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        if (corsRequestType == null) {
            throw new IllegalArgumentException("CORSRequestType object is null");
        }
        switch (corsRequestType) {
            case SIMPLE: 
            case ACTUAL: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)true);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase());
                break;
            }
            case PRE_FLIGHT: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)true);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase());
                String headers = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
                if (headers == null) {
                    headers = DEFAULT_EXPOSED_HEADERS;
                }
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS, (Object)headers);
                break;
            }
            case NOT_CORS: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)false);
                break;
            }
        }
    }

    public static String join(Collection<String> elements, String joinSeparator) {
        String separator = ",";
        if (elements == null) {
            return null;
        }
        if (joinSeparator != null) {
            separator = joinSeparator;
        }
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (String element : elements) {
            if (!isFirst) {
                buffer.append(separator);
            } else {
                isFirst = false;
            }
            if (element == null) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    public CORSRequestType checkRequestType(HttpServletRequest request) {
        CORSRequestType requestType = CORSRequestType.INVALID_CORS;
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        String originHeader = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (originHeader != null) {
            if (originHeader.isEmpty()) {
                requestType = CORSRequestType.INVALID_CORS;
            } else if (!CORSFilter.isValidOrigin(originHeader)) {
                requestType = CORSRequestType.INVALID_CORS;
            } else {
                String method = StringUtils.trimToEmpty((String)request.getMethod());
                if (HTTP_METHODS.contains(method)) {
                    if ("OPTIONS".equals(method)) {
                        String accessControlRequestMethodHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
                        requestType = StringUtils.isNotBlank((CharSequence)accessControlRequestMethodHeader) ? CORSRequestType.PRE_FLIGHT : (StringUtils.isWhitespace((CharSequence)accessControlRequestMethodHeader) ? CORSRequestType.INVALID_CORS : CORSRequestType.ACTUAL);
                    } else if ("GET".equals(method) || "HEAD".equals(method)) {
                        requestType = CORSRequestType.SIMPLE;
                    } else if ("POST".equals(method)) {
                        String contentType = request.getContentType();
                        if (contentType != null) {
                            requestType = SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(contentType = contentType.toLowerCase().trim()) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
                        }
                    } else if (COMPLEX_HTTP_METHODS.contains(method)) {
                        requestType = CORSRequestType.ACTUAL;
                    }
                }
            }
        } else {
            requestType = CORSRequestType.NOT_CORS;
        }
        return requestType;
    }

    private boolean isOriginAllowed(String origin) {
        if (this.anyOriginAllowed) {
            return true;
        }
        return this.allowedOrigins.contains(origin);
    }

    private void log(String message) {
        if (this.loggingEnabled) {
            this.filterConfig.getServletContext().log(message);
        }
    }

    private void parseAndStore(String allowedOrigins, String allowedHttpMethods, String allowedHttpHeaders, String exposedHeaders, String supportsCredentials, String preflightMaxAge, String loggingEnabled, String decorateRequest) throws ServletException {
        if (allowedOrigins != null) {
            if (allowedOrigins.trim().equals(DEFAULT_ALLOWED_ORIGINS)) {
                this.anyOriginAllowed = true;
            } else {
                this.anyOriginAllowed = false;
                Set<String> setAllowedOrigins = this.parseStringToSet(allowedOrigins);
                this.allowedOrigins.clear();
                this.allowedOrigins.addAll(setAllowedOrigins);
            }
        }
        if (allowedHttpMethods != null) {
            Set<String> setAllowedHttpMethods = this.parseStringToSet(allowedHttpMethods);
            this.allowedHttpMethods.clear();
            this.allowedHttpMethods.addAll(setAllowedHttpMethods);
        }
        if (allowedHttpHeaders != null) {
            Set<String> setAllowedHttpHeaders = this.parseStringToSet(allowedHttpHeaders);
            HashSet<String> lowerCaseHeaders = new HashSet<String>();
            for (String header : setAllowedHttpHeaders) {
                String lowerCase = header.toLowerCase();
                lowerCaseHeaders.add(lowerCase);
            }
            this.allowedHttpHeaders.clear();
            this.allowedHttpHeaders.addAll(lowerCaseHeaders);
        }
        if (exposedHeaders != null) {
            Set<String> setExposedHeaders = this.parseStringToSet(exposedHeaders);
            this.exposedHeaders.clear();
            this.exposedHeaders.addAll(setExposedHeaders);
        }
        if (supportsCredentials != null) {
            this.supportsCredentials = Boolean.parseBoolean(supportsCredentials);
        }
        if (preflightMaxAge != null) {
            try {
                this.preflightMaxAge = !preflightMaxAge.isEmpty() ? Long.parseLong(preflightMaxAge) : 0L;
            }
            catch (NumberFormatException e) {
                throw new ServletException("Unable to parse preflightMaxAge", (Throwable)e);
            }
        }
        if (loggingEnabled != null) {
            this.loggingEnabled = Boolean.parseBoolean(loggingEnabled);
        }
        if (decorateRequest != null) {
            this.decorateRequest = Boolean.parseBoolean(decorateRequest);
        }
    }

    private Set<String> parseStringToSet(String data) {
        String[] splits = data != null && data.length() > 0 ? data.split(",") : new String[]{};
        HashSet<String> set = new HashSet<String>();
        if (splits.length > 0) {
            for (String split : splits) {
                set.add(split.trim());
            }
        }
        return set;
    }

    public static boolean isValidOrigin(String origin) {
        URI originURI;
        if (origin.contains("%")) {
            return false;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public boolean isAnyOriginAllowed() {
        return this.anyOriginAllowed;
    }

    public Collection<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public boolean isSupportsCredentials() {
        return this.supportsCredentials;
    }

    public long getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public Collection<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Collection<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public Collection<String> getAllowedHttpHeaders() {
        return this.allowedHttpHeaders;
    }

    public static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

