/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class PasswordAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String PASSWORD = "password";
    private static final String EMAIL = "email";
    public static final String PASSWORD_ACTION = "password_auth";

    public PasswordAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        UserAuthentication userAuth = null;
        User user = null;
        if (requestURI.endsWith(PASSWORD_ACTION)) {
            App app;
            user = new User();
            user.setIdentifier(request.getParameter(EMAIL));
            user.setPassword(request.getParameter(PASSWORD));
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            if (!App.isRoot((String)appid) && (app = (App)Para.getDAO().read(App.id((String)appid))) != null) {
                user.setAppid(app.getAppIdentifier());
            }
            if (User.passwordMatches((User)user) && StringUtils.contains((CharSequence)user.getIdentifier(), (CharSequence)"@")) {
                user = User.readUserForIdentifier((User)user);
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) {
        UserAuthentication userAuth = null;
        User user = new User();
        if (accessToken != null && accessToken.contains(Para.getConfig().separator())) {
            String[] parts = accessToken.split(Para.getConfig().separator(), 3);
            String email = parts[0];
            String name = StringUtils.trimToEmpty((String)parts[1]);
            String pass = parts.length > 2 ? parts[2] : "";
            String appid = app == null ? null : app.getAppIdentifier();
            User u = new User();
            u.setAppid(appid);
            u.setIdentifier(email);
            u.setPassword(pass);
            u.setEmail(email);
            user = User.readUserForIdentifier((User)u);
            if (user == null) {
                user = new User();
                user.setActive(Boolean.valueOf(Boolean.parseBoolean(Para.getConfig().getSettingForApp(app, "security.allow_unverified_emails", Boolean.toString(Para.getConfig().allowUnverifiedEmails())))));
                user.setAppid(appid);
                user.setName(name);
                user.setIdentifier(email);
                user.setEmail(email);
                user.setPassword(pass);
                if (user.create() != null) {
                    userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
                }
            } else if (User.passwordMatches((User)u)) {
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }
}

